/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiQualifiedReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSInheritanceCallEvaluator {
    public static final String EXTEND_METHOD_PART = "extend";
    public static final String IMPLEMENT_METHOD_NAME = "implement";
    private static final String INHERIT_METHOD_PART = "inherit";
    private static final String MERGE_METHOD_NAME = "merge";
    private static final String CREATE_METHOD_PART = "create";

    public static boolean isInheritanceMethodNameCandidate(@NotNull String name) {
        if (name == null) {
            JSInheritanceCallEvaluator.$$$reportNull$$$0(0);
        }
        return "call".equals(name) || "Class".equals(name) || StringUtil.containsIgnoreCase((String)name, (String)EXTEND_METHOD_PART) || StringUtil.containsIgnoreCase((String)name, (String)INHERIT_METHOD_PART) || StringUtil.containsIgnoreCase((String)name, (String)CREATE_METHOD_PART) || StringUtil.equals((CharSequence)name, (CharSequence)IMPLEMENT_METHOD_NAME) || StringUtil.equals((CharSequence)name, (CharSequence)"declare") || StringUtil.equals((CharSequence)name, (CharSequence)MERGE_METHOD_NAME) || StringUtil.equals((CharSequence)name, (CharSequence)"assign") || JSInheritanceCallEvaluator.isFrameworkInheritanceMethod(name);
    }

    private static boolean isFrameworkInheritanceMethod(@NotNull String name) {
        if (name == null) {
            JSInheritanceCallEvaluator.$$$reportNull$$$0(1);
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            for (String method : handler.inheritanceMethodNames()) {
                if (!StringUtil.equals((CharSequence)name, (CharSequence)method)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static JSInheritanceCallResult findInheritance(@NotNull JSCallExpression callExpression) {
        String parentName;
        JSExpression _methodExpression;
        if (callExpression == null) {
            JSInheritanceCallEvaluator.$$$reportNull$$$0(2);
        }
        if (!((_methodExpression = callExpression.getMethodExpression()) instanceof JSReferenceExpression)) {
            return null;
        }
        JSReferenceExpression methodExpression = (JSReferenceExpression)_methodExpression;
        String name = methodExpression.getReferenceName();
        if (name == null) {
            return null;
        }
        if (!JSInheritanceCallEvaluator.isInheritanceMethodNameCandidate(name)) {
            return null;
        }
        JSArgumentList argumentList = callExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        JSExpression[] arguments = argumentList.getArguments();
        if (arguments.length == 0) {
            return null;
        }
        JSExpression firstArgument = arguments[0];
        if (firstArgument == null) {
            return null;
        }
        JSExpression secondArgument = arguments.length >= 2 ? arguments[1] : null;
        JSExpression qualifier = methodExpression.getQualifier();
        if ("call".equals(name) && qualifier != null) {
            if (!(firstArgument instanceof JSThisExpression)) {
                return null;
            }
            if (!(callExpression.getParent() instanceof JSExpressionStatement)) {
                return null;
            }
            return new JSInheritanceCallResult(qualifier, null, firstArgument, JSContext.INSTANCE, false);
        }
        JSQualifiedName qName = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)methodExpression);
        String qualifiedName = qName != null ? qName.getQualifiedName() : null;
        switch (qualifiedName != null ? qualifiedName : "") {
            case "Object.create": {
                return new JSInheritanceCallResult(firstArgument, secondArgument, callExpression, JSContext.STATIC, true);
            }
            case "Ext.extend": {
                return new JSInheritanceCallResult(firstArgument, secondArgument, callExpression, JSContext.INSTANCE, true);
            }
            case "Ext.define": {
                JSContext jsContext = JSContext.INSTANCE;
                if (secondArgument instanceof JSObjectLiteralExpression && ((JSObjectLiteralExpression)secondArgument).findProperty("singleton") != null) {
                    jsContext = JSContext.STATIC;
                }
                return new JSInheritanceCallResult(firstArgument, secondArgument, firstArgument, jsContext, false);
            }
            case "merge": 
            case "Object.extend": 
            case "Object.assign": 
            case "$.extend": 
            case "extend": {
                return new JSInheritanceCallResult(firstArgument, secondArgument, firstArgument, JSContext.STATIC, true);
            }
            case "goog.inherits": 
            case "qx.Class.define": {
                return new JSInheritanceCallResult(callExpression, secondArgument, firstArgument, JSContext.INSTANCE, false);
            }
            case "jQuery.extend": {
                if (secondArgument != null) {
                    return new JSInheritanceCallResult(firstArgument, secondArgument, firstArgument, JSContext.STATIC, true);
                }
            }
            case "jQuery.fn.extend": {
                if (!(qualifier instanceof JSReferenceExpression)) {
                    return null;
                }
                JSExpression qualifierQualifier = ((JSReferenceExpression)qualifier).getQualifier();
                if (qualifierQualifier instanceof JSReferenceExpression) {
                    qualifier = qualifierQualifier;
                }
                return new JSInheritanceCallResult(qualifier, firstArgument, qualifier, JSContext.UNKNOWN, false);
            }
            case "$.widget": 
            case "_.extend": 
            case "dojo.declare": {
                if (secondArgument == null) {
                    return null;
                }
                JSExpression thirdArgument = arguments.length >= 3 ? arguments[2] : null;
                return thirdArgument != null ? new JSInheritanceCallResult(secondArgument, thirdArgument, firstArgument, JSContext.INSTANCE, false) : new JSInheritanceCallResult(firstArgument, secondArgument, firstArgument, JSContext.INSTANCE, false);
            }
        }
        if (name.equals("createClass") || "createReactClass".equals(qualifiedName)) {
            return new JSInheritanceCallResult(callExpression, firstArgument, callExpression, JSContext.INSTANCE, true);
        }
        if ("Class".equals(qualifiedName) && callExpression instanceof JSNewExpression) {
            return new JSInheritanceCallResult(callExpression, firstArgument, callExpression, JSContext.INSTANCE, true);
        }
        String string = parentName = qualifier instanceof JSReferenceExpression ? ((JSReferenceExpression)qualifier).getReferenceName() : null;
        if (parentName != null && EXTEND_METHOD_PART.equals(name) && (parentName.equals("dojo") || parentName.equals("YAHOO") || parentName.equals("lang"))) {
            return new JSInheritanceCallResult(firstArgument, secondArgument, firstArgument, JSContext.INSTANCE, true);
        }
        if ("Class.create".equals(qualifiedName) || "Class.extend".equals(qualifiedName)) {
            return firstArgument instanceof JSObjectLiteralExpression ? new JSInheritanceCallResult(callExpression, firstArgument, callExpression, JSContext.INSTANCE, true) : new JSInheritanceCallResult(firstArgument, secondArgument, callExpression, JSContext.INSTANCE, true);
        }
        if (IMPLEMENT_METHOD_NAME.equals(name) && qualifier instanceof JSReferenceExpression && arguments.length == 1) {
            return new JSInheritanceCallResult(qualifier, firstArgument, qualifier, JSContext.INSTANCE, true);
        }
        if (EXTEND_METHOD_PART.equals(name) && qualifier instanceof JSReferenceExpression && arguments.length == 1) {
            boolean modify = callExpression.getParent() instanceof JSExpressionStatement;
            return new JSInheritanceCallResult(qualifier, firstArgument, modify ? qualifier : callExpression, modify ? JSContext.UNKNOWN : JSContext.INSTANCE, true);
        }
        JSQualifiedNamedElement initializedElement = JSPsiImplUtils.getInitializedElement(callExpression);
        if (initializedElement instanceof JSProperty && "propTypes".equals(initializedElement.getName())) {
            return null;
        }
        if (StringUtil.containsIgnoreCase((String)name, (String)EXTEND_METHOD_PART) || StringUtil.containsIgnoreCase((String)name, (String)INHERIT_METHOD_PART)) {
            return new JSInheritanceCallResult(firstArgument, secondArgument, firstArgument, JSContext.UNKNOWN, false);
        }
        if (arguments.length == 2 && firstArgument instanceof JSLiteralExpression && secondArgument instanceof JSObjectLiteralExpression) {
            return new JSInheritanceCallResult(firstArgument, secondArgument, firstArgument, JSContext.INSTANCE, false);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/index/JSInheritanceCallEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInheritanceMethodNameCandidate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFrameworkInheritanceMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findInheritance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class JSInheritanceCallResult {
        @NotNull
        public final JSExpression base;
        @Nullable
        public final JSExpression mixed;
        @NotNull
        public final JSExpression destination;
        @NotNull
        public final JSContext context;
        public final boolean isCallExpressionMatchesDestination;

        public JSInheritanceCallResult(@NotNull JSExpression base, @Nullable JSExpression mixed, @NotNull JSExpression destination, @NotNull JSContext context2, boolean isCallExpressionMatchesDestination) {
            if (base == null) {
                JSInheritanceCallResult.$$$reportNull$$$0(0);
            }
            if (destination == null) {
                JSInheritanceCallResult.$$$reportNull$$$0(1);
            }
            if (context2 == null) {
                JSInheritanceCallResult.$$$reportNull$$$0(2);
            }
            this.base = base;
            this.mixed = mixed;
            this.destination = destination;
            this.context = context2;
            this.isCallExpressionMatchesDestination = isCallExpressionMatchesDestination;
        }

        @Nullable
        public JSNamespace evaluateOrFindDestinationNamespace(@NotNull JSCallExpression callExpression) {
            String s;
            if (callExpression == null) {
                JSInheritanceCallResult.$$$reportNull$$$0(3);
            }
            JSNamespace destinationNs = null;
            if (this.destination != callExpression && !(this.destination instanceof JSNewExpression)) {
                destinationNs = JSSymbolUtil.evaluateNamespaceLocally(this.destination);
            }
            if (destinationNs == null && (s = JSSymbolUtil.getQualifierOfExprAsString(this.destination)) != null) {
                return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromQualifiedName(s), this.context, (PsiElement)this.destination, false, true);
            }
            if (destinationNs == null && this.isCallExpressionMatchesDestination && (destinationNs = JSInheritanceCallResult.getInitializedNamespace(callExpression)) != null && this.context != JSContext.STATIC) {
                destinationNs = destinationNs.copyWithTypeContext(JSTypeContext.fromJSContext(this.context, true));
            }
            if (destinationNs != null) {
                destinationNs = JSNamedTypeFactory.copyWithJSContext(destinationNs, JSTypeUtils.combineJSContexts(destinationNs.getJSContext(), this.context));
            }
            return destinationNs;
        }

        @Nullable
        private static JSNamespace getInitializedNamespace(@NotNull JSExpression expression) {
            JSQualifiedNamedElement initializedElement;
            if (expression == null) {
                JSInheritanceCallResult.$$$reportNull$$$0(4);
            }
            if ((initializedElement = JSPsiImplUtils.getInitializedElement(expression)) instanceof JSDefinitionExpression || initializedElement instanceof JSVariable) {
                return JSNamedTypeFactory.buildProvidedNamespace(initializedElement, true);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destination";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/index/JSInheritanceCallEvaluator$JSInheritanceCallResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluateOrFindDestinationNamespace";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInitializedNamespace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

