/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTokenType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnterminatedStatementJSInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreSemicolonAtEndOfBlock = true;

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            UnterminatedStatementJSInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            UnterminatedStatementJSInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(this.ignoreSemicolonAtEndOfBlock, holder);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreSemicolonAtEndOfBlock", (String)InspectionJSBundle.message("unterminated.statement.ignore.atend.of.block", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnterminatedStatementJSInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @Nullable
    private static PsiElement nextCodeLeaf(@NotNull JSStatement statement) {
        if (statement == null) {
            UnterminatedStatementJSInspection.$$$reportNull$$$0(3);
        }
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)statement);
        while (nextLeaf != null && !UnterminatedStatementJSInspection.isJSCodeElement(nextLeaf)) {
            nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
        }
        return nextLeaf;
    }

    private static boolean isJSCodeElement(@NotNull PsiElement element) {
        if (element == null) {
            UnterminatedStatementJSInspection.$$$reportNull$$$0(4);
        }
        return !(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nextCodeLeaf";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isJSCodeElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class Visitor
    extends JSElementVisitor {
        private final boolean ignoreSemicolonAtEndOfBlock;
        private final ProblemsHolder myProblemsHolder;

        Visitor(boolean ignoreSemicolonAtEndOfBlock, ProblemsHolder problemsHolder) {
            this.ignoreSemicolonAtEndOfBlock = ignoreSemicolonAtEndOfBlock;
            this.myProblemsHolder = problemsHolder;
        }

        @Override
        public void visitJSCallExpression(@NotNull JSCallExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSCallExpression(node);
            this.reportPossibleUnterminatedStatement((PsiElement)node.getMethodExpression(), (Condition<PsiElement>)((Condition)expression -> expression instanceof JSObjectLiteralExpression || expression instanceof JSFunctionExpression || expression instanceof JSLiteralExpression || expression instanceof JSArrayLiteralExpression));
        }

        @Override
        public void visitJSIndexedPropertyAccessExpression(@NotNull JSIndexedPropertyAccessExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitJSIndexedPropertyAccessExpression(node);
            this.reportPossibleUnterminatedStatement((PsiElement)node.getQualifier(), (Condition<PsiElement>)((Condition)expression -> expression instanceof JSObjectLiteralExpression || expression instanceof JSFunctionExpression || expression instanceof JSLiteralExpression));
        }

        @Override
        public void visitJSStatement(@NotNull JSStatement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitJSStatement(node);
            if (!JSUtils.statementRequiresSemicolon(node) || node instanceof JSEmptyStatement) {
                return;
            }
            if (this.isTerminated(node) || node instanceof JSExpressionStatement && node.getContainingFile() instanceof JSExpressionCodeFragment) {
                return;
            }
            this.reportUnterminatedStatement(node);
        }

        @Override
        public void visitES6TaggedTemplateExpression(@NotNull ES6TaggedTemplateExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            super.visitES6TaggedTemplateExpression(expression);
            JSExpression tag = expression.getTag();
            if (tag != null) {
                this.reportPossibleUnterminatedStatement((PsiElement)tag, (Condition<PsiElement>)((Condition)theTag -> theTag instanceof JSLiteralExpression || theTag instanceof JSObjectLiteralExpression || theTag instanceof JSArrayLiteralExpression));
            }
        }

        private void reportPossibleUnterminatedStatement(@Nullable PsiElement target2, Condition<PsiElement> isSuspiciousType) {
            if (target2 == null || !isSuspiciousType.value((Object)target2)) {
                return;
            }
            PsiElement leaf = PsiTreeUtil.nextLeaf((PsiElement)target2);
            while (leaf != null && !UnterminatedStatementJSInspection.isJSCodeElement(leaf)) {
                if (leaf.textContains('\n')) {
                    String message = InspectionJSBundle.message("unterminated.statement.possibly.unterminated.statement.error", new Object[0]);
                    TerminateStatementFix fix = new TerminateStatementFix(target2);
                    ProblemDescriptor problemDescriptor = this.createProblemDescriptorAfter(target2, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                    this.myProblemsHolder.registerProblem(problemDescriptor);
                    break;
                }
                leaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
            }
        }

        protected void reportUnterminatedStatement(JSStatement statement) {
            PsiFile file = statement.getContainingFile();
            PsiElement context2 = file.getContext();
            if (context2 != null && !context2.textContains('\n')) {
                return;
            }
            TerminateStatementFix fix = new TerminateStatementFix((PsiElement)statement);
            ProblemDescriptor problemDescriptor = this.createProblemDescriptorAfter((PsiElement)statement, InspectionJSBundle.message("unterminated.statement.error.string", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
            this.myProblemsHolder.registerProblem(problemDescriptor);
        }

        private boolean isTerminated(@NotNull JSStatement statement) {
            boolean terminated;
            JSLanguageDialect dialect;
            if (statement == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if ((dialect = DialectDetector.languageDialectOfElement((PsiElement)statement)) == null || !JSInheritedLanguagesHelper.isNeedToBeTerminated((PsiElement)statement)) {
                return true;
            }
            JSCodeStyleSettings codeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)statement);
            if (!codeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT) {
                return true;
            }
            boolean bl = terminated = PsiUtilCore.getElementType((PsiElement)statement.getLastChild()) == JSTokenTypes.SEMICOLON;
            if (!terminated) {
                PsiElement nextLeaf = UnterminatedStatementJSInspection.nextCodeLeaf(statement);
                if (nextLeaf != null) {
                    IElementType type2;
                    ASTNode nextLeafNode = nextLeaf.getNode();
                    IElementType iElementType = type2 = nextLeafNode != null ? nextLeafNode.getElementType() : null;
                    if (type2 == JSTokenTypes.RBRACE || type2 == XmlTokenType.XML_END_TAG_START || type2 == XmlTokenType.XML_TAG_END || type2 == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                        return this.ignoreSemicolonAtEndOfBlock;
                    }
                } else if (InjectedLanguageManager.getInstance((Project)statement.getContainingFile().getProject()).getInjectionHost((PsiElement)statement.getContainingFile()) != null) {
                    return this.ignoreSemicolonAtEndOfBlock;
                }
            }
            return terminated;
        }

        @NotNull
        protected ProblemDescriptor createProblemDescriptorAfter(@NotNull PsiElement location, @NotNull @InspectionMessage String description, @NotNull ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
            TextRange rangeInElement;
            PsiElement element;
            boolean afterEOL;
            if (location == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (description == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (highlightType == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            if (fixes == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)location);
            while (nextLeaf != null && nextLeaf.getTextLength() == 0 || nextLeaf instanceof PsiErrorElement) {
                nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
            }
            if (nextLeaf == null || nextLeaf.getText().startsWith("\n")) {
                afterEOL = true;
                element = BaseInspectionVisitor.findValidEditorLocation(location);
                rangeInElement = new TextRange(element.getTextLength(), element.getTextLength());
            } else {
                afterEOL = false;
                element = nextLeaf;
                rangeInElement = new TextRange(0, 1);
            }
            return new ProblemDescriptorBase(element, element, description, fixes, highlightType, afterEOL, rangeInElement, true, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightType";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSIndexedPropertyAccessExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitES6TaggedTemplateExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isTerminated";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createProblemDescriptorAfter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TerminateStatementFix
    extends LocalQuickFixOnPsiElement {
        protected TerminateStatementFix(@NotNull PsiElement element) {
            if (element == null) {
                TerminateStatementFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("terminate.statement.fix", new Object[0]);
            if (string == null) {
                TerminateStatementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                TerminateStatementFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                TerminateStatementFix.$$$reportNull$$$0(3);
            }
            if (file == null) {
                TerminateStatementFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                TerminateStatementFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                TerminateStatementFix.$$$reportNull$$$0(6);
            }
            if (startElement instanceof JSStatement) {
                startElement.getNode().addLeaf(JSTokenTypes.SEMICOLON, (CharSequence)";", null);
            } else {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                Document document = documentManager.getDocument(file);
                if (document == null) {
                    return;
                }
                document.insertString(startElement.getTextOffset() + startElement.getTextLength(), (CharSequence)";");
                documentManager.commitDocument(document);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$TerminateStatementFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$TerminateStatementFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

