/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAnonymousToNamedFunctionIntention
extends JavaScriptIntention {
    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(0);
        }
        return currentFile;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(2);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSFunctionExpression functionExpression = JSAnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element);
        if (functionExpression == null) {
            return false;
        }
        this.setText(JSUtils.isMember((PsiElement)functionExpression.getElementAssignedTo()) && JSClassUtils.isES6ClassImplementation(functionExpression) ? JavaScriptBundle.message("js.convert.to.named.function.to.class.method", new Object[0]) : JavaScriptBundle.message("js.convert.to.named.function", new Object[0]));
        return true;
    }

    @Nullable
    public static JSFunctionExpression getWrappingAnonymousFunction(@NotNull PsiElement element) {
        JSFunctionExpression functionExpression;
        if (element == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(3);
        }
        if ((functionExpression = JSAnonymousToNamedFunctionIntention.getFunctionExpression(element)) == null) {
            return null;
        }
        ASTNode nameNode = JSPsiImplUtils.findNameIdentifierOfFunction(functionExpression.getNode(), true);
        return nameNode == null ? functionExpression : null;
    }

    static JSFunctionExpression getFunctionExpression(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(4);
        }
        if ((parent = element.getParent()) instanceof JSParameter) {
            parent = parent.getParent();
        }
        if (parent instanceof JSParameterList) {
            parent = parent.getParent();
        }
        if (parent instanceof JSFunctionExpression) {
            return (JSFunctionExpression)parent;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        boolean isEs6ClassMember;
        JSFunctionExpression functionExpression;
        if (project == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(6);
        }
        if ((functionExpression = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunctionExpression.class)) == null) {
            return;
        }
        String functionName = null;
        JSQualifiedNamedElement parentNamedElement = functionExpression.getElementAssignedTo();
        boolean bl = isEs6ClassMember = JSUtils.isMember((PsiElement)parentNamedElement) && JSClassUtils.isES6ClassImplementation(functionExpression);
        if (parentNamedElement instanceof JSVariable && (isEs6ClassMember || ((JSVariable)parentNamedElement).isConst())) {
            functionName = functionExpression.getName();
        }
        if (StringUtil.isEmpty(functionName)) {
            GetFunctionNameDialog dialog;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                functionName = "foo";
            } else if (StringUtil.isEmpty((String)functionName) && (dialog = new GetFunctionNameDialog(functionExpression, functionExpression.getName())).showAndGet()) {
                functionName = dialog.getFunctionName();
            }
        }
        List<JSReferenceExpression> usagesToUpdate = ContainerUtil.emptyList();
        if (isEs6ClassMember && functionExpression.isArrowFunction() && (usagesToUpdate = JSAnonymousToNamedFunctionIntention.findNonCallUsages(parentNamedElement)) == null) {
            return;
        }
        if (functionName != null) {
            String finalFunctionName = functionName;
            List<JSReferenceExpression> finalUsagesToUpdate = usagesToUpdate;
            ApplicationManager.getApplication().runWriteAction(() -> JSAnonymousToNamedFunctionIntention.performRefactoring(functionExpression, parentNamedElement, finalFunctionName, isEs6ClassMember, finalUsagesToUpdate));
        }
    }

    private static void performRefactoring(@NotNull JSFunctionExpression functionExpression, @Nullable JSQualifiedNamedElement parentNamedElement, @NotNull String functionName, boolean isES6ClassMember, @NotNull List<JSReferenceExpression> usagesToReplaceWithBind) {
        JSFunction newFunction;
        if (functionExpression == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(7);
        }
        if (functionName == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(8);
        }
        if (usagesToReplaceWithBind == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(9);
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment(functionExpression);
        if (isES6ClassMember) {
            JSVarStatement fieldStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)parentNamedElement, JSVarStatement.class);
            assert (fieldStatement != null);
            newFunction = JSFunctionsRefactoringUtil.createClassMember(functionExpression, functionName);
            JSRefactoringUtil.copyDecorators((JSAttributeListOwner)((Object)parentNamedElement), newFunction);
            newFunction = (JSFunction)fieldStatement.getParent().addBefore((PsiElement)newFunction, (PsiElement)fieldStatement);
            fieldStatement.delete();
            for (JSReferenceExpression referenceExpression : usagesToReplaceWithBind) {
                JSExpression qualifier = referenceExpression.getQualifier();
                assert (qualifier != null);
                String replacementText = referenceExpression.getText() + ".bind(" + qualifier.getText() + ")";
                referenceExpression.replace(JSPsiElementFactory.createJSExpression(replacementText, (PsiElement)referenceExpression));
            }
        } else {
            newFunction = JSFunctionsRefactoringUtil.createFunctionDeclaration(functionExpression, functionName);
            newFunction = JSAnonymousToNamedFunctionIntention.addNewFunctionAndReplaceExpression(functionExpression, newFunction, parentNamedElement, functionName);
        }
        if (docComment != null) {
            JSDocumentationUtils.moveJSDoc(docComment, newFunction);
        }
        FormatFixer.create(newFunction, FormatFixer.Mode.Reformat).fixFormat();
    }

    private static JSFunction addNewFunctionAndReplaceExpression(@NotNull JSFunctionExpression functionExpression, @NotNull JSFunction newPsiElementFunction, @Nullable JSQualifiedNamedElement parentNamedElement, @NotNull String name) {
        if (functionExpression == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(10);
        }
        if (newPsiElementFunction == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(11);
        }
        if (name == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(12);
        }
        JSSourceElement anchor = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)functionExpression, (Class[])new Class[]{JSFunction.class, JSStatement.class});
        assert (anchor != null);
        if (parentNamedElement instanceof JSVariable && name.equals(parentNamedElement.getName())) {
            newPsiElementFunction = (JSFunction)anchor.getParent().addAfter((PsiElement)newPsiElementFunction, (PsiElement)anchor);
            parentNamedElement.delete();
        } else {
            newPsiElementFunction = (JSFunction)anchor.getParent().addAfter((PsiElement)newPsiElementFunction, (PsiElement)anchor);
            JSAnonymousToNamedFunctionIntention.replaceFunctionExpressionWithReference(functionExpression, newPsiElementFunction);
        }
        return newPsiElementFunction;
    }

    private static void replaceFunctionExpressionWithReference(@NotNull JSFunctionExpression functionExpression, @NotNull JSFunction newFunction) {
        if (functionExpression == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(13);
        }
        if (newFunction == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(14);
        }
        JSChangeUtil.addWs(newFunction.getParent().getNode(), newFunction.getNode(), "\n");
        JSReferenceExpression referenceExpression = JSPsiElementFactory.createJSExpression(newFunction.getName(), functionExpression, JSReferenceExpression.class);
        JSChangeUtil.replaceExpression(functionExpression, referenceExpression);
    }

    @Nullable
    private static List<JSReferenceExpression> findNonCallUsages(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(15);
        }
        ArrayList<JSReferenceExpression> result2 = new ArrayList<JSReferenceExpression>();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> ReferencesSearch.search((PsiElement)element, (SearchScope)element.getUseScope()).asIterable().forEach(reference -> {
            if (reference instanceof JSReferenceExpression && !(JSUtils.getParentSkipParentheses((PsiElement)reference) instanceof JSCallExpression)) {
                result2.add((JSReferenceExpression)reference);
            }
        })), JavaScriptBundle.message("javascript.refactoring.searching.usages", new Object[0]), true, element.getProject())) {
            return null;
        }
        return result2;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.anonymous.to.named.function", new Object[0]);
        if (string == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionExpression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesToReplaceWithBind";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPsiElementFunction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFunction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSAnonymousToNamedFunctionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSAnonymousToNamedFunctionIntention";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWrappingAnonymousFunction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionExpression";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addNewFunctionAndReplaceExpression";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceFunctionExpressionWithReference";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findNonCallUsages";
                break;
            }
            case 16: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16 -> new IllegalStateException(string);
        };
    }

    private class GetFunctionNameDialog
    extends DialogWrapper {
        private final JTextField myTextField;
        private final PsiElement myContext;
        private final String myDefaultName;

        protected GetFunctionNameDialog(PsiElement context2, String defaultName) {
            super(context2.getProject());
            this.myTextField = new JTextField();
            this.myContext = context2;
            this.myDefaultName = defaultName;
            this.setTitle(StringUtil.capitalizeWords((String)JSAnonymousToNamedFunctionIntention.this.getText(), (boolean)true));
            this.updateOkAction();
            this.init();
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(7, 2, 5, 2));
            JLabel label = new JLabel(JavaScriptBundle.message("anonymous.to.named.intention.function.name", new Object[0]));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            panel.add((Component)label, "First");
            label.setLabelFor(this.myTextField);
            panel.add((Component)this.myTextField, "Last");
            this.myTextField.setPreferredSize(new Dimension(200, this.myTextField.getPreferredSize().height));
            if (this.myDefaultName != null) {
                this.myTextField.setText(this.myDefaultName);
                this.updateOkAction();
            }
            this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    GetFunctionNameDialog.this.updateOkAction();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/intentions/JSAnonymousToNamedFunctionIntention$GetFunctionNameDialog$1", "textChanged"));
                }
            });
            return panel;
        }

        private void updateOkAction() {
            String text = this.myTextField.getText();
            this.getOKAction().setEnabled(!text.isEmpty() && this.isNameValid(text));
        }

        private boolean isNameValid(String text) {
            return LanguageNamesValidation.isIdentifier((Language)this.myContext.getLanguage(), (String)text, (Project)this.myContext.getProject());
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myTextField;
        }

        public String getFunctionName() {
            return this.myTextField.getText();
        }
    }
}

