/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.rhino;

import com.google.common.base.Supplier;
import com.intellij.lang.javascript.linter.rhino.FunctionWithScope;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoFunctionManager {
    private static final Logger LOG = Logger.getInstance(RhinoFunctionManager.class);
    private final ThreadLocal<FunctionWithScope> myThreadLocalFunction;
    private volatile Script myScript;
    private final Supplier<String> myScriptSourceProvider;
    private final String myFunctionName;
    private final String myVersion;

    public RhinoFunctionManager(@NotNull Supplier<String> scriptSourceProvider, @NotNull String functionName, @Nullable String version2) {
        if (scriptSourceProvider == null) {
            RhinoFunctionManager.$$$reportNull$$$0(0);
        }
        if (functionName == null) {
            RhinoFunctionManager.$$$reportNull$$$0(1);
        }
        this.myThreadLocalFunction = new ThreadLocal<FunctionWithScope>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected FunctionWithScope initialValue() {
                if (RhinoFunctionManager.this.myScript == null) {
                    ThreadLocal<FunctionWithScope> threadLocal = RhinoFunctionManager.this.myThreadLocalFunction;
                    synchronized (threadLocal) {
                        if (RhinoFunctionManager.this.myScript == null) {
                            RhinoFunctionManager.this.myScript = RhinoFunctionManager.this.compileScript(9);
                        }
                    }
                }
                return RhinoFunctionManager.this.extractFunctionWithScope(RhinoFunctionManager.this.myScript);
            }
        };
        this.myScriptSourceProvider = scriptSourceProvider;
        this.myFunctionName = functionName;
        this.myVersion = version2;
    }

    @NotNull
    public String getFunctionName() {
        String string = this.myFunctionName;
        if (string == null) {
            RhinoFunctionManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Script compileScript(int optimizationLevel) {
        long startNano = System.nanoTime();
        Context context2 = Context.enter();
        try {
            context2.setOptimizationLevel(optimizationLevel);
            String scriptSource = (String)this.myScriptSourceProvider.get();
            Script script = context2.compileString(scriptSource, "<" + this.myFunctionName + " script>", 1, null);
            return script;
        }
        finally {
            Context.exit();
            LOG.info(RhinoFunctionManager.formatMessage(startNano, this.prependVersion("script rhino compilation")));
        }
    }

    @NotNull
    private String prependVersion(@NotNull String message) {
        if (message == null) {
            RhinoFunctionManager.$$$reportNull$$$0(3);
        }
        StringBuilder out = new StringBuilder(this.myFunctionName).append(" ");
        if (this.myVersion != null) {
            out.append(this.myVersion).append(" ");
        }
        out.append(message);
        String string = out.toString();
        if (string == null) {
            RhinoFunctionManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private FunctionWithScope extractFunctionWithScope(@NotNull Script script) {
        if (script == null) {
            RhinoFunctionManager.$$$reportNull$$$0(5);
        }
        long startNano = System.nanoTime();
        Context context2 = Context.enter();
        ScriptableObject scope2 = context2.initStandardObjects();
        script.exec(context2, (Scriptable)scope2);
        Object jsLintObj = scope2.get(this.myFunctionName, (Scriptable)scope2);
        if (!(jsLintObj instanceof Function)) throw new RuntimeException(this.prependVersion("is undefined or not a function."));
        Function jsLint = (Function)jsLintObj;
        FunctionWithScope functionWithScope = new FunctionWithScope(jsLint, (Scriptable)scope2);
        FunctionWithScope functionWithScope2 = functionWithScope;
        if (functionWithScope2 != null) return functionWithScope2;
        RhinoFunctionManager.$$$reportNull$$$0(6);
        return functionWithScope2;
        finally {
            Context.exit();
            LOG.info(RhinoFunctionManager.formatMessage(startNano, this.prependVersion("function extraction")));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String formatMessage(long startTimeNano, @NotNull String string) {
        void actionName;
        if (string == null) {
            RhinoFunctionManager.$$$reportNull$$$0(7);
        }
        long nanoDuration = System.nanoTime() - startTimeNano;
        return String.format("[%s] %s took %.2f ms", Thread.currentThread().getName(), actionName, (double)nanoDuration / 1000000.0);
    }

    @NotNull
    public FunctionWithScope getFunctionWithScope() {
        FunctionWithScope functionWithScope = this.myThreadLocalFunction.get();
        if (functionWithScope == null) {
            RhinoFunctionManager.$$$reportNull$$$0(8);
        }
        return functionWithScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptSourceProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/rhino/RhinoFunctionManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/rhino/RhinoFunctionManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prependVersion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "extractFunctionWithScope";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionWithScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prependVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractFunctionWithScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8 -> new IllegalStateException(string);
        };
    }
}

