/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.OutdatedCredentialsType;
import com.intellij.remote.RemoteCredentialException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.SshConfigCredentialsHolder;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ext.PathsBrowserDialogProvider;
import com.intellij.remote.ext.WebDeploymentCredentialsHandler;
import com.intellij.remote.ui.BundleAccessor;
import com.intellij.remote.ui.CredentialsEditorProvider;
import com.intellij.remote.ui.RemoteSdkEditorForm;
import com.intellij.util.text.StringKt;
import com.jetbrains.plugins.remotesdk.RemoteCredentialsProducer;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.SshConfigCredentialsType;
import com.jetbrains.plugins.remotesdk.WebDeploymentCredentialsLanguageContributor;
import com.jetbrains.plugins.remotesdk.ui.SshBrowseActionListenerUtil;
import com.jetbrains.plugins.remotesdk.ui.WebDeploymentCredentialsEditor;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.function.Supplier;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005:\u0001*B\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\b\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012H\u0016J*\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J7\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001f\u001a\u00020 2\u000b\u0010!\u001a\u00070\u001a\u00a2\u0006\u0002\b\"2\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0$H\u0016J,\u0010&\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0001\u0012\u0004\u0012\u00020\u00060'2\u0006\u0010\r\u001a\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010(\u001a\u00020)H\u0016\u00a8\u0006+"}, d2={"Lcom/jetbrains/plugins/remotesdk/WebDeploymentCredentialsType;", "Lcom/intellij/remote/CredentialsType;", "Lcom/intellij/remote/WebDeploymentCredentialsHolder;", "Lcom/intellij/remote/ui/CredentialsEditorProvider;", "Lcom/intellij/remote/ext/PathsBrowserDialogProvider;", "Lcom/intellij/remote/OutdatedCredentialsType;", "Lcom/intellij/remote/SshConfigCredentialsHolder;", "<init>", "()V", "getCredentialsKey", "Lcom/intellij/openapi/util/Key;", "getHandler", "Lcom/intellij/remote/ext/WebDeploymentCredentialsHandler;", "credentials", "createCredentials", "isAvailable", "", "languageContribution", "Lcom/intellij/remote/ext/CredentialsLanguageContribution;", "createEditor", "Lcom/intellij/remote/ext/CredentialsEditor;", "project", "Lcom/intellij/openapi/project/Project;", "parentForm", "Lcom/intellij/remote/ui/RemoteSdkEditorForm;", "getDefaultInterpreterPath", "", "bundleAccessor", "Lcom/intellij/remote/ui/BundleAccessor;", "showPathsBrowserDialog", "", "textField", "Ljavax/swing/JTextField;", "dialogTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "supplier", "Ljava/util/function/Supplier;", "Lcom/intellij/remote/RemoteSdkAdditionalData;", "transformToNewerType", "Lkotlin/Pair;", "getWeight", "", "Companion", "intellij.remoteRun"})
public final class WebDeploymentCredentialsType
extends CredentialsType<WebDeploymentCredentialsHolder>
implements CredentialsEditorProvider,
PathsBrowserDialogProvider,
OutdatedCredentialsType<SshConfigCredentialsHolder, WebDeploymentCredentialsHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SFTP_DEPLOYMENT_PREFIX = "sftp://";
    @NotNull
    private static final Key<WebDeploymentCredentialsHolder> WEB_DEPLOYMENT_BASED_CREDENTIALS;

    public WebDeploymentCredentialsType() {
        super(RemoteSdkBundle.message("web.deployment", new Object[0]), SFTP_DEPLOYMENT_PREFIX);
    }

    @NotNull
    public Key<WebDeploymentCredentialsHolder> getCredentialsKey() {
        return WEB_DEPLOYMENT_BASED_CREDENTIALS;
    }

    @NotNull
    public WebDeploymentCredentialsHandler getHandler(@NotNull WebDeploymentCredentialsHolder credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        return new WebDeploymentCredentialsHandler(credentials);
    }

    @NotNull
    public WebDeploymentCredentialsHolder createCredentials() {
        return new WebDeploymentCredentialsHolder();
    }

    public boolean isAvailable(@Nullable CredentialsLanguageContribution<?> languageContribution) {
        return languageContribution instanceof WebDeploymentCredentialsLanguageContributor;
    }

    @NotNull
    public CredentialsEditor<?> createEditor(@Nullable Project project, @NotNull CredentialsLanguageContribution<?> languageContribution, @NotNull RemoteSdkEditorForm parentForm) {
        Intrinsics.checkNotNullParameter(languageContribution, (String)"languageContribution");
        Intrinsics.checkNotNullParameter((Object)parentForm, (String)"parentForm");
        return new WebDeploymentCredentialsEditor(project, parentForm);
    }

    @NotNull
    public String getDefaultInterpreterPath(@NotNull BundleAccessor bundleAccessor) {
        Intrinsics.checkNotNullParameter((Object)bundleAccessor, (String)"bundleAccessor");
        String string = bundleAccessor.message("remote.interpreter.default.interpreter.path", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void showPathsBrowserDialog(@Nullable Project project, @NotNull JTextField textField, @NotNull String dialogTitle, @NotNull Supplier<? extends RemoteSdkAdditionalData> supplier) {
        Intrinsics.checkNotNullParameter((Object)textField, (String)"textField");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        SshBrowseActionListenerUtil.showBrowseDialog(project, textField, dialogTitle, false, supplier);
    }

    @NotNull
    public Pair<CredentialsType<SshConfigCredentialsHolder>, SshConfigCredentialsHolder> transformToNewerType(@NotNull WebDeploymentCredentialsHolder credentials, @Nullable Project project) {
        WebServerConfig webServerConfig;
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        WebServerConfig webServerConfig2 = GroupedServersConfigManager.getInstance((Project)project).findServer(credentials.getWebServerConfigId());
        return new Pair((Object)SshConfigCredentialsType.getInstance(), (Object)new SshConfigCredentialsHolder((webServerConfig = webServerConfig2) != null && (webServerConfig = webServerConfig.getFileTransferConfig()) != null ? webServerConfig.getSshPresentableId() : null));
    }

    public int getWeight() {
        return 15;
    }

    @JvmStatic
    @NotNull
    public static final WebDeploymentCredentialsType getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final RemoteCredentials createRemoteCredentials(@Nullable Project project, @NotNull WebDeploymentCredentialsHolder cred) {
        return Companion.createRemoteCredentials(project, cred);
    }

    static {
        Key key = Key.create((String)"WEB_DEPLOYMENT_BASED_CREDENTIALS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        WEB_DEPLOYMENT_BASED_CREDENTIALS = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/plugins/remotesdk/WebDeploymentCredentialsType$Companion;", "", "<init>", "()V", "SFTP_DEPLOYMENT_PREFIX", "", "WEB_DEPLOYMENT_BASED_CREDENTIALS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/remote/WebDeploymentCredentialsHolder;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getWEB_DEPLOYMENT_BASED_CREDENTIALS", "()Lcom/intellij/openapi/util/Key;", "getInstance", "Lcom/jetbrains/plugins/remotesdk/WebDeploymentCredentialsType;", "createRemoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "project", "Lcom/intellij/openapi/project/Project;", "cred", "intellij.remoteRun"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<WebDeploymentCredentialsHolder> getWEB_DEPLOYMENT_BASED_CREDENTIALS() {
            return WEB_DEPLOYMENT_BASED_CREDENTIALS;
        }

        @JvmStatic
        @NotNull
        public final WebDeploymentCredentialsType getInstance() {
            return (WebDeploymentCredentialsType)((Object)CredentialsType.EP_NAME.findExtensionOrFail(WebDeploymentCredentialsType.class));
        }

        @JvmStatic
        @NotNull
        public final RemoteCredentials createRemoteCredentials(@Nullable Project project, @NotNull WebDeploymentCredentialsHolder cred) {
            Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
            String string = StringKt.nullize$default((String)cred.getWebServerConfigId(), (boolean)false, (int)1, null);
            if (string == null) {
                throw new RemoteCredentialException("Deployment server is not configured");
            }
            String webServerConfigId = string;
            RemoteCredentials remoteCredentials = RemoteCredentialsProducer.getCredentialsBySftpServerId(project, webServerConfigId);
            if (remoteCredentials == null) {
                throw new RemoteCredentialException("Can't get remote credentials for deployment server " + cred.getWebServerConfigName());
            }
            return remoteCredentials;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

