/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml.ngram;

import com.intellij.completion.ngram.slp.modeling.ngram.NGramModel;
import com.intellij.completion.ngram.slp.translating.Vocabulary;
import com.intellij.internal.ml.ngram.NGramRecentTokens;
import com.intellij.internal.ml.ngram.NGramRecentTokensSequence;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001dJ\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J$\u0010\"\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u001b0$j\b\u0012\u0004\u0012\u00020\u001b`%\u0012\u0004\u0012\u00020\u00040#H\u0002J\u0016\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002J\u0016\u0010)\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020/H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00061"}, d2={"Lcom/intellij/internal/ml/ngram/VocabularyWithLimit;", "Lcom/intellij/completion/ngram/slp/translating/Vocabulary;", "Ljava/io/Externalizable;", "maxVocabularySize", "", "nGramOrder", "maxSequenceSize", "sequenceInitialSize", "<init>", "(IIII)V", "getMaxVocabularySize", "()I", "setMaxVocabularySize", "(I)V", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "recent", "Lcom/intellij/internal/ml/ngram/NGramRecentTokens;", "getRecent", "()Lcom/intellij/internal/ml/ngram/NGramRecentTokens;", "recentSequence", "Lcom/intellij/internal/ml/ngram/NGramRecentTokensSequence;", "getRecentSequence", "()Lcom/intellij/internal/ml/ngram/NGramRecentTokensSequence;", "toExistingIndices", "", "token", "", "toExistingIndex", "(Ljava/lang/String;)Ljava/lang/Integer;", "toIndicesWithLimit", "model", "Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel;", "toIndexWithLimit", "trimRecentTokensSize", "Lkotlin/Pair;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "updateRecentTokens", "", "tokens", "assertUpdateIsIncremental", "writeExternal", "out", "Ljava/io/ObjectOutput;", "readExternal", "ins", "Ljava/io/ObjectInput;", "Companion", "intellij.platform.ml.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVocabularyWithLimit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VocabularyWithLimit.kt\ncom/intellij/internal/ml/ngram/VocabularyWithLimit\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1611#2,9:220\n1863#2:229\n1864#2:231\n1620#2:232\n1557#2:233\n1628#2,3:234\n1#3:230\n*S KotlinDebug\n*F\n+ 1 VocabularyWithLimit.kt\ncom/intellij/internal/ml/ngram/VocabularyWithLimit\n*L\n36#1:220,9\n36#1:229\n36#1:231\n36#1:232\n49#1:233\n49#1:234,3\n36#1:230\n*E\n"})
public final class VocabularyWithLimit
extends Vocabulary
implements Externalizable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int maxVocabularySize;
    @NotNull
    private final AtomicInteger counter;
    @NotNull
    private final NGramRecentTokens recent;
    @NotNull
    private final NGramRecentTokensSequence recentSequence;
    @NotNull
    private static final Logger LOG;
    private static final int SEQUENCE_INITIAL_SIZE = 100;

    public VocabularyWithLimit(int maxVocabularySize, int nGramOrder, int maxSequenceSize, int sequenceInitialSize) {
        this.maxVocabularySize = maxVocabularySize;
        this.counter = new AtomicInteger(1);
        this.recent = new NGramRecentTokens(maxSequenceSize);
        this.recentSequence = new NGramRecentTokensSequence(maxSequenceSize, nGramOrder, sequenceInitialSize);
    }

    public /* synthetic */ VocabularyWithLimit(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n4 = 100;
        }
        this(n, n2, n3, n4);
    }

    public final int getMaxVocabularySize() {
        return this.maxVocabularySize;
    }

    public final void setMaxVocabularySize(int n) {
        this.maxVocabularySize = n;
    }

    @NotNull
    public final NGramRecentTokens getRecent() {
        return this.recent;
    }

    @NotNull
    public final NGramRecentTokensSequence getRecentSequence() {
        return this.recentSequence;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> toExistingIndices(@NotNull List<String> token) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(token, (String)"token");
        Iterable $this$mapNotNull$iv = token;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.toExistingIndex(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Integer toExistingIndex(String token) {
        Integer n = (Integer)this.getWordIndices().get(token);
        if (n == null) {
            n = (Integer)this.getWordIndices().get("<unknownCharacter>");
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> toIndicesWithLimit(@NotNull List<String> token, @NotNull NGramModel model) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Iterable $this$map$iv = token;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toIndexWithLimit((String)it, model));
        }
        List indices = (List)destination$iv$iv;
        this.recentSequence.addWithLimit$intellij_platform_ml_impl(model, ((Number)CollectionsKt.last((List)indices)).intValue());
        this.updateRecentTokens(token);
        return indices;
    }

    private final int toIndexWithLimit(String token, NGramModel model) {
        Integer index = (Integer)this.getWordIndices().get(token);
        if (index == null) {
            index = this.counter.getAndIncrement();
            this.getWordIndices().put(token, index);
            if (this.recent.size() >= this.maxVocabularySize) {
                Pair<ArrayList<String>, Integer> pair = this.trimRecentTokensSize();
                ArrayList toRemove = (ArrayList)pair.component1();
                int latestAppearance = ((Number)pair.component2()).intValue();
                this.recentSequence.forgetUntil$intellij_platform_ml_impl(model, this.recent.size() > 0 ? this.recent.lastIndex() - latestAppearance : 0);
                Iterator iterator = toRemove.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    String tokenToRemove = (String)iterator2.next();
                    this.getWordIndices().remove(tokenToRemove);
                }
            }
        }
        return index;
    }

    private final Pair<ArrayList<String>, Integer> trimRecentTokensSize() {
        ArrayList<String> toRemove = new ArrayList<String>();
        int latestAppearance = 0;
        while (this.recent.size() >= this.maxVocabularySize) {
            Pair<String, Integer> pair = this.recent.removeEldest();
            String token = (String)pair.component1();
            int idx = ((Number)pair.component2()).intValue();
            latestAppearance = Math.max(latestAppearance, idx);
            toRemove.add(token);
        }
        return TuplesKt.to(toRemove, (Object)latestAppearance);
    }

    private final void updateRecentTokens(List<String> tokens) {
        if (LOG.isDebugEnabled()) {
            this.assertUpdateIsIncremental(tokens);
        }
        if (!((Collection)tokens).isEmpty()) {
            this.recent.update((String)CollectionsKt.last(tokens));
        }
    }

    private final void assertUpdateIsIncremental(List<String> tokens) {
        int i = 0;
        int n = tokens.size() - 2;
        if (i <= n) {
            while (true) {
                boolean bl = this.recent.contains(tokens.get(i));
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string = "Cannot find previous token in recent: " + tokens.get(i) + " in " + tokens;
                    throw new AssertionError((Object)string);
                }
                if (i == n) break;
                ++i;
            }
        }
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInt(this.maxVocabularySize);
        out.writeInt(this.counter.get());
        this.recent.writeExternal(out);
        this.recentSequence.writeExternal(out);
        out.writeInt(this.getWordIndices().size());
        for (Map.Entry entry : this.getWordIndices().entrySet()) {
            String token = (String)entry.getKey();
            int code = ((Number)entry.getValue()).intValue();
            out.writeObject(token);
            out.writeInt(code);
        }
    }

    @Override
    public void readExternal(@NotNull ObjectInput ins) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ins, (String)"ins");
        this.maxVocabularySize = ins.readInt();
        this.counter.set(ins.readInt());
        this.recent.readExternal(ins);
        this.recentSequence.readExternal(ins);
        int wordsSize = ins.readInt();
        for (int i = 0; i < wordsSize; ++i) {
            Object object = ins.readObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String token = (String)object;
            int code = ins.readInt();
            Integer n = code;
            this.getWordIndices().put(token, n);
        }
    }

    static {
        Logger logger = Logger.getInstance(VocabularyWithLimit.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/internal/ml/ngram/VocabularyWithLimit$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_platform_ml_impl", "()Lcom/intellij/openapi/diagnostic/Logger;", "SEQUENCE_INITIAL_SIZE", "", "intellij.platform.ml.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$intellij_platform_ml_impl() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

