/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.CustomInspectionActions;
import com.intellij.profile.codeInspection.ui.InspectionMetaDataDialog;
import com.intellij.profile.codeInspection.ui.InspectionProfileActionProvider;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.inspection.SSBasedInspection;
import com.intellij.structuralsearch.inspection.StructuralSearchInspectionToolWrapper;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchProfileActionProvider
extends InspectionProfileActionProvider {
    private static void enableSSIfDisabled(@NotNull InspectionProfileModifiableModel profile, @NotNull Project project2) {
        if (profile == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(1);
        }
        if (profile.getToolsOrNull("SSBasedInspection", null) != null && !profile.isToolEnabled(HighlightDisplayKey.find((String)"SSBasedInspection"))) {
            profile.setToolEnabled("SSBasedInspection", true, project2, false);
            for (ScopeToolState tool : profile.getAllTools()) {
                InspectionToolWrapper wrapper = tool.getTool();
                if (!(wrapper instanceof StructuralSearchInspectionToolWrapper)) continue;
                tool.setEnabled(false);
            }
        }
    }

    @Nullable
    public ActionGroup getAddActions(@NotNull SingleInspectionProfilePanel panel) {
        if (panel == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(2);
        }
        StructuralSearchProfileActionProvider.enableSSIfDisabled(panel.getProfile(), panel.getProject());
        return StructuralSearchProfileActionProvider.getActionGroup(panel);
    }

    public List<InspectionProfileActionProvider.ProfilePanelAction> getProfilePanelActions(SingleInspectionProfilePanel panel) {
        return List.of(new InspectionProfileActionProvider.ProfilePanelAction((AnAction)StructuralSearchProfileActionProvider.getActionGroup(panel), "ssr.profile.action.provider.add.group"));
    }

    @NotNull
    private static DefaultActionGroup getActionGroup(@NotNull SingleInspectionProfilePanel panel) {
        if (panel == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(3);
        }
        return new DefaultActionGroup(new AnAction[]{new AddInspectionAction(panel, SSRBundle.message("SSRInspection.add.search.template.button", new Object[0]), false), new AddInspectionAction(panel, SSRBundle.message("SSRInspection.add.replace.template.button", new Object[0]), true)});
    }

    public boolean canDeleteInspection(InspectionProfileEntry entry) {
        return entry instanceof SSBasedInspection;
    }

    public void deleteInspection(InspectionProfileEntry entry, String shortName) {
        if (entry instanceof SSBasedInspection) {
            SSBasedInspection ssBasedInspection = (SSBasedInspection)entry;
            ssBasedInspection.removeConfigurationsWithUuid(shortName);
        }
    }

    public static void createNewInspection(@NotNull Configuration configuration, @NotNull Project project2) {
        if (configuration == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(5);
        }
        StructuralSearchProfileActionProvider.createNewInspection(configuration, project2, InspectionProfileManager.getInstance((Project)project2).getCurrentProfile());
    }

    public static boolean createNewInspection(@NotNull Configuration configuration, @NotNull Project project2, @NotNull InspectionProfileImpl profile) {
        if (configuration == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(7);
        }
        if (profile == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(8);
        }
        SSBasedInspection inspection = SSBasedInspection.getStructuralSearchInspection((InspectionProfile)profile);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            InspectionMetaDataDialog dialog = inspection.createMetaDataDialog(project2, profile.getDisplayName(), null);
            if (configuration instanceof ReplaceConfiguration) {
                dialog.showCleanupOption(false);
            }
            if (!dialog.showAndGet()) {
                return false;
            }
            configuration.setOrder(0);
            configuration.setName(dialog.getName());
            configuration.setDescription(dialog.getDescription());
            configuration.setProblemDescriptor(dialog.getProblemDescriptor());
            configuration.setSuppressId(dialog.getSuppressId());
        }
        configuration.setUuid(null);
        inspection.addConfiguration(configuration);
        StructuralSearchProfileActionProvider.addInspectionToProfile(project2, profile, configuration);
        if (profile instanceof InspectionProfileModifiableModel) {
            ((InspectionProfileModifiableModel)profile).setModified(true);
        }
        CustomInspectionActions.fireProfileChanged((InspectionProfileImpl)profile);
        return true;
    }

    private static void addInspectionToProfile(@NotNull Project project2, @NotNull InspectionProfileImpl profile, @NotNull Configuration configuration) {
        String shortName;
        InspectionToolWrapper toolWrapper;
        if (project2 == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(9);
        }
        if (profile == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(10);
        }
        if (configuration == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(11);
        }
        if ((toolWrapper = profile.getInspectionTool(shortName = configuration.getUuid(), project2)) != null) {
            return;
        }
        StructuralSearchInspectionToolWrapper wrapped = new StructuralSearchInspectionToolWrapper(Collections.singletonList(configuration));
        profile.addTool(project2, (InspectionToolWrapper)wrapped, null);
        profile.setToolEnabled(shortName, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "enableSSIfDisabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAddActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionGroup";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewInspection";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addInspectionToProfile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class AddInspectionAction
    extends DumbAwareAction {
        private final SingleInspectionProfilePanel myPanel;
        private final boolean myReplace;

        AddInspectionAction(@NotNull SingleInspectionProfilePanel panel, @NlsActions.ActionText String text, boolean replace) {
            if (panel == null) {
                AddInspectionAction.$$$reportNull$$$0(0);
            }
            super(text);
            this.myPanel = panel;
            this.myReplace = replace;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            SearchContext context;
            StructuralSearchDialog dialog;
            if (e == null) {
                AddInspectionAction.$$$reportNull$$$0(1);
            }
            if (!(dialog = new StructuralSearchDialog(context = new SearchContext(e.getDataContext()), this.myReplace, true)).showAndGet()) {
                return;
            }
            InspectionProfileModifiableModel profile = this.myPanel.getProfile();
            Configuration configuration = dialog.getConfiguration();
            if (!StructuralSearchProfileActionProvider.createNewInspection(configuration, context.getProject(), (InspectionProfileImpl)profile)) {
                return;
            }
            this.myPanel.selectInspectionTool(configuration.getUuid());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider$AddInspectionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

