/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.inspections.quickfix.PyInstallRequirementsFix;
import com.jetbrains.python.packaging.PyPackageInstallUtilsKt;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.statistics.PyPackagesUsageCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\r\u0010\r\u001a\u00070\u0004\u00a2\u0006\u0002\b\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/inspections/quickfix/InstallAllPackagesQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "packageNames", "", "", "<init>", "(Ljava/util/List;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "Lorg/jetbrains/annotations/Nls;", "startInWriteAction", "", "availableInBatchMode", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nInstallAllPackagesQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallAllPackagesQuickFix.kt\ncom/jetbrains/python/inspections/quickfix/InstallAllPackagesQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1557#2:43\n1628#2,3:44\n1557#2:47\n1628#2,3:48\n*S KotlinDebug\n*F\n+ 1 InstallAllPackagesQuickFix.kt\ncom/jetbrains/python/inspections/quickfix/InstallAllPackagesQuickFix\n*L\n23#1:43\n23#1:44,3\n24#1:47\n24#1:48,3\n*E\n"})
public final class InstallAllPackagesQuickFix
implements LocalQuickFix {
    @NotNull
    private final List<String> packageNames;

    public InstallAllPackagesQuickFix(@NotNull List<String> packageNames) {
        Intrinsics.checkNotNullParameter(packageNames, (String)"packageNames");
        this.packageNames = packageNames;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        Module module2 = module;
        Sdk sdk2 = PythonSdkUtil.findPythonSdk(element);
        if (sdk2 == null) {
            return;
        }
        Sdk sdk3 = sdk2;
        Iterable $this$map$iv = this.packageNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PyPsiPackageUtil.moduleToPackageName$default(PyPsiPackageUtil.INSTANCE, (String)it, null, 2, null));
        }
        List normalizedPackageNames = (List)destination$iv$iv;
        Iterable $this$map$iv2 = normalizedPackageNames;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(PyRequirementsKt.pyRequirement((String)it));
        }
        Set<PyRequirement> confirmedPackages = PyPackageInstallUtilsKt.getConfirmedPackages((List)destination$iv$iv2, project);
        if (confirmedPackages.isEmpty()) {
            return;
        }
        PyInstallRequirementsFix fix = new PyInstallRequirementsFix(this.getFamilyName(), module2, sdk3, CollectionsKt.toList((Iterable)confirmedPackages), CollectionsKt.emptyList(), null, 32, null);
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        fix.applyFix(project2, descriptor2);
        PyPackagesUsageCollector.Companion.getInstallAllEvent().log((Object)confirmedPackages.size());
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("python.unresolved.reference.inspection.install.all", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean availableInBatchMode() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }
}

