/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeVisitor;
import com.jetbrains.python.psi.types.PyTypeVisitorExt;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.PyUnpackedTupleType;
import com.jetbrains.python.psi.types.PyUnpackedTupleTypeImpl;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTupleType
extends PyClassTypeImpl
implements PyCollectionType {
    private final PyUnpackedTupleType myUnpackedTupleType;

    @Nullable
    public static PyTupleType create(@NotNull PsiElement anchor, @NotNull List<? extends PyType> elementTypes) {
        PyClass tuple;
        if (anchor == null) {
            PyTupleType.$$$reportNull$$$0(0);
        }
        if (elementTypes == null) {
            PyTupleType.$$$reportNull$$$0(1);
        }
        if ((tuple = PyBuiltinCache.getInstance(anchor).getClass("tuple")) != null) {
            return new PyTupleType(tuple, elementTypes, false);
        }
        return null;
    }

    @Nullable
    public static PyTupleType createHomogeneous(@NotNull PsiElement anchor, @Nullable PyType elementType) {
        PyClass tuple;
        if (anchor == null) {
            PyTupleType.$$$reportNull$$$0(2);
        }
        if ((tuple = PyBuiltinCache.getInstance(anchor).getClass("tuple")) != null) {
            return new PyTupleType(tuple, Collections.singletonList(elementType), true);
        }
        return null;
    }

    public PyTupleType(@NotNull PyClass tupleClass, @NotNull List<? extends PyType> elementTypes, boolean homogeneous) {
        if (tupleClass == null) {
            PyTupleType.$$$reportNull$$$0(3);
        }
        if (elementTypes == null) {
            PyTupleType.$$$reportNull$$$0(4);
        }
        this(tupleClass, elementTypes, homogeneous, false);
    }

    protected PyTupleType(@NotNull PyClass tupleClass, @NotNull List<? extends PyType> elementTypes, boolean homogeneous, boolean isDefinition) {
        if (tupleClass == null) {
            PyTupleType.$$$reportNull$$$0(5);
        }
        if (elementTypes == null) {
            PyTupleType.$$$reportNull$$$0(6);
        }
        super(tupleClass, isDefinition);
        this.myUnpackedTupleType = new PyUnpackedTupleTypeImpl(elementTypes, homogeneous);
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myUnpackedTupleType.isUnbound()) {
            String string = "(" + PyTupleType.getTypeName(this.getIteratedItemType()) + ", ...)";
            if (string == null) {
                PyTupleType.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = "(" + StringUtil.join(this.myUnpackedTupleType.getElementTypes(), PyTupleType::getTypeName, (String)", ") + ")";
        if (string == null) {
            PyTupleType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    private static String getTypeName(@Nullable PyType type2) {
        return type2 == null ? "Any" : type2.getName();
    }

    @Override
    public boolean isBuiltin() {
        return true;
    }

    @Nullable
    public PyType getElementType(int index) {
        if (this.isHomogeneous()) {
            return this.getIteratedItemType();
        }
        List<PyType> elementTypes = this.myUnpackedTupleType.getElementTypes();
        return index >= 0 && index < elementTypes.size() ? elementTypes.get(index) : null;
    }

    public int getElementCount() {
        return this.isHomogeneous() ? -1 : this.myUnpackedTupleType.getElementTypes().size();
    }

    public boolean isHomogeneous() {
        return this.myUnpackedTupleType.isUnbound();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PyTupleType type2 = (PyTupleType)o;
        return Objects.equals(this.myUnpackedTupleType, type2.myUnpackedTupleType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myUnpackedTupleType);
    }

    @Override
    @NotNull
    public List<PyType> getElementTypes() {
        List<PyType> list = this.myUnpackedTupleType.getElementTypes();
        if (list == null) {
            PyTupleType.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @Nullable
    public PyType getIteratedItemType() {
        return PyUnionType.union(this.myUnpackedTupleType.getElementTypes());
    }

    @NotNull
    public PyUnpackedTupleType asUnpackedTupleType() {
        PyUnpackedTupleType pyUnpackedTupleType = this.myUnpackedTupleType;
        if (pyUnpackedTupleType == null) {
            PyTupleType.$$$reportNull$$$0(10);
        }
        return pyUnpackedTupleType;
    }

    @Override
    public <T> T acceptTypeVisitor(@NotNull PyTypeVisitor<T> visitor2) {
        if (visitor2 == null) {
            PyTupleType.$$$reportNull$$$0(11);
        }
        if (visitor2 instanceof PyTypeVisitorExt) {
            PyTypeVisitorExt visitorExt = (PyTypeVisitorExt)visitor2;
            return visitorExt.visitPyTupleType(this);
        }
        return visitor2.visitPyType(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tupleClass";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyTupleType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyTupleType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "asUnpackedTupleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createHomogeneous";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "acceptTypeVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

