/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.view.DbSchemaNodeReporter;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbSchemaNode<Self extends DbSchemaNode<Self>>
implements DbSchemaNodeReporter<Self> {
    private List<Self> myAllNodes;
    private List<Self> myChildren = null;
    private List<Self> myShadowChildren = null;
    private DbSchemaNodeReporter<Self> myParentOrReporter = null;
    private boolean myChecked;
    private String myName;
    @Nullable
    private final BasicMetaObject<?> myMeta;
    private Object myObject;

    public DbSchemaNode(String name2, @Nullable BasicMetaObject<?> meta, Object object) {
        this.myName = name2;
        this.myMeta = meta;
        this.myObject = object;
    }

    @Nullable
    public BasicMetaObject<?> getMeta() {
        return this.myMeta;
    }

    public void setName(String name2) {
        this.myName = name2;
    }

    @NotNull
    public List<Self> getChildren() {
        List list = (List)ObjectUtils.chooseNotNull(this.myChildren, Collections.emptyList());
        if (list == null) {
            DbSchemaNode.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<Self> getShadowChildren() {
        List list = (List)ObjectUtils.chooseNotNull(this.myShadowChildren, Collections.emptyList());
        if (list == null) {
            DbSchemaNode.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setChildren(@Nullable Collection<Self> children2) {
        DbSchemaNode.reparent(this.myChildren, null);
        this.myChildren = ContainerUtil.isEmpty(children2) ? null : new SmartList(children2);
        this.reparent((Collection<Self>)this.myChildren);
        if (children2 != null && this.myShadowChildren != null) {
            this.myShadowChildren.removeAll(children2);
        }
    }

    public void setShadowChildren(@Nullable Collection<Self> children2) {
        DbSchemaNode.reparent(this.myShadowChildren, null);
        this.myShadowChildren = ContainerUtil.isEmpty(children2) ? null : new SmartList(children2);
        this.reparent((Collection<Self>)this.myShadowChildren);
        if (children2 != null && this.myChildren != null) {
            this.myChildren.removeAll(children2);
        }
    }

    public void setHasAll(boolean has) {
        if (has == (this.myAllNodes != null)) {
            return;
        }
        if (has) {
            List allNodes = this.getWildcardMetas().map(m -> this.createAll((BasicMetaObject<?>)m)).toList();
            this.myAllNodes = allNodes.isEmpty() ? null : allNodes;
            this.reparent(allNodes);
        } else {
            this.myAllNodes = null;
        }
    }

    @Nullable
    public Self getAllNode(@Nullable BasicMetaObject<?> meta) {
        return (Self)(this.myAllNodes == null || meta == null ? null : (DbSchemaNode)ContainerUtil.find(this.myAllNodes, a -> a.getMeta() == meta));
    }

    @Nullable
    public Self getAllNode(@Nullable ObjectKind kind) {
        return (Self)(this.myAllNodes == null || kind == null ? null : (DbSchemaNode)ContainerUtil.find(this.myAllNodes, a -> a.getKind() == kind));
    }

    @Nullable
    public List<Self> getAllNodes() {
        return this.myAllNodes;
    }

    @NotNull
    public Iterable<Self> iterAllNodes() {
        Iterable iterable = (Iterable)ObjectUtils.notNull(this.getAllNodes(), Collections.emptyList());
        if (iterable == null) {
            DbSchemaNode.$$$reportNull$$$0(2);
        }
        return iterable;
    }

    @NotNull
    public ThreeState getAllNodeState() {
        if (this.myAllNodes == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                DbSchemaNode.$$$reportNull$$$0(3);
            }
            return threeState;
        }
        boolean res2 = ((DbSchemaNode)this.myAllNodes.get(0)).isChecked();
        for (int i2 = 1; i2 < this.myAllNodes.size(); ++i2) {
            if (res2 == ((DbSchemaNode)this.myAllNodes.get(i2)).isChecked()) continue;
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                DbSchemaNode.$$$reportNull$$$0(4);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.fromBoolean((boolean)res2);
        if (threeState == null) {
            DbSchemaNode.$$$reportNull$$$0(5);
        }
        return threeState;
    }

    public void setObject(Object object) {
        this.myObject = object;
    }

    @NlsSafe
    public String getName() {
        return this.myName;
    }

    @Nullable
    public ObjectKind getKind() {
        BasicMetaObject<?> meta = this.getMeta();
        return meta == null ? null : meta.kind;
    }

    @Nls
    @NotNull
    public String getKindName(boolean plural) {
        ObjectKind kind;
        BasicMetaObject<?> meta = this.getMeta();
        ObjectKind objectKind = kind = meta != null ? meta.kind : null;
        if (kind == null) {
            kind = ObjectKind.NONE;
        }
        Dbms dbms = meta != null ? meta.getDbms() : Dbms.UNKNOWN;
        String string = DbPresentationCore.getPresentableName(kind, dbms, plural);
        if (string == null) {
            DbSchemaNode.$$$reportNull$$$0(6);
        }
        return string;
    }

    public Object getObject() {
        return this.myObject;
    }

    public boolean isChecked() {
        return this.myChecked;
    }

    public void setChecked(boolean checked) {
        if (this.myChecked == checked) {
            return;
        }
        this.myChecked = checked;
        this.onNodeChecked(this.self());
    }

    @Override
    public void onNodeChecked(@NotNull Self node) {
        DbSchemaNodeReporter<Self> parent;
        if (node == null) {
            DbSchemaNode.$$$reportNull$$$0(7);
        }
        if ((parent = this.getParentReporter()) != null) {
            parent.onNodeChecked(node);
        }
    }

    public void purgeShadow() {
        this.setShadowChildren(null);
        for (DbSchemaNode node : this.getChildren()) {
            node.purgeShadow();
        }
    }

    public void makeShadow() {
        this.setShadowChildren(this.myShadowChildren == null ? this.myChildren : ContainerUtil.newArrayList(this.getSimpleChildNodes()));
        this.setChildren(null);
        for (DbSchemaNode node : this.getShadowChildren()) {
            node.makeShadow();
        }
    }

    @NotNull
    public JBIterable<BasicMetaObject<?>> getWildcardMetas() {
        BasicMetaObject<?> meta = this.getMeta();
        JBIterable jBIterable = meta == null ? JBIterable.empty() : JBIterable.of((Object[])meta.children).filter(m -> m.kindOf(BasicNamespace.class));
        if (jBIterable == null) {
            DbSchemaNode.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @Nullable
    public BasicMetaObject<?> findChild(@Nullable ObjectKind kind) {
        return kind == null ? null : BasicMetaUtils.findChild(this.getMeta(), kind);
    }

    public BasicMetaObject<?> findChild(@NotNull Predicate<BasicMetaObject<?>> p2) {
        if (p2 == null) {
            DbSchemaNode.$$$reportNull$$$0(9);
        }
        return BasicMetaUtils.findChild(this.getMeta(), p2);
    }

    public void setRootReporter(@NotNull DbSchemaNodeReporter<Self> reporter) {
        if (reporter == null) {
            DbSchemaNode.$$$reportNull$$$0(10);
        }
        if (this.myParentOrReporter != null) {
            throw new AssertionError((Object)"Already have a reporter");
        }
        this.myParentOrReporter = reporter;
    }

    protected void reparent(@Nullable Collection<Self> children2) {
        DbSchemaNode.reparent(children2, this.self());
    }

    protected static <Self extends DbSchemaNode<Self>> void reparent(@Nullable Collection<Self> children2, @Nullable Self parent) {
        if (children2 == null) {
            return;
        }
        for (DbSchemaNode child : children2) {
            if (child.myParentOrReporter != null && child.myParentOrReporter != parent && parent != null) {
                throw new AssertionError((Object)"Already has parent");
            }
            child.myParentOrReporter = parent;
        }
    }

    protected Self self() {
        return (Self)this;
    }

    @NotNull
    public JBIterable<Self> getChildNodes() {
        JBIterable jBIterable = this.myAllNodes == null ? JBIterable.from(this.getSimpleChildNodes()) : JBIterable.from(this.myAllNodes).append(this.getSimpleChildNodes());
        if (jBIterable == null) {
            DbSchemaNode.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<Self> getSimpleChildNodes() {
        if (this.myChildren == null) {
            List<Self> list = this.getShadowChildren();
            if (list == null) {
                DbSchemaNode.$$$reportNull$$$0(12);
            }
            return list;
        }
        if (this.myShadowChildren == null) {
            List<Self> list = this.getChildren();
            if (list == null) {
                DbSchemaNode.$$$reportNull$$$0(13);
            }
            return list;
        }
        JBIterable jBIterable = JBIterable.from(this.myChildren).append(this.myShadowChildren);
        if (jBIterable == null) {
            DbSchemaNode.$$$reportNull$$$0(14);
        }
        return jBIterable;
    }

    @Nullable
    public Self getParent() {
        return (Self)(this.myParentOrReporter instanceof DbSchemaNode ? (DbSchemaNode)this.myParentOrReporter : null);
    }

    @Nullable
    protected DbSchemaNodeReporter<Self> getParentReporter() {
        return this.myParentOrReporter;
    }

    @NotNull
    protected abstract Self createAll(@NotNull BasicMetaObject<?> var1);

    public boolean isShadow() {
        Self parent = this.getParent();
        return parent != null && ((DbSchemaNode)parent).getShadowChildren().contains(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 7, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DbSchemaNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShadowChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "iterAllNodes";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNodeState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindName";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DbSchemaNode";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWildcardMetas";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildNodes";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleChildNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onNodeChecked";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setRootReporter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 7, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

