/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.view.DbSchemaNode;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import icons.DatabaseIcons;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class DbSchemasTree
extends DbCheckBoxTree<MyNode> {
    public DbSchemasTree(@NotNull CheckedTreeNode root) {
        if (root == null) {
            DbSchemasTree.$$$reportNull$$$0(0);
        }
        super(root, new MyTreeCellRenderer());
    }

    @Override
    protected boolean unblockByAll() {
        return false;
    }

    public static CheckedTreeNode createNode(MyNode node) {
        CheckedTreeNode res2 = new CheckedTreeNode(node){

            public void setChecked(boolean checked) {
                super.setChecked(checked);
                ((MyNode)this.getUserObject()).setChecked(checked);
            }
        };
        res2.setChecked(node.isChecked());
        return res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/view/ui/DbSchemasTree", "<init>"));
    }

    private static class MyTreeCellRenderer
    extends DbCheckBoxTree.CellWithUnderlinedAllRenderer<MyNode> {
        private MyTreeCellRenderer() {
        }

        @Override
        protected void customizeCheckboxRenderer(DbCheckBoxTree<MyNode> tree2, MyNode node) {
            if (node.getParent() == null) {
                return;
            }
            ColoredTreeCellRenderer renderer2 = this.getTextRenderer();
            if (node.getObject() instanceof LocalDataSource) {
                renderer2.setIcon(((LocalDataSource)node.getObject()).getBaseIcon());
            } else if (node.getObject() instanceof SqlDataSource) {
                renderer2.setIcon(DatabaseIcons.DdlDbms);
            }
            this.renderText((JTree)((Object)tree2), node, (ColoredTextContainer)renderer2);
        }

        @Override
        protected void renderText(JTree baseTree, MyNode node, ColoredTextContainer renderer2) {
            String name2 = node.getName();
            if (node.getObject() instanceof DasObject || node.getObject() instanceof DasDataSource) {
                if (StringUtil.isEmpty((String)name2)) {
                    renderer2.append(DatabaseBundle.message("data.source.scope.editor.tree.unnamed.node.name", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else {
                    renderer2.append(name2, node.isShadow() ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            } else if (node.getObject() == "*") {
                String pluralized = node.getKindName(true);
                renderer2.append(DatabaseBundle.message("label.all.node", StringUtil.capitalizeWords((String)pluralized, (boolean)true)), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                renderer2.append(StringUtil.isEmpty((String)name2) ? DatabaseBundle.message("data.source.scope.editor.tree.unnamed.node.name", new Object[0]) : name2, SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
            }
        }
    }

    public static class MyNode
    extends DbSchemaNode<MyNode> {
        public MyNode(String name2, BasicMetaObject<?> meta, Object object) {
            super(name2, meta, object);
        }

        @Override
        @NotNull
        protected MyNode createAll(@NotNull BasicMetaObject<?> meta) {
            if (meta == null) {
                MyNode.$$$reportNull$$$0(0);
            }
            return new MyNode("All", meta, "*");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/view/ui/DbSchemasTree$MyNode", "createAll"));
        }
    }
}

