/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.derby;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlBaseValidationDelegate;
import com.intellij.sql.editor.SqlValidatingHighlightVisitor;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlNameElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/sql/dialects/derby/DerbyValidationDelegate;", "Lcom/intellij/sql/editor/SqlBaseValidationDelegate;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "<init>", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;)V", "visitSqlCreateTableStatement", "", "o", "Lcom/intellij/sql/psi/SqlCreateTableStatement;", "intellij.database.dialects.derby"})
public final class DerbyValidationDelegate
extends SqlBaseValidationDelegate {
    public DerbyValidationDelegate(@NotNull SqlLanguageDialectEx dialect, @NotNull HighlightInfoHolder holder) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(dialect, holder);
    }

    @Override
    public void visitSqlCreateTableStatement(@NotNull SqlCreateTableStatement o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        super.visitSqlCreateTableStatement(o);
        if (o.getQueryExpression() != null) {
            return;
        }
        for (SqlColumnDefinition column2 : o.getDeclaredColumns()) {
            if (column2.getTypeElement() != null || column2.getGeneratedClause() != null) continue;
            SqlValidatingHighlightVisitor.Delegate delegate = this;
            SqlNameElement sqlNameElement = column2.getNameElement();
            SqlElement sqlElement = sqlNameElement != null ? (SqlElement)sqlNameElement : (SqlElement)column2;
            Intrinsics.checkNotNull((Object)sqlElement);
            PsiElement psiElement = (PsiElement)sqlElement;
            String string = SqlBundle.message((String)"inspection.message.required.type.for.non.generated.column", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SqlValidatingHighlightVisitor.Delegate.reportError$default(delegate, psiElement, string, null, 4, null);
        }
    }
}

