/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.Projection;

public class KrovakProjection
extends Projection {
    boolean czech = false;
    private double s45;
    private double alfa;
    private double k;
    private double ro0;
    private double ad;
    private double s0;
    private double n;

    public KrovakProjection() {
        this.minLatitude = Math.toRadians(-60.0);
        this.maxLatitude = Math.toRadians(60.0);
        this.minLongitude = Math.toRadians(-90.0);
        this.maxLongitude = Math.toRadians(90.0);
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.s45 = 0.785398163397448;
        double s90 = 2.0 * this.s45;
        double fi0 = this.projectionLatitude;
        this.a = 1.0;
        double e2 = 0.006674372230614;
        this.e = Math.sqrt(e2);
        this.alfa = Math.sqrt(1.0 + e2 * Math.pow(Math.cos(fi0), 4.0) / (1.0 - e2));
        double uq = 1.04216856380474;
        double u0 = Math.asin(Math.sin(fi0) / this.alfa);
        double g = Math.pow((1.0 + this.e * Math.sin(fi0)) / (1.0 - this.e * Math.sin(fi0)), this.alfa * this.e / 2.0);
        this.k = Math.tan(u0 / 2.0 + this.s45) / Math.pow(Math.tan(fi0 / 2.0 + this.s45), this.alfa) * g;
        double k1 = this.scaleFactor;
        double n0 = this.a * Math.sqrt(1.0 - e2) / (1.0 - e2 * Math.pow(Math.sin(fi0), 2.0));
        this.s0 = 1.37008346281555;
        this.n = Math.sin(this.s0);
        this.ro0 = k1 * n0 / Math.tan(this.s0);
        this.ad = s90 - uq;
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        double gfi = Math.pow((1.0 + this.e * Math.sin(lpphi)) / (1.0 - this.e * Math.sin(lpphi)), this.alfa * this.e / 2.0);
        double u = 2.0 * (Math.atan(this.k * Math.pow(Math.tan(lpphi / 2.0 + this.s45), this.alfa) / gfi) - this.s45);
        double deltav = -lplam * this.alfa;
        double s = Math.asin(Math.cos(this.ad) * Math.sin(u) + Math.sin(this.ad) * Math.cos(u) * Math.cos(deltav));
        double d = Math.asin(Math.cos(u) * Math.sin(deltav) / Math.cos(s));
        double eps = this.n * d;
        double ro = this.ro0 * Math.pow(Math.tan(this.s0 / 2.0 + this.s45), this.n) / Math.pow(Math.tan(s / 2.0 + this.s45), this.n);
        out.y = ro * Math.cos(eps) / this.a;
        out.x = ro * Math.sin(eps) / this.a;
        if (!this.czech) {
            out.y *= -1.0;
            out.x *= -1.0;
        }
        return out;
    }

    @Override
    protected ProjCoordinate projectInverse(double x, double y, ProjCoordinate dst) {
        dst.x = y;
        dst.y = x;
        if (!this.czech) {
            dst.x *= -1.0;
            dst.y *= -1.0;
        }
        double ro = Math.sqrt(dst.x * dst.x + dst.y * dst.y);
        double eps = Math.atan2(dst.y, dst.x);
        double d = eps / Math.sin(this.s0);
        double s = 2.0 * (Math.atan(Math.pow(this.ro0 / ro, 1.0 / this.n) * Math.tan(this.s0 / 2.0 + this.s45)) - this.s45);
        double u = Math.asin(Math.cos(this.ad) * Math.sin(s) - Math.sin(this.ad) * Math.cos(s) * Math.cos(d));
        double deltav = Math.asin(Math.cos(s) * Math.sin(d) / Math.cos(u));
        dst.x = this.projectionLongitude - deltav / this.alfa;
        double fi1 = u;
        boolean ok2 = false;
        do {
            dst.y = 2.0 * (Math.atan(Math.pow(this.k, -1.0 / this.alfa) * Math.pow(Math.tan(u / 2.0 + this.s45), 1.0 / this.alfa) * Math.pow((1.0 + this.e * Math.sin(fi1)) / (1.0 - this.e * Math.sin(fi1)), this.e / 2.0)) - this.s45);
            if (Math.abs(fi1 - dst.y) < 1.0E-15) {
                ok2 = true;
            }
            fi1 = dst.y;
        } while (!ok2);
        dst.x -= this.projectionLongitude;
        return dst;
    }

    @Override
    public String toString() {
        return "Krovak";
    }
}

