/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdResetDocumentChange;
import com.jetbrains.rd.ide.model.RdTextModificationKind;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0005\u001a&\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a6\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007\u00a8\u0006\u000f"}, d2={"shiftOnePoint", "", "changes", "", "Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;", "offset", "isStickingToRight", "", "shiftRange", "Lcom/intellij/openapi/util/TextRange;", "", "range", "isVerifiable", "isGreedyToLeft", "isGreedyToRight", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nDocumentLogRangeShifter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentLogRangeShifter.kt\ncom/jetbrains/rd/ide/document/DocumentLogRangeShifterKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public final class DocumentLogRangeShifterKt {
    public static final int shiftOnePoint(@NotNull List<? extends RdDocumentChangeBase> changes, int offset, boolean isStickingToRight) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        int resultOffset = offset;
        int balanceCounter = 0;
        for (RdDocumentChangeBase rdDocumentChangeBase : changes) {
            if (rdDocumentChangeBase instanceof RdResetDocumentChange) {
                return -1;
            }
            if (!(rdDocumentChangeBase instanceof RdDocumentChange)) {
                boolean $i$a$-check-DocumentLogRangeShifterKt$shiftOnePoint$232 = false;
                String $i$a$-check-DocumentLogRangeShifterKt$shiftOnePoint$232 = "Unknown document change type: " + rdDocumentChangeBase;
                throw new IllegalStateException($i$a$-check-DocumentLogRangeShifterKt$shiftOnePoint$232.toString());
            }
            int oldLength = ((RdDocumentChange)rdDocumentChangeBase).getOldText().length();
            int start = ((RdDocumentChange)rdDocumentChangeBase).getOffset();
            int end = start + oldLength;
            int delta = ((RdDocumentChange)rdDocumentChangeBase).getNewText().length() - ((RdDocumentChange)rdDocumentChangeBase).getOldText().length();
            if (resultOffset < start) continue;
            if (resultOffset == end) {
                if (delta > 0 && ((RdDocumentChange)rdDocumentChangeBase).getModificationKind() == RdTextModificationKind.RightSide) continue;
                if (isStickingToRight) {
                    resultOffset += delta;
                    continue;
                }
                if (delta > 0 && balanceCounter == 0) continue;
                resultOffset += delta;
                if (delta < 0) {
                    ++balanceCounter;
                }
                if (delta <= 0) continue;
                --balanceCounter;
                continue;
            }
            if (resultOffset > end || isStickingToRight && oldLength == 0) {
                resultOffset += delta;
                continue;
            }
            if (resultOffset == start) continue;
            return -1;
        }
        return resultOffset;
    }

    public static /* synthetic */ int shiftOnePoint$default(List list, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return DocumentLogRangeShifterKt.shiftOnePoint(list, n, bl);
    }

    @Nullable
    public static final TextRange shiftRange(@NotNull Iterable<? extends RdDocumentChangeBase> changes, @NotNull TextRange range, boolean isVerifiable, boolean isGreedyToLeft, boolean isGreedyToRight) {
        boolean bl;
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        boolean bl2 = bl = range.getStartOffset() <= range.getEndOffset();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-DocumentLogRangeShifterKt$shiftRange$232 = false;
            String $i$a$-assert-DocumentLogRangeShifterKt$shiftRange$232 = "Range: " + range + " is not normalized";
            throw new AssertionError((Object)$i$a$-assert-DocumentLogRangeShifterKt$shiftRange$232);
        }
        int resultStart = range.getStartOffset();
        int resultEnd = range.getEndOffset();
        for (RdDocumentChangeBase rdDocumentChangeBase : changes) {
            if (rdDocumentChangeBase instanceof RdResetDocumentChange) {
                return null;
            }
            if (!(rdDocumentChangeBase instanceof RdDocumentChange)) {
                boolean $i$a$-check-DocumentLogRangeShifterKt$shiftRange$332 = false;
                String $i$a$-check-DocumentLogRangeShifterKt$shiftRange$332 = "Unknown document change type: " + rdDocumentChangeBase;
                throw new IllegalStateException($i$a$-check-DocumentLogRangeShifterKt$shiftRange$332.toString());
            }
            int oldLength = ((RdDocumentChange)rdDocumentChangeBase).getOldText().length();
            int newLength = ((RdDocumentChange)rdDocumentChangeBase).getNewText().length();
            int start = ((RdDocumentChange)rdDocumentChangeBase).getOffset();
            int end = start + oldLength;
            int delta = newLength - oldLength;
            if (oldLength == 0 && ((RdDocumentChange)rdDocumentChangeBase).getMoveOffset() != start) {
                int it = ((RdDocumentChange)rdDocumentChangeBase).getMoveOffset();
                boolean bl3 = false;
                int moveOffset = it > start ? it - newLength : it;
                if (moveOffset <= resultStart && resultEnd <= moveOffset + newLength) {
                    int moveDelta = start - moveOffset;
                    resultStart += moveDelta;
                    resultEnd += moveDelta;
                    continue;
                }
            }
            if (!isVerifiable && resultEnd == start && (((RdDocumentChange)rdDocumentChangeBase).getModificationKind() == RdTextModificationKind.RightSide || isGreedyToRight)) {
                resultEnd += delta;
                continue;
            }
            if (resultEnd <= start) continue;
            if (!isVerifiable && resultStart == end && (((RdDocumentChange)rdDocumentChangeBase).getModificationKind() == RdTextModificationKind.LeftSide || isGreedyToLeft)) {
                resultEnd += delta;
                if (delta >= 0) continue;
                resultStart += delta;
                continue;
            }
            if (resultStart >= end) {
                resultStart += delta;
                resultEnd += delta;
                continue;
            }
            if (resultStart <= start && end <= resultEnd && !isVerifiable) {
                resultEnd += delta;
                continue;
            }
            return null;
        }
        return new TextRange(resultStart, resultEnd);
    }
}

