/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n25#3:393\n25#3:394\n25#3:395\n25#3:396\n25#3:397\n25#3:398\n25#3:399\n25#3:400\n25#3:401\n25#3:402\n25#3:403\n25#3:404\n25#3:405\n25#3:406\n25#3:407\n25#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 116580940977137L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1651350930 - -((char)-23066), 1651350930 - (char)-7039, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1651350930 - -((char)-23065), -1651350930 - -((char)-21440), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 134225526638172L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.V();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 == 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-791269590 + -20783, -791269590 + -13288, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-791269590 + -20784, -791269590 + -18076, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-791269590 + -20781, 791269590 + 31149, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 137353550834036L;
                Object object = this.lock;
                n2 = SshAgentIpcService.F();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(496755300 - (char)-20592, 496755300 - (char)-8422, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(496755300 - (char)-20595, -496755300 - -32050, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (n2 != 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(496755300 - (char)-20594, -496755300 - -((char)-21700), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(496755300 - (char)-20597, 496755300 - (char)-11948, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(496755300 - (char)-20596, 496755300 - 25994, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(496755300 - (char)-20594, -496755300 - -((char)-21700), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(496755300 - (char)-20599, 496755300 - (char)-23578, (int)l2));
            if (ActionTimestamp.F() == null) {
                SshAgentIpcService.F(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 101707576122816L;
                    n3 = SshAgentIpcService.V();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 == 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 == 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int n2;
        long l2;
        block27: {
            block28: {
                l2 = 16980626166384L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            n2 = SshAgentIpcService.V();
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 == 0) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1674550320 - -26126, -1674550320 - -28835, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1674550320 - -26114, 1674550320 - 26708, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1674550320 - -26121, -1674550320 - -30998, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1674550320 - -26114, 1674550320 - 26708, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1674550320 - -26120, -1674550320 - -23247, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1674550320 - -26126, -1674550320 - -28835, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1674550320 - -26114, 1674550320 - 26708, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1674550320 - -26123, 1674550320 - 17206, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (n2 == 0) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n3 = Kernel32.INSTANCE.GetLastError();
                if (n3 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1674550320 - -26126, -1674550320 - -28835, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1674550320 - -26114, 1674550320 - 26708, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1674550320 - -26122, 1674550320 - (char)-32248, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1674550320 - -26114, 1674550320 - 26708, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1674550320 - -26101, -1674550320 - -30857, (int)l2) + ErrorToolsKt.prettyHRESULT(n3)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 == 0) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1674550320 - -26114, 1674550320 - 26708, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1674550320 - -26120, -1674550320 - -23247, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1674550320 - -26126, -1674550320 - -28835, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1674550320 - -26114, 1674550320 - 26708, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1674550320 - -26100, -1674550320 - -25130, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 103602303575816L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-897567360 - -((char)-32251), -897567360 - -20565, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 75909929253307L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(677238690 + 20885, -677238690 + -((char)-24671), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u0099l\u00bePwu{;\u00f7\u00b0\u00e8\u00de/<\u001fy\u00b9\u00b7\u00a2\u0014\u00ef\u0018p\u00d8\u00b5\u00a6^\u00c4\u00d1I\u00e95\u00cd\u00b8\u0082b\u00e7\u0012n\u00ef";
                        var4_3 = "\u0099l\u00bePwu{;\u00f7\u00b0\u00e8\u00de/<\u001fy\u00b9\u00b7\u00a2\u0014\u00ef\u0018p\u00d8\u00b5\u00a6^\u00c4\u00d1I\u00e95\u00cd\u00b8\u0082b\u00e7\u0012n\u00ef".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 35;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 56;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 27;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 25;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 121;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 51;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 7;
                                        break;
                                    }
                                    default: {
                                        v11 = 98;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x108D) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 44;
                            case 1 -> 182;
                            case 2 -> 88;
                            case 3 -> 62;
                            case 4 -> 39;
                            case 5 -> 25;
                            case 6 -> 28;
                            case 7 -> 151;
                            case 8 -> 149;
                            case 9 -> 15;
                            case 10 -> 92;
                            case 11 -> 150;
                            case 12 -> 77;
                            case 13 -> 106;
                            case 14 -> 190;
                            case 15 -> 41;
                            case 16 -> 206;
                            case 17 -> 212;
                            case 18 -> 51;
                            case 19 -> 187;
                            case 20 -> 116;
                            case 21 -> 55;
                            case 22 -> 73;
                            case 23 -> 99;
                            case 24 -> 140;
                            case 25 -> 213;
                            case 26 -> 114;
                            case 27 -> 18;
                            case 28 -> 227;
                            case 29 -> 219;
                            case 30 -> 217;
                            case 31 -> 61;
                            case 32 -> 5;
                            case 33 -> 22;
                            case 34 -> 8;
                            case 35 -> 211;
                            case 36 -> 123;
                            case 37 -> 95;
                            case 38 -> 237;
                            case 39 -> 49;
                            case 40 -> 196;
                            case 41 -> 109;
                            case 42 -> 226;
                            case 43 -> 245;
                            case 44 -> 52;
                            case 45 -> 207;
                            case 46 -> 9;
                            case 47 -> 4;
                            case 48 -> 102;
                            case 49 -> 124;
                            case 50 -> 10;
                            case 51 -> 54;
                            case 52 -> 220;
                            case 53 -> 50;
                            case 54 -> 209;
                            case 55 -> 126;
                            case 56 -> 78;
                            case 57 -> 199;
                            case 58 -> 250;
                            case 59 -> 223;
                            case 60 -> 81;
                            case 61 -> 230;
                            case 62 -> 178;
                            case 63 -> 36;
                            case 64 -> 221;
                            case 65 -> 82;
                            case 66 -> 154;
                            case 67 -> 84;
                            case 68 -> 20;
                            case 69 -> 35;
                            case 70 -> 133;
                            case 71 -> 251;
                            case 72 -> 89;
                            case 73 -> 23;
                            case 74 -> 53;
                            case 75 -> 255;
                            case 76 -> 243;
                            case 77 -> 27;
                            case 78 -> 103;
                            case 79 -> 200;
                            case 80 -> 100;
                            case 81 -> 186;
                            case 82 -> 104;
                            case 83 -> 26;
                            case 84 -> 17;
                            case 85 -> 162;
                            case 86 -> 43;
                            case 87 -> 79;
                            case 88 -> 156;
                            case 89 -> 67;
                            case 90 -> 172;
                            case 91 -> 129;
                            case 92 -> 165;
                            case 93 -> 87;
                            case 94 -> 177;
                            case 95 -> 98;
                            case 96 -> 121;
                            case 97 -> 75;
                            case 98 -> 224;
                            case 99 -> 228;
                            case 100 -> 189;
                            case 101 -> 254;
                            case 102 -> 155;
                            case 103 -> 1;
                            case 104 -> 101;
                            case 105 -> 96;
                            case 106 -> 225;
                            case 107 -> 247;
                            case 108 -> 242;
                            case 109 -> 158;
                            case 110 -> 65;
                            case 111 -> 147;
                            case 112 -> 37;
                            case 113 -> 146;
                            case 114 -> 192;
                            case 115 -> 70;
                            case 116 -> 46;
                            case 117 -> 134;
                            case 118 -> 184;
                            case 119 -> 153;
                            case 120 -> 238;
                            case 121 -> 66;
                            case 122 -> 56;
                            case 123 -> 160;
                            case 124 -> 159;
                            case 125 -> 127;
                            case 126 -> 111;
                            case 127 -> 69;
                            case 128 -> 193;
                            case 129 -> 32;
                            case 130 -> 241;
                            case 131 -> 195;
                            case 132 -> 86;
                            case 133 -> 94;
                            case 134 -> 19;
                            case 135 -> 232;
                            case 136 -> 117;
                            case 137 -> 59;
                            case 138 -> 188;
                            case 139 -> 210;
                            case 140 -> 235;
                            case 141 -> 198;
                            case 142 -> 74;
                            case 143 -> 34;
                            case 144 -> 141;
                            case 145 -> 6;
                            case 146 -> 171;
                            case 147 -> 128;
                            case 148 -> 137;
                            case 149 -> 83;
                            case 150 -> 136;
                            case 151 -> 194;
                            case 152 -> 138;
                            case 153 -> 183;
                            case 154 -> 203;
                            case 155 -> 119;
                            case 156 -> 161;
                            case 157 -> 48;
                            case 158 -> 57;
                            case 159 -> 205;
                            case 160 -> 185;
                            case 161 -> 175;
                            case 162 -> 248;
                            case 163 -> 130;
                            case 164 -> 12;
                            case 165 -> 97;
                            case 166 -> 142;
                            case 167 -> 30;
                            case 168 -> 40;
                            case 169 -> 181;
                            case 170 -> 215;
                            case 171 -> 2;
                            case 172 -> 163;
                            case 173 -> 11;
                            case 174 -> 240;
                            case 175 -> 176;
                            case 176 -> 222;
                            case 177 -> 218;
                            case 178 -> 113;
                            case 179 -> 249;
                            case 180 -> 45;
                            case 181 -> 16;
                            case 182 -> 152;
                            case 183 -> 13;
                            case 184 -> 216;
                            case 185 -> 60;
                            case 186 -> 0;
                            case 187 -> 38;
                            case 188 -> 76;
                            case 189 -> 239;
                            case 190 -> 164;
                            case 191 -> 80;
                            case 192 -> 166;
                            case 193 -> 64;
                            case 194 -> 191;
                            case 195 -> 120;
                            case 196 -> 33;
                            case 197 -> 174;
                            case 198 -> 144;
                            case 199 -> 252;
                            case 200 -> 125;
                            case 201 -> 197;
                            case 202 -> 246;
                            case 203 -> 204;
                            case 204 -> 135;
                            case 205 -> 131;
                            case 206 -> 47;
                            case 207 -> 139;
                            case 208 -> 90;
                            case 209 -> 201;
                            case 210 -> 85;
                            case 211 -> 132;
                            case 212 -> 143;
                            case 213 -> 93;
                            case 214 -> 234;
                            case 215 -> 24;
                            case 216 -> 179;
                            case 217 -> 110;
                            case 218 -> 107;
                            case 219 -> 236;
                            case 220 -> 122;
                            case 221 -> 118;
                            case 222 -> 71;
                            case 223 -> 105;
                            case 224 -> 63;
                            case 225 -> 112;
                            case 226 -> 167;
                            case 227 -> 91;
                            case 228 -> 145;
                            case 229 -> 168;
                            case 230 -> 180;
                            case 231 -> 3;
                            case 232 -> 208;
                            case 233 -> 31;
                            case 234 -> 170;
                            case 235 -> 42;
                            case 236 -> 233;
                            case 237 -> 148;
                            case 238 -> 253;
                            case 239 -> 58;
                            case 240 -> 229;
                            case 241 -> 202;
                            case 242 -> 7;
                            case 243 -> 29;
                            case 244 -> 108;
                            case 245 -> 214;
                            case 246 -> 157;
                            case 247 -> 244;
                            case 248 -> 14;
                            case 249 -> 173;
                            case 250 -> 72;
                            case 251 -> 169;
                            case 252 -> 115;
                            case 253 -> 231;
                            case 254 -> 21;
                            default -> 68;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (n2 == 0) {
                ActionTimestamp.F("zh0lwb");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 45627702308812L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.V();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 == 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2030274300 - -31582, -2030274300 - -28875, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2030274300 - -31594, 2030274300 - 30876, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2030274300 - -31607, 2030274300 - 1982, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2030274300 - -31582, -2030274300 - -28875, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-2030274300 - -31594, 2030274300 - 30876, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2030274300 - -31606, 2030274300 - 28351, (int)l3) + ErrorToolsKt.prettyHRESULT(n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 103814511905008L;
                        int n3 = SshAgentIpcService.V();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(857459940 - (char)-1629, 857459940 - (char)-9001, (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 == 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 == 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(857459940 - (char)-1628, 857459940 - (char)-2213, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 == 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 8964503020564L;
                int n3 = SshAgentIpcService.F();
                this.assertConnectionThread();
                n2 = n3;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 != 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 != 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(906217980 + (char)-2626, 906217980 + (char)-10213, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(906217980 + (char)-2630, -906217980 + -((char)-4020), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(906217980 + (char)-2645, -906349050 - -((char)-8173), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(906217980 + (char)-2630, -906217980 + -((char)-4020), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(906217980 + (char)-2624, 906217980 + (char)-257, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(906217980 + (char)-2626, 906217980 + (char)-10213, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(906217980 + (char)-2630, -906217980 + -((char)-4020), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(906217980 + (char)-2646, -906217980 + -((char)-10789), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 != 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(906217980 + (char)-2626, 906217980 + (char)-10213, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(906217980 + (char)-2630, -906217980 + -((char)-4020), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(906217980 + (char)-2643, -906217980 + -((char)-5252), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 != 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(906217980 + (char)-2626, 906217980 + (char)-10213, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(906217980 + (char)-2630, -906217980 + -((char)-4020), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(906217980 + (char)-2644, 906349050 - (char)-1069, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 22744877714189L;
                    Object object = this.lock;
                    n3 = SshAgentIpcService.V();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 == 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1279), -1269019740 + -((char)-362), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1291), 1269019740 + (char)-2491, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1294), -1269019740 + -((char)-2969), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1295), 1269019740 + (char)-7718, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1279), -1269019740 + -((char)-362), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1291), 1269019740 + (char)-2491, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1296), 1269150810 - (char)-4131, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 == 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 == 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1279), -1269019740 + -((char)-362), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1291), 1269019740 + (char)-2491, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1297), 1269019740 + (char)-10721, (int)l2) + ErrorToolsKt.prettyHRESULT(n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1279), -1269019740 + -((char)-362), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1291), 1269019740 + (char)-2491, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1298), -1269150810 - -((char)-6883), (int)l2));
                    if (n3 == 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1279), -1269019740 + -((char)-362), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1291), 1269019740 + (char)-2491, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1269019740 + -((char)-1299), -1269150810 - -((char)-9126), (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u00e2\u0086\u00b6\u00a7\u00a5\r\u00f7\r\u0014\u00df\u00d1)\u00aa\u00a8$\u00f92\u00deW\u0082\u009a\u00ca\u00b7J(X\u0083j\u00a1\u0006\u00b8\u0085\u00fd\u00c7\u00a6@\u0018O\u0003[\u00c0d\u00acb\u00e3e\u0010\u00fa\u0002\u00a3[57\u001e\t\u008cmAN\u00d3\u00d9\t-\u0015\u0089\u00b3U]\\\u0095\u009e\u0005\u0016\u00b4(\u00e1\u0006\ba'\u00c6\u00e2\u00f9\u0083z>\u0005z\u00d9\u00a5L\u00b7\u001e\u00d2S\u00a5y*_\t\u00e7\u00ad\u0084\u00a8\u0017\u00a5\u00d9W\u0003\u00b3\u001e\u00eb{\u0001\u00a3\u00d7\u00a9\u00f4\u00e0P\"\u00cd\u009e\u0010\u00a1\u0003/\u00b6,\u0094?g\u0016&R\u00be\u00fc\u00b9\u00d3\u0090\t'\u0089\u001e1\u00f4*N\u00e42\u0010{9t\u00f1G|Rz\u00bb\u0085\u00e7\u00caJ7\u0005A?\u0084Ag;\u007f\u001e&\u00a39\u00dd\u007f\u00c7\u00e05\u00c2\u00a7\u00c4\u00efx\u0080\u00fd\u008e3jxp\u00cc\u0084i\u001cN\u00836~\u00e3&\u008b\u00cbT\u0007T&\u00c9\u00e4\u00bc\u00e9\u0006\u00bb\u000fe\u00c3fD\u00eed\u00e0\u00df\u00e1O\u0016:\u00bb\u00ed\b\u00fd/U\u00e3\u008b\u00a34:\f\u007f\"\u0015Y\u009e\u0096x\u009b\u00d7\u00f18@F\u009d0I\u001b\u0015\u00de\t\u0092\u00f9\u00dc\u00f7!g\u00e1-\u001b\u00c5\u001fX1\u00eb\u00ea\u00f2\u00d4v\u008c\u00fe\u0010\u0090\u00a7K\u00c8\u00aa\u00a1\u00b2\u00fc{\u00dd\u00e1\u0001q\u00f3\u00e6\u00a5\u0087D5s\u008e\u0084\u0095\u00f0a\u00aa\u00d6s\u0016\u00e7\u00e0j\u00fc]i\u00c8`Y\u00c3\u00f7\u0003\u00b2\u001f\u00e0\u0090\u00e3\u0001\u00e2P\u0010\u0006\u008e\u00b8\u00cc\u0090)4\u00cd\u000f\u009bw\u0093\u009c\u00c5\u00df\u0098\u008d|\u00b4Vd\u0010\u00a7Y\u000b\u00d3\u001d\u0080\u00be,j.\u0004\u001d\u000ek\u0015\u00df \u0001\u001a\u001b\u0096$\u00e6b\u00b2L\u001a\u0087\u00c9\u0005\u00e6y\u00de\u0012\u00d0\u00c3)\bk\u00fe~A\u00bfd\u00fb\u0000\u0007\u001dg\u0017\u00c0\u0094\u0094\u00ef\u008c\u00c6D\u009f\u00bc\u0015\u00f9\u00a2sZ\u00e4\u00beC\u000ej\u00fcP\u001eO\u00f0\u00b6\u001b\u00c5\u008d\u0007\u0090\u0092\u00e7[FF\u001f\u0007M\u00ae8\u00b0Z\u00d4\u008a(,G6\u00da\u00e8A\u00a7\u0003\b\u00cf6HQ\u00a4\u001e\u009b\u00b9\u00c0\u00a2\u008er\u00db\u00c7\u00deh+\u00b5\u0094t-\u008c\u00beW\u00a1\u00f5\u00dc7\u00b9p\u00d7\u000f\u0007\u00d3\u001daeZ\u00b3\u00a3\u00ffVi*\u001a\u00bc\u00e9\"\u008a9\u00ae4K\u00f6%\u00d2(\"\u0018\u00c3\u00b4X\u0084I\u0006\u001eqT\u0083\u00be6\u00e9U%i\u00f0\u00fc\u00f3\u00e4{\u008f\u0081\u000e\u00f3\u00d7\u0083\u00e1\u00b6J\u00c9\u00a1\u00b0\u0016\u0080\"+\u00b7\u001b=\\]\u0095\u0096qX\u009a\u00d5\u00f6\u00a1?_\"\u00df\u0010\u00c5\u009f\u00b4\u00f8\u0000\u001f5{~\u001aY\n\u008bbOU\u00c0\u008dA/]\"\u0018\u009e\u00e0)\u000f\u0019\u009e\u00889\u00d1K\u00e3\u0017\u00aet\u001d\u00fb\u00ea\u00e3\u0086\u000e>\u008a\u00a9\u009a)zp\u00b0\u001d\u0088\u00d3]v'\u00b6\u00f9Q\u008f\u000f\u0018\u0016\u0000\u00a9\u00e4%\u00e1\u0080\u0093r\u0007\u0090st\u00c8\r{2w\u0085\u00baa\u00baWR\u00f9\u00a4";
                var4_3 = "\u00e2\u0086\u00b6\u00a7\u00a5\r\u00f7\r\u0014\u00df\u00d1)\u00aa\u00a8$\u00f92\u00deW\u0082\u009a\u00ca\u00b7J(X\u0083j\u00a1\u0006\u00b8\u0085\u00fd\u00c7\u00a6@\u0018O\u0003[\u00c0d\u00acb\u00e3e\u0010\u00fa\u0002\u00a3[57\u001e\t\u008cmAN\u00d3\u00d9\t-\u0015\u0089\u00b3U]\\\u0095\u009e\u0005\u0016\u00b4(\u00e1\u0006\ba'\u00c6\u00e2\u00f9\u0083z>\u0005z\u00d9\u00a5L\u00b7\u001e\u00d2S\u00a5y*_\t\u00e7\u00ad\u0084\u00a8\u0017\u00a5\u00d9W\u0003\u00b3\u001e\u00eb{\u0001\u00a3\u00d7\u00a9\u00f4\u00e0P\"\u00cd\u009e\u0010\u00a1\u0003/\u00b6,\u0094?g\u0016&R\u00be\u00fc\u00b9\u00d3\u0090\t'\u0089\u001e1\u00f4*N\u00e42\u0010{9t\u00f1G|Rz\u00bb\u0085\u00e7\u00caJ7\u0005A?\u0084Ag;\u007f\u001e&\u00a39\u00dd\u007f\u00c7\u00e05\u00c2\u00a7\u00c4\u00efx\u0080\u00fd\u008e3jxp\u00cc\u0084i\u001cN\u00836~\u00e3&\u008b\u00cbT\u0007T&\u00c9\u00e4\u00bc\u00e9\u0006\u00bb\u000fe\u00c3fD\u00eed\u00e0\u00df\u00e1O\u0016:\u00bb\u00ed\b\u00fd/U\u00e3\u008b\u00a34:\f\u007f\"\u0015Y\u009e\u0096x\u009b\u00d7\u00f18@F\u009d0I\u001b\u0015\u00de\t\u0092\u00f9\u00dc\u00f7!g\u00e1-\u001b\u00c5\u001fX1\u00eb\u00ea\u00f2\u00d4v\u008c\u00fe\u0010\u0090\u00a7K\u00c8\u00aa\u00a1\u00b2\u00fc{\u00dd\u00e1\u0001q\u00f3\u00e6\u00a5\u0087D5s\u008e\u0084\u0095\u00f0a\u00aa\u00d6s\u0016\u00e7\u00e0j\u00fc]i\u00c8`Y\u00c3\u00f7\u0003\u00b2\u001f\u00e0\u0090\u00e3\u0001\u00e2P\u0010\u0006\u008e\u00b8\u00cc\u0090)4\u00cd\u000f\u009bw\u0093\u009c\u00c5\u00df\u0098\u008d|\u00b4Vd\u0010\u00a7Y\u000b\u00d3\u001d\u0080\u00be,j.\u0004\u001d\u000ek\u0015\u00df \u0001\u001a\u001b\u0096$\u00e6b\u00b2L\u001a\u0087\u00c9\u0005\u00e6y\u00de\u0012\u00d0\u00c3)\bk\u00fe~A\u00bfd\u00fb\u0000\u0007\u001dg\u0017\u00c0\u0094\u0094\u00ef\u008c\u00c6D\u009f\u00bc\u0015\u00f9\u00a2sZ\u00e4\u00beC\u000ej\u00fcP\u001eO\u00f0\u00b6\u001b\u00c5\u008d\u0007\u0090\u0092\u00e7[FF\u001f\u0007M\u00ae8\u00b0Z\u00d4\u008a(,G6\u00da\u00e8A\u00a7\u0003\b\u00cf6HQ\u00a4\u001e\u009b\u00b9\u00c0\u00a2\u008er\u00db\u00c7\u00deh+\u00b5\u0094t-\u008c\u00beW\u00a1\u00f5\u00dc7\u00b9p\u00d7\u000f\u0007\u00d3\u001daeZ\u00b3\u00a3\u00ffVi*\u001a\u00bc\u00e9\"\u008a9\u00ae4K\u00f6%\u00d2(\"\u0018\u00c3\u00b4X\u0084I\u0006\u001eqT\u0083\u00be6\u00e9U%i\u00f0\u00fc\u00f3\u00e4{\u008f\u0081\u000e\u00f3\u00d7\u0083\u00e1\u00b6J\u00c9\u00a1\u00b0\u0016\u0080\"+\u00b7\u001b=\\]\u0095\u0096qX\u009a\u00d5\u00f6\u00a1?_\"\u00df\u0010\u00c5\u009f\u00b4\u00f8\u0000\u001f5{~\u001aY\n\u008bbOU\u00c0\u008dA/]\"\u0018\u009e\u00e0)\u000f\u0019\u009e\u00889\u00d1K\u00e3\u0017\u00aet\u001d\u00fb\u00ea\u00e3\u0086\u000e>\u008a\u00a9\u009a)zp\u00b0\u001d\u0088\u00d3]v'\u00b6\u00f9Q\u008f\u000f\u0018\u0016\u0000\u00a9\u00e4%\u00e1\u0080\u0093r\u0007\u0090st\u00c8\r{2w\u0085\u00baa\u00baWR\u00f9\u00a4".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 33;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00c1O\u00ad\u0098\u00e7\u00bf\u0015b\u008b\u001d!\u0096\u00b4\u00aeg\u00ca\u00cf:\u001aP1\u00e2\u00f9\u0016\u00b9Z[C\u00b0\u0093Q\u0006\u0019\u0013\u0092\u00cf?\u00b5\u00be";
                    var4_3 = "\u00c1O\u00ad\u0098\u00e7\u00bf\u0015b\u008b\u001d!\u0096\u00b4\u00aeg\u00ca\u00cf:\u001aP1\u00e2\u00f9\u0016\u00b9Z[C\u00b0\u0093Q\u0006\u0019\u0013\u0092\u00cf?\u00b5\u00be".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 11;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 79;
                            break;
                        }
                        case 1: {
                            v15 = 8;
                            break;
                        }
                        case 2: {
                            v15 = 8;
                            break;
                        }
                        case 3: {
                            v15 = 82;
                            break;
                        }
                        case 4: {
                            v15 = 89;
                            break;
                        }
                        case 5: {
                            v15 = 30;
                            break;
                        }
                        default: {
                            v15 = 67;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x1BA5) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 243;
                case 1 -> 236;
                case 2 -> 67;
                case 3 -> 7;
                case 4 -> 78;
                case 5 -> 36;
                case 6 -> 104;
                case 7 -> 124;
                case 8 -> 239;
                case 9 -> 183;
                case 10 -> 5;
                case 11 -> 230;
                case 12 -> 254;
                case 13 -> 232;
                case 14 -> 158;
                case 15 -> 133;
                case 16 -> 139;
                case 17 -> 95;
                case 18 -> 212;
                case 19 -> 126;
                case 20 -> 72;
                case 21 -> 145;
                case 22 -> 74;
                case 23 -> 203;
                case 24 -> 144;
                case 25 -> 16;
                case 26 -> 242;
                case 27 -> 55;
                case 28 -> 20;
                case 29 -> 44;
                case 30 -> 34;
                case 31 -> 51;
                case 32 -> 192;
                case 33 -> 209;
                case 34 -> 155;
                case 35 -> 41;
                case 36 -> 176;
                case 37 -> 238;
                case 38 -> 24;
                case 39 -> 71;
                case 40 -> 229;
                case 41 -> 168;
                case 42 -> 82;
                case 43 -> 0;
                case 44 -> 164;
                case 45 -> 214;
                case 46 -> 235;
                case 47 -> 9;
                case 48 -> 119;
                case 49 -> 99;
                case 50 -> 102;
                case 51 -> 65;
                case 52 -> 52;
                case 53 -> 231;
                case 54 -> 246;
                case 55 -> 162;
                case 56 -> 189;
                case 57 -> 217;
                case 58 -> 101;
                case 59 -> 251;
                case 60 -> 35;
                case 61 -> 115;
                case 62 -> 173;
                case 63 -> 48;
                case 64 -> 218;
                case 65 -> 135;
                case 66 -> 171;
                case 67 -> 112;
                case 68 -> 224;
                case 69 -> 92;
                case 70 -> 88;
                case 71 -> 196;
                case 72 -> 42;
                case 73 -> 151;
                case 74 -> 161;
                case 75 -> 32;
                case 76 -> 219;
                case 77 -> 132;
                case 78 -> 13;
                case 79 -> 186;
                case 80 -> 188;
                case 81 -> 53;
                case 82 -> 61;
                case 83 -> 199;
                case 84 -> 159;
                case 85 -> 100;
                case 86 -> 68;
                case 87 -> 208;
                case 88 -> 80;
                case 89 -> 56;
                case 90 -> 27;
                case 91 -> 187;
                case 92 -> 12;
                case 93 -> 49;
                case 94 -> 73;
                case 95 -> 197;
                case 96 -> 202;
                case 97 -> 255;
                case 98 -> 93;
                case 99 -> 38;
                case 100 -> 106;
                case 101 -> 174;
                case 102 -> 149;
                case 103 -> 77;
                case 104 -> 1;
                case 105 -> 234;
                case 106 -> 76;
                case 107 -> 118;
                case 108 -> 122;
                case 109 -> 91;
                case 110 -> 18;
                case 111 -> 81;
                case 112 -> 194;
                case 113 -> 14;
                case 114 -> 29;
                case 115 -> 180;
                case 116 -> 30;
                case 117 -> 105;
                case 118 -> 147;
                case 119 -> 244;
                case 120 -> 54;
                case 121 -> 141;
                case 122 -> 26;
                case 123 -> 137;
                case 124 -> 138;
                case 125 -> 175;
                case 126 -> 204;
                case 127 -> 169;
                case 128 -> 150;
                case 129 -> 11;
                case 130 -> 160;
                case 131 -> 43;
                case 132 -> 86;
                case 133 -> 15;
                case 134 -> 33;
                case 135 -> 195;
                case 136 -> 191;
                case 137 -> 207;
                case 138 -> 221;
                case 139 -> 156;
                case 140 -> 228;
                case 141 -> 62;
                case 142 -> 117;
                case 143 -> 152;
                case 144 -> 178;
                case 145 -> 205;
                case 146 -> 63;
                case 147 -> 70;
                case 148 -> 97;
                case 149 -> 69;
                case 150 -> 248;
                case 151 -> 249;
                case 152 -> 182;
                case 153 -> 136;
                case 154 -> 66;
                case 155 -> 172;
                case 156 -> 200;
                case 157 -> 140;
                case 158 -> 45;
                case 159 -> 64;
                case 160 -> 130;
                case 161 -> 2;
                case 162 -> 94;
                case 163 -> 179;
                case 164 -> 220;
                case 165 -> 31;
                case 166 -> 47;
                case 167 -> 121;
                case 168 -> 165;
                case 169 -> 225;
                case 170 -> 84;
                case 171 -> 125;
                case 172 -> 90;
                case 173 -> 167;
                case 174 -> 87;
                case 175 -> 8;
                case 176 -> 113;
                case 177 -> 103;
                case 178 -> 185;
                case 179 -> 240;
                case 180 -> 79;
                case 181 -> 206;
                case 182 -> 75;
                case 183 -> 109;
                case 184 -> 127;
                case 185 -> 46;
                case 186 -> 193;
                case 187 -> 252;
                case 188 -> 222;
                case 189 -> 3;
                case 190 -> 108;
                case 191 -> 96;
                case 192 -> 184;
                case 193 -> 163;
                case 194 -> 98;
                case 195 -> 50;
                case 196 -> 211;
                case 197 -> 110;
                case 198 -> 21;
                case 199 -> 210;
                case 200 -> 227;
                case 201 -> 123;
                case 202 -> 250;
                case 203 -> 226;
                case 204 -> 148;
                case 205 -> 223;
                case 206 -> 157;
                case 207 -> 6;
                case 208 -> 19;
                case 209 -> 247;
                case 210 -> 241;
                case 211 -> 28;
                case 212 -> 4;
                case 213 -> 134;
                case 214 -> 120;
                case 215 -> 116;
                case 216 -> 233;
                case 217 -> 17;
                case 218 -> 177;
                case 219 -> 253;
                case 220 -> 40;
                case 221 -> 142;
                case 222 -> 129;
                case 223 -> 23;
                case 224 -> 107;
                case 225 -> 39;
                case 226 -> 83;
                case 227 -> 213;
                case 228 -> 190;
                case 229 -> 114;
                case 230 -> 216;
                case 231 -> 57;
                case 232 -> 25;
                case 233 -> 58;
                case 234 -> 198;
                case 235 -> 154;
                case 236 -> 89;
                case 237 -> 22;
                case 238 -> 245;
                case 239 -> 128;
                case 240 -> 166;
                case 241 -> 215;
                case 242 -> 59;
                case 243 -> 143;
                case 244 -> 85;
                case 245 -> 60;
                case 246 -> 37;
                case 247 -> 201;
                case 248 -> 237;
                case 249 -> 146;
                case 250 -> 170;
                case 251 -> 153;
                case 252 -> 10;
                case 253 -> 131;
                case 254 -> 111;
                default -> 181;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 52864460323468L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-2002880670 - -((char)-24510), 2002880670 - (char)-20106, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 2964145883197L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.V();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 == 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 == 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-618388260 + -((char)-56), 618519330 - (char)-4938, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-618388260 + -((char)-59), -618388260 + -((char)-15426), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-618388260 + -((char)-58), -618388260 + -((char)-13333), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "4\u00bd\u00c3\u0012\u00e2\u00b5G7\u0010s]\u00da\u00af{\u00b9\u008d\u00ef.\u0098\u0087\u0080H&h\r";
                    var4_3 = "4\u00bd\u00c3\u0012\u00e2\u00b5G7\u0010s]\u00da\u00af{\u00b9\u008d\u00ef.\u0098\u0087\u0080H&h\r".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 82;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00c8L\u008b\u00fbL5\u00b1\u0090\u00b3\f\u0099#\u001e\u00c0\u00fc\u0011\u0098\u00a6\u008b\u00df\u00c2o\u00a2:\u001dr\u00c2\u00af\u00c1bB\u00e0M33c\u00ac.\u00a8\u00ae\u00bb\u0087\u00fc\u00ad\u00fb\u009e\u00c8\u00b57\u00c7Nc\u0094\u00a1f*D\u00d2\u00f4";
                        var4_3 = "\u00c8L\u008b\u00fbL5\u00b1\u0090\u00b3\f\u0099#\u001e\u00c0\u00fc\u0011\u0098\u00a6\u008b\u00df\u00c2o\u00a2:\u001dr\u00c2\u00af\u00c1bB\u00e0M33c\u00ac.\u00a8\u00ae\u00bb\u0087\u00fc\u00ad\u00fb\u009e\u00c8\u00b57\u00c7Nc\u0094\u00a1f*D\u00d2\u00f4".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 14;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 57;
                                break;
                            }
                            case 1: {
                                v15 = 62;
                                break;
                            }
                            case 2: {
                                v15 = 116;
                                break;
                            }
                            case 3: {
                                v15 = 91;
                                break;
                            }
                            case 4: {
                                v15 = 34;
                                break;
                            }
                            case 5: {
                                v15 = 44;
                                break;
                            }
                            default: {
                                v15 = 105;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFED28) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 59;
                    case 1 -> 107;
                    case 2 -> 88;
                    case 3 -> 228;
                    case 4 -> 243;
                    case 5 -> 104;
                    case 6 -> 2;
                    case 7 -> 165;
                    case 8 -> 60;
                    case 9 -> 171;
                    case 10 -> 226;
                    case 11 -> 244;
                    case 12 -> 20;
                    case 13 -> 36;
                    case 14 -> 170;
                    case 15 -> 48;
                    case 16 -> 11;
                    case 17 -> 132;
                    case 18 -> 31;
                    case 19 -> 38;
                    case 20 -> 216;
                    case 21 -> 30;
                    case 22 -> 235;
                    case 23 -> 179;
                    case 24 -> 210;
                    case 25 -> 189;
                    case 26 -> 249;
                    case 27 -> 122;
                    case 28 -> 15;
                    case 29 -> 241;
                    case 30 -> 248;
                    case 31 -> 229;
                    case 32 -> 50;
                    case 33 -> 44;
                    case 34 -> 232;
                    case 35 -> 146;
                    case 36 -> 78;
                    case 37 -> 26;
                    case 38 -> 76;
                    case 39 -> 141;
                    case 40 -> 127;
                    case 41 -> 156;
                    case 42 -> 7;
                    case 43 -> 197;
                    case 44 -> 201;
                    case 45 -> 6;
                    case 46 -> 198;
                    case 47 -> 187;
                    case 48 -> 176;
                    case 49 -> 190;
                    case 50 -> 95;
                    case 51 -> 68;
                    case 52 -> 71;
                    case 53 -> 194;
                    case 54 -> 250;
                    case 55 -> 89;
                    case 56 -> 80;
                    case 57 -> 150;
                    case 58 -> 102;
                    case 59 -> 254;
                    case 60 -> 185;
                    case 61 -> 230;
                    case 62 -> 222;
                    case 63 -> 218;
                    case 64 -> 191;
                    case 65 -> 147;
                    case 66 -> 100;
                    case 67 -> 195;
                    case 68 -> 40;
                    case 69 -> 246;
                    case 70 -> 253;
                    case 71 -> 130;
                    case 72 -> 140;
                    case 73 -> 217;
                    case 74 -> 163;
                    case 75 -> 173;
                    case 76 -> 128;
                    case 77 -> 8;
                    case 78 -> 17;
                    case 79 -> 19;
                    case 80 -> 142;
                    case 81 -> 96;
                    case 82 -> 208;
                    case 83 -> 114;
                    case 84 -> 10;
                    case 85 -> 166;
                    case 86 -> 41;
                    case 87 -> 91;
                    case 88 -> 172;
                    case 89 -> 66;
                    case 90 -> 13;
                    case 91 -> 99;
                    case 92 -> 83;
                    case 93 -> 21;
                    case 94 -> 25;
                    case 95 -> 117;
                    case 96 -> 214;
                    case 97 -> 34;
                    case 98 -> 175;
                    case 99 -> 211;
                    case 100 -> 116;
                    case 101 -> 54;
                    case 102 -> 29;
                    case 103 -> 169;
                    case 104 -> 159;
                    case 105 -> 203;
                    case 106 -> 52;
                    case 107 -> 121;
                    case 108 -> 207;
                    case 109 -> 12;
                    case 110 -> 153;
                    case 111 -> 204;
                    case 112 -> 105;
                    case 113 -> 154;
                    case 114 -> 111;
                    case 115 -> 33;
                    case 116 -> 125;
                    case 117 -> 186;
                    case 118 -> 42;
                    case 119 -> 223;
                    case 120 -> 32;
                    case 121 -> 119;
                    case 122 -> 167;
                    case 123 -> 0;
                    case 124 -> 219;
                    case 125 -> 220;
                    case 126 -> 178;
                    case 127 -> 87;
                    case 128 -> 72;
                    case 129 -> 35;
                    case 130 -> 182;
                    case 131 -> 225;
                    case 132 -> 160;
                    case 133 -> 23;
                    case 134 -> 16;
                    case 135 -> 24;
                    case 136 -> 242;
                    case 137 -> 251;
                    case 138 -> 55;
                    case 139 -> 94;
                    case 140 -> 86;
                    case 141 -> 113;
                    case 142 -> 138;
                    case 143 -> 136;
                    case 144 -> 231;
                    case 145 -> 69;
                    case 146 -> 62;
                    case 147 -> 255;
                    case 148 -> 157;
                    case 149 -> 84;
                    case 150 -> 65;
                    case 151 -> 106;
                    case 152 -> 37;
                    case 153 -> 67;
                    case 154 -> 45;
                    case 155 -> 5;
                    case 156 -> 110;
                    case 157 -> 126;
                    case 158 -> 149;
                    case 159 -> 209;
                    case 160 -> 53;
                    case 161 -> 39;
                    case 162 -> 14;
                    case 163 -> 18;
                    case 164 -> 22;
                    case 165 -> 168;
                    case 166 -> 152;
                    case 167 -> 82;
                    case 168 -> 77;
                    case 169 -> 1;
                    case 170 -> 137;
                    case 171 -> 64;
                    case 172 -> 151;
                    case 173 -> 27;
                    case 174 -> 212;
                    case 175 -> 108;
                    case 176 -> 180;
                    case 177 -> 81;
                    case 178 -> 240;
                    case 179 -> 174;
                    case 180 -> 98;
                    case 181 -> 123;
                    case 182 -> 224;
                    case 183 -> 9;
                    case 184 -> 118;
                    case 185 -> 145;
                    case 186 -> 247;
                    case 187 -> 139;
                    case 188 -> 28;
                    case 189 -> 183;
                    case 190 -> 213;
                    case 191 -> 221;
                    case 192 -> 103;
                    case 193 -> 143;
                    case 194 -> 202;
                    case 195 -> 63;
                    case 196 -> 131;
                    case 197 -> 236;
                    case 198 -> 177;
                    case 199 -> 206;
                    case 200 -> 3;
                    case 201 -> 252;
                    case 202 -> 56;
                    case 203 -> 129;
                    case 204 -> 199;
                    case 205 -> 200;
                    case 206 -> 73;
                    case 207 -> 112;
                    case 208 -> 135;
                    case 209 -> 97;
                    case 210 -> 101;
                    case 211 -> 237;
                    case 212 -> 193;
                    case 213 -> 164;
                    case 214 -> 155;
                    case 215 -> 51;
                    case 216 -> 115;
                    case 217 -> 70;
                    case 218 -> 144;
                    case 219 -> 134;
                    case 220 -> 238;
                    case 221 -> 245;
                    case 222 -> 227;
                    case 223 -> 205;
                    case 224 -> 92;
                    case 225 -> 93;
                    case 226 -> 192;
                    case 227 -> 133;
                    case 228 -> 57;
                    case 229 -> 162;
                    case 230 -> 239;
                    case 231 -> 90;
                    case 232 -> 215;
                    case 233 -> 184;
                    case 234 -> 120;
                    case 235 -> 85;
                    case 236 -> 61;
                    case 237 -> 234;
                    case 238 -> 4;
                    case 239 -> 161;
                    case 240 -> 49;
                    case 241 -> 233;
                    case 242 -> 109;
                    case 243 -> 196;
                    case 244 -> 47;
                    case 245 -> 75;
                    case 246 -> 124;
                    case 247 -> 181;
                    case 248 -> 74;
                    case 249 -> 43;
                    case 250 -> 188;
                    case 251 -> 79;
                    case 252 -> 58;
                    case 253 -> 46;
                    case 254 -> 158;
                    default -> 148;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 59991537301861L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\\8q_\u0018w3\u0005\t[2bUU5.\u0019t";
                    var5_4 = "\\8q_\u0018w3\u0005\t[2bUU5.\u0019t".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 36;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 19;
                                    break;
                                }
                                case 1: {
                                    v11 = 121;
                                    break;
                                }
                                case 2: {
                                    v11 = 39;
                                    break;
                                }
                                case 3: {
                                    v11 = 21;
                                    break;
                                }
                                case 4: {
                                    v11 = 89;
                                    break;
                                }
                                case 5: {
                                    v11 = 63;
                                    break;
                                }
                                default: {
                                    v11 = 36;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 92258139238865L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "n59\u0016R11\u0004h+5\f\nd4>\f^3)N57\td4>\f^3)B?\rc2#\u0001T>3B8$\u000bU7";
                    var5_4 = "n59\u0016R11\u0004h+5\f\nd4>\f^3)N57\td4>\f^3)B?\rc2#\u0001T>3B8$\u000bU7".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 7;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u0000S[u6Z^\u0006\u0000S[u:P";
                        var5_4 = "\u0000S[u6Z^\u0006\u0000S[u:P".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 99;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 32;
                                break;
                            }
                            case 1: {
                                v15 = 92;
                                break;
                            }
                            case 2: {
                                v15 = 87;
                                break;
                            }
                            case 3: {
                                v15 = 101;
                                break;
                            }
                            case 4: {
                                v15 = 60;
                                break;
                            }
                            case 5: {
                                v15 = 87;
                                break;
                            }
                            default: {
                                v15 = 90;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n25#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 119137829234086L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-268562430 + -24559, -268562430 + -14915, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 138131735517596L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "7&\u00bb\u008eS\u0003\u008fL\u0018\u0005\u00d2\u00af!{\u00e3\r'&\u00a9\u0000\u0007\u0085u\u00e5\u00b0c\u009c\u009f\u0091\u0010@\u00ff\u0082\u00d0]\n\u0015)u~\u00c7q\u001cDR\t\u0005\u00ae\u00d9\u00ae\u00b5\u001237:\u008c\u00beI\u0083\u00a7\f^')s\u0007U\u001d4\u0080\u00b6\u00d4h\u00d7\u008d\u009aG\u001e!\u00a4\u00d6\u00d7\u00f4\u00e6}\u00da\u00e9\u009ec=\u009a\u008f\u0088P\u00a6R\bz\u0014\u0086\u00ee&\u0094#";
                    var4_3 = "7&\u00bb\u008eS\u0003\u008fL\u0018\u0005\u00d2\u00af!{\u00e3\r'&\u00a9\u0000\u0007\u0085u\u00e5\u00b0c\u009c\u009f\u0091\u0010@\u00ff\u0082\u00d0]\n\u0015)u~\u00c7q\u001cDR\t\u0005\u00ae\u00d9\u00ae\u00b5\u001237:\u008c\u00beI\u0083\u00a7\f^')s\u0007U\u001d4\u0080\u00b6\u00d4h\u00d7\u008d\u009aG\u001e!\u00a4\u00d6\u00d7\u00f4\u00e6}\u00da\u00e9\u009ec=\u009a\u008f\u0088P\u00a6R\bz\u0014\u0086\u00ee&\u0094#".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 90;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u001eI\u00c8\u0087\u0095a\u008d\u00c5\u00e7b\u0014s\u00e7\u0085\u00ac\u00b0L\u008b\u00cc\u008d\u00fd\u0017\u00e6\u00b3[\u00a9\"q\u00c2E=k\u00de\u00ca\u00bb\u00e3\u00be\u00d8\u00b2\u00d0\u0083\u00f5\u00d3}\u00cf\u0097\u001f\u0080\u00ee\u0087\u00f4\u00c5]\u00e5\u0002/|\u00f3Dh\u00a8\u00a9_\u00b6>S;\u00e4\f\u00f7?>\u00ad\u008c;\u00fa\f\u00fdS8`\u0098\\^s\u00ca\u00f0\u00cc\u00b7\u00d1\u00a9\u008dk";
                        var4_3 = "\u001eI\u00c8\u0087\u0095a\u008d\u00c5\u00e7b\u0014s\u00e7\u0085\u00ac\u00b0L\u008b\u00cc\u008d\u00fd\u0017\u00e6\u00b3[\u00a9\"q\u00c2E=k\u00de\u00ca\u00bb\u00e3\u00be\u00d8\u00b2\u00d0\u0083\u00f5\u00d3}\u00cf\u0097\u001f\u0080\u00ee\u0087\u00f4\u00c5]\u00e5\u0002/|\u00f3Dh\u00a8\u00a9_\u00b6>S;\u00e4\f\u00f7?>\u00ad\u008c;\u00fa\f\u00fdS8`\u0098\\^s\u00ca\u00f0\u00cc\u00b7\u00d1\u00a9\u008dk".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 127;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 3;
                                break;
                            }
                            case 1: {
                                v15 = 125;
                                break;
                            }
                            case 2: {
                                v15 = 4;
                                break;
                            }
                            case 3: {
                                v15 = 17;
                                break;
                            }
                            case 4: {
                                v15 = 8;
                                break;
                            }
                            case 5: {
                                v15 = 48;
                                break;
                            }
                            default: {
                                v15 = 121;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x15B5) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 228;
                    case 1 -> 0;
                    case 2 -> 160;
                    case 3 -> 105;
                    case 4 -> 253;
                    case 5 -> 200;
                    case 6 -> 206;
                    case 7 -> 89;
                    case 8 -> 134;
                    case 9 -> 142;
                    case 10 -> 111;
                    case 11 -> 209;
                    case 12 -> 147;
                    case 13 -> 140;
                    case 14 -> 227;
                    case 15 -> 94;
                    case 16 -> 189;
                    case 17 -> 1;
                    case 18 -> 232;
                    case 19 -> 40;
                    case 20 -> 3;
                    case 21 -> 162;
                    case 22 -> 76;
                    case 23 -> 145;
                    case 24 -> 70;
                    case 25 -> 170;
                    case 26 -> 154;
                    case 27 -> 128;
                    case 28 -> 43;
                    case 29 -> 194;
                    case 30 -> 179;
                    case 31 -> 30;
                    case 32 -> 188;
                    case 33 -> 12;
                    case 34 -> 243;
                    case 35 -> 7;
                    case 36 -> 198;
                    case 37 -> 222;
                    case 38 -> 210;
                    case 39 -> 90;
                    case 40 -> 219;
                    case 41 -> 234;
                    case 42 -> 180;
                    case 43 -> 254;
                    case 44 -> 171;
                    case 45 -> 17;
                    case 46 -> 93;
                    case 47 -> 173;
                    case 48 -> 215;
                    case 49 -> 121;
                    case 50 -> 143;
                    case 51 -> 169;
                    case 52 -> 237;
                    case 53 -> 103;
                    case 54 -> 175;
                    case 55 -> 98;
                    case 56 -> 45;
                    case 57 -> 6;
                    case 58 -> 117;
                    case 59 -> 114;
                    case 60 -> 46;
                    case 61 -> 36;
                    case 62 -> 167;
                    case 63 -> 82;
                    case 64 -> 225;
                    case 65 -> 95;
                    case 66 -> 24;
                    case 67 -> 214;
                    case 68 -> 138;
                    case 69 -> 155;
                    case 70 -> 57;
                    case 71 -> 33;
                    case 72 -> 166;
                    case 73 -> 79;
                    case 74 -> 104;
                    case 75 -> 126;
                    case 76 -> 213;
                    case 77 -> 92;
                    case 78 -> 118;
                    case 79 -> 245;
                    case 80 -> 67;
                    case 81 -> 182;
                    case 82 -> 144;
                    case 83 -> 226;
                    case 84 -> 83;
                    case 85 -> 251;
                    case 86 -> 233;
                    case 87 -> 39;
                    case 88 -> 231;
                    case 89 -> 28;
                    case 90 -> 38;
                    case 91 -> 168;
                    case 92 -> 156;
                    case 93 -> 230;
                    case 94 -> 148;
                    case 95 -> 152;
                    case 96 -> 204;
                    case 97 -> 49;
                    case 98 -> 75;
                    case 99 -> 203;
                    case 100 -> 109;
                    case 101 -> 174;
                    case 102 -> 86;
                    case 103 -> 97;
                    case 104 -> 223;
                    case 105 -> 37;
                    case 106 -> 19;
                    case 107 -> 25;
                    case 108 -> 135;
                    case 109 -> 62;
                    case 110 -> 10;
                    case 111 -> 77;
                    case 112 -> 129;
                    case 113 -> 58;
                    case 114 -> 120;
                    case 115 -> 187;
                    case 116 -> 255;
                    case 117 -> 74;
                    case 118 -> 195;
                    case 119 -> 224;
                    case 120 -> 163;
                    case 121 -> 218;
                    case 122 -> 101;
                    case 123 -> 208;
                    case 124 -> 197;
                    case 125 -> 217;
                    case 126 -> 190;
                    case 127 -> 73;
                    case 128 -> 47;
                    case 129 -> 235;
                    case 130 -> 153;
                    case 131 -> 35;
                    case 132 -> 252;
                    case 133 -> 52;
                    case 134 -> 91;
                    case 135 -> 130;
                    case 136 -> 56;
                    case 137 -> 116;
                    case 138 -> 201;
                    case 139 -> 41;
                    case 140 -> 96;
                    case 141 -> 131;
                    case 142 -> 14;
                    case 143 -> 139;
                    case 144 -> 48;
                    case 145 -> 44;
                    case 146 -> 193;
                    case 147 -> 31;
                    case 148 -> 81;
                    case 149 -> 119;
                    case 150 -> 113;
                    case 151 -> 108;
                    case 152 -> 185;
                    case 153 -> 16;
                    case 154 -> 150;
                    case 155 -> 248;
                    case 156 -> 85;
                    case 157 -> 221;
                    case 158 -> 220;
                    case 159 -> 149;
                    case 160 -> 159;
                    case 161 -> 125;
                    case 162 -> 151;
                    case 163 -> 229;
                    case 164 -> 53;
                    case 165 -> 9;
                    case 166 -> 239;
                    case 167 -> 240;
                    case 168 -> 122;
                    case 169 -> 146;
                    case 170 -> 29;
                    case 171 -> 64;
                    case 172 -> 136;
                    case 173 -> 165;
                    case 174 -> 78;
                    case 175 -> 65;
                    case 176 -> 192;
                    case 177 -> 66;
                    case 178 -> 20;
                    case 179 -> 246;
                    case 180 -> 110;
                    case 181 -> 4;
                    case 182 -> 249;
                    case 183 -> 137;
                    case 184 -> 72;
                    case 185 -> 100;
                    case 186 -> 63;
                    case 187 -> 32;
                    case 188 -> 216;
                    case 189 -> 196;
                    case 190 -> 55;
                    case 191 -> 191;
                    case 192 -> 59;
                    case 193 -> 107;
                    case 194 -> 34;
                    case 195 -> 176;
                    case 196 -> 18;
                    case 197 -> 199;
                    case 198 -> 15;
                    case 199 -> 22;
                    case 200 -> 244;
                    case 201 -> 87;
                    case 202 -> 236;
                    case 203 -> 112;
                    case 204 -> 5;
                    case 205 -> 21;
                    case 206 -> 23;
                    case 207 -> 123;
                    case 208 -> 242;
                    case 209 -> 141;
                    case 210 -> 61;
                    case 211 -> 127;
                    case 212 -> 80;
                    case 213 -> 177;
                    case 214 -> 238;
                    case 215 -> 69;
                    case 216 -> 50;
                    case 217 -> 183;
                    case 218 -> 207;
                    case 219 -> 211;
                    case 220 -> 205;
                    case 221 -> 241;
                    case 222 -> 54;
                    case 223 -> 99;
                    case 224 -> 26;
                    case 225 -> 133;
                    case 226 -> 164;
                    case 227 -> 186;
                    case 228 -> 161;
                    case 229 -> 158;
                    case 230 -> 51;
                    case 231 -> 178;
                    case 232 -> 157;
                    case 233 -> 42;
                    case 234 -> 13;
                    case 235 -> 8;
                    case 236 -> 68;
                    case 237 -> 124;
                    case 238 -> 60;
                    case 239 -> 181;
                    case 240 -> 184;
                    case 241 -> 102;
                    case 242 -> 212;
                    case 243 -> 71;
                    case 244 -> 84;
                    case 245 -> 247;
                    case 246 -> 202;
                    case 247 -> 27;
                    case 248 -> 2;
                    case 249 -> 11;
                    case 250 -> 106;
                    case 251 -> 250;
                    case 252 -> 132;
                    case 253 -> 88;
                    case 254 -> 115;
                    default -> 172;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 38182484537565L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(225309330 - (char)-5571, -225309330 - -((char)-6654), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 83886424459540L;
                    int n3 = SshAgentIpcService.F();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1418177400 + (char)-14811, -1418177400 + -((char)-16273), (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 != 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 19140145002100L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\":\u00f5\u000bq\u0003\u00acMr";
                var4_3 = "\":\u00f5\u000bq\u0003\u00acMr".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 44;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 50;
                                break;
                            }
                            case 1: {
                                v11 = 66;
                                break;
                            }
                            case 2: {
                                v11 = 118;
                                break;
                            }
                            case 3: {
                                v11 = 72;
                                break;
                            }
                            case 4: {
                                v11 = 21;
                                break;
                            }
                            case 5: {
                                v11 = 86;
                                break;
                            }
                            default: {
                                v11 = 103;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x7888) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 254;
                    case 1 -> 89;
                    case 2 -> 93;
                    case 3 -> 105;
                    case 4 -> 222;
                    case 5 -> 164;
                    case 6 -> 40;
                    case 7 -> 13;
                    case 8 -> 160;
                    case 9 -> 111;
                    case 10 -> 217;
                    case 11 -> 98;
                    case 12 -> 23;
                    case 13 -> 227;
                    case 14 -> 146;
                    case 15 -> 247;
                    case 16 -> 181;
                    case 17 -> 103;
                    case 18 -> 144;
                    case 19 -> 125;
                    case 20 -> 56;
                    case 21 -> 43;
                    case 22 -> 129;
                    case 23 -> 236;
                    case 24 -> 156;
                    case 25 -> 67;
                    case 26 -> 148;
                    case 27 -> 33;
                    case 28 -> 161;
                    case 29 -> 15;
                    case 30 -> 221;
                    case 31 -> 78;
                    case 32 -> 47;
                    case 33 -> 174;
                    case 34 -> 149;
                    case 35 -> 26;
                    case 36 -> 192;
                    case 37 -> 242;
                    case 38 -> 118;
                    case 39 -> 14;
                    case 40 -> 84;
                    case 41 -> 74;
                    case 42 -> 91;
                    case 43 -> 138;
                    case 44 -> 239;
                    case 45 -> 176;
                    case 46 -> 81;
                    case 47 -> 65;
                    case 48 -> 109;
                    case 49 -> 49;
                    case 50 -> 32;
                    case 51 -> 95;
                    case 52 -> 18;
                    case 53 -> 208;
                    case 54 -> 213;
                    case 55 -> 92;
                    case 56 -> 42;
                    case 57 -> 243;
                    case 58 -> 168;
                    case 59 -> 115;
                    case 60 -> 80;
                    case 61 -> 87;
                    case 62 -> 35;
                    case 63 -> 216;
                    case 64 -> 38;
                    case 65 -> 152;
                    case 66 -> 30;
                    case 67 -> 122;
                    case 68 -> 229;
                    case 69 -> 28;
                    case 70 -> 17;
                    case 71 -> 96;
                    case 72 -> 251;
                    case 73 -> 22;
                    case 74 -> 79;
                    case 75 -> 151;
                    case 76 -> 7;
                    case 77 -> 124;
                    case 78 -> 245;
                    case 79 -> 202;
                    case 80 -> 159;
                    case 81 -> 188;
                    case 82 -> 37;
                    case 83 -> 184;
                    case 84 -> 230;
                    case 85 -> 106;
                    case 86 -> 86;
                    case 87 -> 4;
                    case 88 -> 226;
                    case 89 -> 63;
                    case 90 -> 190;
                    case 91 -> 20;
                    case 92 -> 66;
                    case 93 -> 126;
                    case 94 -> 119;
                    case 95 -> 70;
                    case 96 -> 167;
                    case 97 -> 133;
                    case 98 -> 114;
                    case 99 -> 140;
                    case 100 -> 206;
                    case 101 -> 233;
                    case 102 -> 240;
                    case 103 -> 12;
                    case 104 -> 145;
                    case 105 -> 71;
                    case 106 -> 102;
                    case 107 -> 191;
                    case 108 -> 143;
                    case 109 -> 34;
                    case 110 -> 171;
                    case 111 -> 6;
                    case 112 -> 244;
                    case 113 -> 44;
                    case 114 -> 83;
                    case 115 -> 36;
                    case 116 -> 27;
                    case 117 -> 137;
                    case 118 -> 39;
                    case 119 -> 241;
                    case 120 -> 204;
                    case 121 -> 163;
                    case 122 -> 238;
                    case 123 -> 212;
                    case 124 -> 116;
                    case 125 -> 150;
                    case 126 -> 60;
                    case 127 -> 21;
                    case 128 -> 173;
                    case 129 -> 210;
                    case 130 -> 110;
                    case 131 -> 187;
                    case 132 -> 57;
                    case 133 -> 207;
                    case 134 -> 85;
                    case 135 -> 215;
                    case 136 -> 58;
                    case 137 -> 59;
                    case 138 -> 155;
                    case 139 -> 195;
                    case 140 -> 232;
                    case 141 -> 130;
                    case 142 -> 218;
                    case 143 -> 113;
                    case 144 -> 104;
                    case 145 -> 112;
                    case 146 -> 9;
                    case 147 -> 48;
                    case 148 -> 249;
                    case 149 -> 73;
                    case 150 -> 237;
                    case 151 -> 52;
                    case 152 -> 25;
                    case 153 -> 224;
                    case 154 -> 131;
                    case 155 -> 201;
                    case 156 -> 223;
                    case 157 -> 183;
                    case 158 -> 235;
                    case 159 -> 135;
                    case 160 -> 250;
                    case 161 -> 189;
                    case 162 -> 8;
                    case 163 -> 99;
                    case 164 -> 46;
                    case 165 -> 132;
                    case 166 -> 211;
                    case 167 -> 75;
                    case 168 -> 178;
                    case 169 -> 198;
                    case 170 -> 19;
                    case 171 -> 234;
                    case 172 -> 50;
                    case 173 -> 121;
                    case 174 -> 94;
                    case 175 -> 90;
                    case 176 -> 127;
                    case 177 -> 219;
                    case 178 -> 76;
                    case 179 -> 166;
                    case 180 -> 179;
                    case 181 -> 128;
                    case 182 -> 153;
                    case 183 -> 134;
                    case 184 -> 199;
                    case 185 -> 220;
                    case 186 -> 214;
                    case 187 -> 82;
                    case 188 -> 185;
                    case 189 -> 200;
                    case 190 -> 10;
                    case 191 -> 225;
                    case 192 -> 0;
                    case 193 -> 29;
                    case 194 -> 253;
                    case 195 -> 2;
                    case 196 -> 142;
                    case 197 -> 172;
                    case 198 -> 120;
                    case 199 -> 170;
                    case 200 -> 97;
                    case 201 -> 209;
                    case 202 -> 196;
                    case 203 -> 147;
                    case 204 -> 169;
                    case 205 -> 139;
                    case 206 -> 154;
                    case 207 -> 203;
                    case 208 -> 5;
                    case 209 -> 193;
                    case 210 -> 141;
                    case 211 -> 180;
                    case 212 -> 246;
                    case 213 -> 55;
                    case 214 -> 252;
                    case 215 -> 197;
                    case 216 -> 69;
                    case 217 -> 88;
                    case 218 -> 61;
                    case 219 -> 248;
                    case 220 -> 186;
                    case 221 -> 72;
                    case 222 -> 231;
                    case 223 -> 54;
                    case 224 -> 3;
                    case 225 -> 31;
                    case 226 -> 45;
                    case 227 -> 182;
                    case 228 -> 11;
                    case 229 -> 101;
                    case 230 -> 136;
                    case 231 -> 108;
                    case 232 -> 123;
                    case 233 -> 24;
                    case 234 -> 100;
                    case 235 -> 62;
                    case 236 -> 194;
                    case 237 -> 64;
                    case 238 -> 1;
                    case 239 -> 255;
                    case 240 -> 205;
                    case 241 -> 165;
                    case 242 -> 16;
                    case 243 -> 228;
                    case 244 -> 117;
                    case 245 -> 175;
                    case 246 -> 41;
                    case 247 -> 77;
                    case 248 -> 157;
                    case 249 -> 53;
                    case 250 -> 162;
                    case 251 -> 158;
                    case 252 -> 107;
                    case 253 -> 68;
                    case 254 -> 177;
                    default -> 51;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

