/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote.docker.dockerCompose;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.compose.cli.DockerComposeCliCmd;
import com.intellij.docker.compose.cli.DockerComposeCliParser;
import com.intellij.docker.compose.cli.DockerComposeCliSubCmd;
import com.intellij.docker.compose.cli.DockerComposeRunCmd;
import com.intellij.docker.compose.cli.DockerComposeUpCmd;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerComposeCredentialsType;
import com.intellij.docker.remote.compose.run.configuration.DockerComposeSettings;
import com.intellij.docker.remote.compose.run.configuration.DockerComposeSettingsEditor;
import com.intellij.docker.remote.compose.target.DockerComposeEnvironmentRequest;
import com.intellij.docker.remote.compose.target.DockerComposeTargetEnvironmentConfiguration;
import com.intellij.docker.remote.compose.target.DockerComposeTargetType;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeTargetRunSetup;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkAdditionalData;
import com.jetbrains.nodejs.remote.NodeRemoteTargetRunSetup;
import com.jetbrains.nodejs.remote.NodeRemoteTargetRunSetupFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/nodejs/remote/docker/dockerCompose/NodeDockerComposeTargetRunSetupFactory;", "Lcom/jetbrains/nodejs/remote/NodeRemoteTargetRunSetupFactory;", "Lcom/intellij/docker/remote/DockerComposeCredentialsHolder;", "<init>", "()V", "credentialType", "Lcom/intellij/docker/remote/DockerComposeCredentialsType;", "getTargetEnvironmentType", "Lcom/intellij/docker/remote/compose/target/DockerComposeTargetType;", "createTargetRunSetup", "Lcom/intellij/javascript/nodejs/interpreter/NodeTargetRunSetup;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/nodejs/remote/NodeJSRemoteSdkAdditionalData;", "options", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRunOptions;", "credentials", "createDockerComposeEnvironmentRequest", "Lcom/intellij/docker/remote/compose/target/DockerComposeEnvironmentRequest;", "holder", "createDefaultDockerComposeCmd", "Lcom/intellij/docker/compose/cli/DockerComposeCliSubCmd;", "useUpCmd", "", "serviceName", "", "intellij.nodeJS.remoteInterpreter"})
@SourceDebugExtension(value={"SMAP\nNodeDockerComposeTargetRunSetupFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeDockerComposeTargetRunSetupFactory.kt\ncom/jetbrains/nodejs/remote/docker/dockerCompose/NodeDockerComposeTargetRunSetupFactory\n+ 2 TargetEnvironmentType.kt\ncom/intellij/execution/target/TargetEnvironmentTypeKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n132#2:79\n1#3:80\n*S KotlinDebug\n*F\n+ 1 NodeDockerComposeTargetRunSetupFactory.kt\ncom/jetbrains/nodejs/remote/docker/dockerCompose/NodeDockerComposeTargetRunSetupFactory\n*L\n28#1:79\n*E\n"})
public final class NodeDockerComposeTargetRunSetupFactory
implements NodeRemoteTargetRunSetupFactory<DockerComposeCredentialsHolder> {
    @NotNull
    public DockerComposeCredentialsType credentialType() {
        DockerComposeCredentialsType dockerComposeCredentialsType = DockerComposeCredentialsType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dockerComposeCredentialsType, (String)"getInstance(...)");
        return dockerComposeCredentialsType;
    }

    @NotNull
    public DockerComposeTargetType getTargetEnvironmentType() throws IllegalStateException {
        boolean $i$f$findTargetEnvironmentType = false;
        return (DockerComposeTargetType)TargetEnvironmentType.Companion.findInstance(DockerComposeTargetType.class);
    }

    @Override
    @NotNull
    public NodeTargetRunSetup createTargetRunSetup(@NotNull Project project, @NotNull NodeJSRemoteSdkAdditionalData data, @NotNull NodeTargetRunOptions options, @NotNull DockerComposeCredentialsHolder credentials) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        DockerComposeEnvironmentRequest request = this.createDockerComposeEnvironmentRequest(credentials, options);
        return new NodeRemoteTargetRunSetup(options, data, (TargetEnvironmentRequest)request, null);
    }

    private final DockerComposeEnvironmentRequest createDockerComposeEnvironmentRequest(DockerComposeCredentialsHolder holder, NodeTargetRunOptions options) {
        DockerComposeCliCmd dockerComposeCliCmd;
        DockerComposeSettings dockerComposeSettings;
        DockerComposeEnvironmentRequest dockerComposeEnvironmentRequest;
        RemoteServer remoteServer = RemoteServersManager.getInstance().findByName(holder.getAccountName(), (ServerType)DockerCloudType.getInstance());
        if (remoteServer == null) {
            throw new IllegalStateException("Cannot find Docker Server " + holder.getAccountName());
        }
        RemoteServer dockerServer = remoteServer;
        ServerConfiguration serverConfiguration = dockerServer.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)serverConfiguration, (String)"getConfiguration(...)");
        DockerCloudConfiguration dockerCloudConfiguration = (DockerCloudConfiguration)serverConfiguration;
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.Companion.create(dockerCloudConfiguration, null);
        DockerComposeTargetEnvironmentConfiguration configuration = new DockerComposeTargetEnvironmentConfiguration();
        configuration.setDockerServer(dockerServer);
        configuration.setConfigurationFiles(holder.getComposeFilePaths());
        configuration.setServiceName(holder.getComposeServiceName());
        DockerComposeEnvironmentRequest it = dockerComposeEnvironmentRequest = new DockerComposeEnvironmentRequest(dockerRuntime, configuration);
        boolean bl = false;
        RunConfigurationBase runConfigurationBase = options.getRunConfiguration();
        DockerComposeSettings dockerComposeSettings2 = dockerComposeSettings = runConfigurationBase != null ? (DockerComposeSettings)runConfigurationBase.getCopyableUserData(DockerComposeSettings.KEY) : null;
        boolean bl2 = dockerComposeSettings2 != null ? !DockerComposeSettingsEditor.Companion.hasDefaultValue(dockerComposeSettings2) : false;
        if (bl2) {
            DockerComposeCliParser dockerComposeCliParser = new DockerComposeCliParser();
            String[] stringArray = ParametersListUtil.parseToArray((String)dockerComposeSettings.getCommandLine());
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"parseToArray(...)");
            dockerComposeCliCmd = dockerComposeCliParser.parse(stringArray);
        } else {
            dockerComposeCliCmd = new DockerComposeCliCmd(null, this.createDefaultDockerComposeCmd(options.getRunConfiguration() != null, it.getServiceName()), 1, null);
        }
        it.setDockerComposeCliCmd(dockerComposeCliCmd);
        return dockerComposeEnvironmentRequest;
    }

    private final DockerComposeCliSubCmd createDefaultDockerComposeCmd(boolean useUpCmd, String serviceName) {
        DockerComposeRunCmd dockerComposeRunCmd;
        if (useUpCmd) {
            DockerComposeUpCmd upCmd;
            DockerComposeUpCmd dockerComposeUpCmd;
            DockerComposeUpCmd it;
            DockerComposeUpCmd dockerComposeUpCmd2;
            if (serviceName != null) {
                dockerComposeUpCmd2 = new DockerComposeUpCmd[]{serviceName};
                it = dockerComposeUpCmd2 = new DockerComposeUpCmd(CollectionsKt.mutableListOf((Object[])dockerComposeUpCmd2));
                boolean bl = false;
                it.addOption("--exit-code-from", serviceName);
                dockerComposeUpCmd = dockerComposeUpCmd2;
            } else {
                dockerComposeUpCmd = new DockerComposeUpCmd(null, 1, null);
            }
            it = dockerComposeUpCmd2 = (upCmd = dockerComposeUpCmd);
            boolean bl = false;
            DockerComposeCliSubCmd.addOption$default((DockerComposeCliSubCmd)((DockerComposeCliSubCmd)it), (String)"--abort-on-container-exit", null, (int)2, null);
            return (DockerComposeCliSubCmd)dockerComposeUpCmd2;
        }
        DockerComposeRunCmd $this$createDefaultDockerComposeCmd_u24lambda_u243 = dockerComposeRunCmd = new DockerComposeRunCmd();
        boolean bl = false;
        DockerComposeCliSubCmd.addOption$default((DockerComposeCliSubCmd)((DockerComposeCliSubCmd)$this$createDefaultDockerComposeCmd_u24lambda_u243), (String)"--rm", null, (int)2, null);
        return (DockerComposeCliSubCmd)dockerComposeRunCmd;
    }
}

