/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.statistic;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DeploymentServersUsagesCollector
extends ProjectUsagesCollector {
    static final String GROUP_ID = "deployment.servers";
    private static final EventLogGroup GROUP = new EventLogGroup("deployment.servers", 6);
    public static final EnumEventField<AccessType> TYPE = EventFields.Enum((String)"type", AccessType.class, type -> StringUtil.toLowerCase((String)type.name()));
    public static final EnumEventField<AuthType> AUTH = EventFields.Enum((String)"auth", AuthType.class, type -> StringUtil.toLowerCase((String)type.name()));
    public static final BooleanEventField RSYNC = EventFields.Boolean((String)"rsync");
    public static final BooleanEventField SUDO = EventFields.Boolean((String)"sudo");
    public static final BooleanEventField HIDDEN_FILES = EventFields.Boolean((String)"hiddenFiles");
    public static final BooleanEventField PASSIVE_MODE = EventFields.Boolean((String)"passiveMode");
    public static final BooleanEventField COMPATIBILITY_MODE = EventFields.Boolean((String)"compatibilityMode");
    public static final IntEventField MAPPINGS_TOGETHER = EventFields.Int((String)"mappingsTogether");
    public static final IntEventField MAPPINGS_DEPLOY = EventFields.Int((String)"mappingsDeploy");
    public static final IntEventField MAPPINGS_WEB = EventFields.Int((String)"mappingsWeb");
    public static final StringEventField ROOT_PATH = EventFields.String((String)"rootPath", List.of("nontrivial", "trivial", "empty"));
    private static final VarargEventId SERVER = GROUP.registerVarargEvent("server", new EventField[]{TYPE, AUTH, RSYNC, SUDO, HIDDEN_FILES, PASSIVE_MODE, COMPATIBILITY_MODE, MAPPINGS_TOGETHER, MAPPINGS_DEPLOY, MAPPINGS_WEB, ROOT_PATH});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        List<WebServerConfig> servers;
        if (project == null) {
            DeploymentServersUsagesCollector.$$$reportNull$$$0(0);
        }
        if ((servers = GroupedServersConfigManager.getInstance(project).getFlattenedServers()).isEmpty()) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                DeploymentServersUsagesCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        HashSet<MetricEvent> result = new HashSet<MetricEvent>();
        for (WebServerConfig server : servers) {
            if (!server.isUsedInProject(project, publishConfig, true)) continue;
            ArrayList<EventPair> data = new ArrayList<EventPair>();
            AccessType type = server.getFileTransferConfig().getAccessType();
            data.add(TYPE.with((Object)type));
            if (type == AccessType.SFTP) {
                data.add(AUTH.with((Object)server.getFileTransferConfig().getAuthType()));
                data.add(RSYNC.with((Object)server.isUseRsync()));
                data.add(SUDO.with((Object)server.isUseSudo()));
            } else if (type == AccessType.FTP || type == AccessType.FTPS) {
                AdvancedOptionsConfig options = server.getFileTransferConfig().getAdvancedOptions();
                data.add(PASSIVE_MODE.with((Object)options.isPassiveMode()));
                data.add(HIDDEN_FILES.with((Object)options.isShowHiddenFiles()));
                if (type == AccessType.FTP) {
                    data.add(COMPATIBILITY_MODE.with((Object)options.isCompatibilityMode()));
                }
            }
            List<DeploymentPathMapping> mappings = publishConfig.getPathMappings(server.getId());
            int deploy = 0;
            int web = 0;
            for (DeploymentPathMapping mapping : mappings) {
                if (StringUtil.isEmpty((String)mapping.getLocalPath())) continue;
                if (!StringUtil.isEmpty((String)mapping.getDeployPath())) {
                    ++deploy;
                }
                if (StringUtil.isEmpty((String)mapping.getWebPath())) continue;
                ++web;
            }
            data.add(MAPPINGS_TOGETHER.with((Object)mappings.size()));
            data.add(MAPPINGS_DEPLOY.with((Object)deploy));
            data.add(MAPPINGS_WEB.with((Object)web));
            String folder = server.getFileTransferConfig().getRootFolder();
            @NonNls String rootPathKey = StringUtil.isEmptyOrSpaces((String)folder) ? "empty" : ("/".equals(folder) ? "trivial" : "nontrivial");
            data.add(ROOT_PATH.with((Object)rootPathKey));
            result.add(SERVER.metric(data));
        }
        HashSet<MetricEvent> hashSet = result;
        if (hashSet == null) {
            DeploymentServersUsagesCollector.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/statistic/DeploymentServersUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/statistic/DeploymentServersUsagesCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

