/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.coverage;

import com.intellij.coverage.CoverageBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.python.pro.coverage.PyCoverageOptionsProvider;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirementsKt;
import java.util.Collections;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public final class PyCoverageNotImportableException
extends ExecutionException
implements HyperlinkListener {
    private static final String INSTALL = "INSTALL";
    private static final String ENABLE = "ENABLE";
    @NotNull
    private final Project myProject;
    private final Sdk mySdk;

    public PyCoverageNotImportableException(@NotNull Project project, Sdk sdk) {
        if (project == null) {
            PyCoverageNotImportableException.$$$reportNull$$$0(0);
        }
        super(CoverageBundle.message((String)"coverage.is.not.importable", (Object[])new Object[]{PyPackageUtil.packageManagementEnabled((Sdk)sdk, (boolean)false, (boolean)false) ? HtmlChunk.link((String)INSTALL, (String)CoverageBundle.message((String)"coverage.is.not.importable.option.install", (Object[])new Object[0])) : CoverageBundle.message((String)"coverage.is.not.importable.option.install", (Object[])new Object[0]), HtmlChunk.link((String)ENABLE, (String)CoverageBundle.message((String)"coverage.is.not.importable.option.enable", (Object[])new Object[0])), PythonProBundle.message((String)"python.coverage.use.bundled")}));
        this.myProject = project;
        this.mySdk = sdk;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (INSTALL.equals(event.getDescription())) {
                PyCoverageNotImportableException.installCoverage(this.myProject, this.mySdk);
            } else if (ENABLE.equals(event.getDescription())) {
                PyCoverageNotImportableException.enableBundled(this.myProject);
            }
        }
    }

    private static void enableBundled(@NotNull Project project) {
        if (project == null) {
            PyCoverageNotImportableException.$$$reportNull$$$0(1);
        }
        PyCoverageOptionsProvider.getInstance(project).setUseBundledCoveragePy(true);
    }

    private static void installCoverage(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            PyCoverageNotImportableException.$$$reportNull$$$0(2);
        }
        if (sdk == null) {
            PyCoverageNotImportableException.$$$reportNull$$$0(3);
        }
        PyPackageManagerUI ui = new PyPackageManagerUI(project, sdk, new PyPackageManagerUI.Listener(){

            public void started() {
            }

            public void finished(List<ExecutionException> exceptions) {
            }
        });
        ui.install(Collections.singletonList(PyRequirementsKt.pyRequirement((String)"coverage")), Collections.emptyList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/pro/coverage/PyCoverageNotImportableException";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "enableBundled";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "installCoverage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

