/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.ide.DataManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.ActiveAnnotationGutter;
import com.intellij.openapi.vcs.actions.AnnotateActionGroup;
import com.intellij.openapi.vcs.actions.AnnotateCurrentRevisionAction;
import com.intellij.openapi.vcs.actions.AnnotateDataKeys;
import com.intellij.openapi.vcs.actions.AnnotatePreviousRevisionAction;
import com.intellij.openapi.vcs.actions.AnnotateWarningsService;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.AnnotationGutterLineConvertorProxy;
import com.intellij.openapi.vcs.actions.AnnotationPresentation;
import com.intellij.openapi.vcs.actions.AnnotationWarningUserData;
import com.intellij.openapi.vcs.actions.AnnotationsSettings;
import com.intellij.openapi.vcs.actions.AspectAnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.CopyRevisionNumberFromAnnotateAction;
import com.intellij.openapi.vcs.actions.CurrentRevisionAnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.ExtraFieldGutter;
import com.intellij.openapi.vcs.actions.FillerColumn;
import com.intellij.openapi.vcs.actions.HighlightedAdditionalColumn;
import com.intellij.openapi.vcs.actions.HistoryIdColumn;
import com.intellij.openapi.vcs.actions.InlineDiffFromAnnotation;
import com.intellij.openapi.vcs.actions.MergeSourceAvailableMarkerGutter;
import com.intellij.openapi.vcs.actions.ShowDiffFromAnnotation;
import com.intellij.openapi.vcs.actions.SwitchAnnotationSourceAction;
import com.intellij.openapi.vcs.annotate.AnnotationGutterActionProvider;
import com.intellij.openapi.vcs.annotate.AnnotationGutterColumnProvider;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.AnnotationWarning;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnnotateToggleAction
extends ToggleAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(AnnotateToggleAction.class);
    public static final ExtensionPointName<Provider> EP_NAME = new ExtensionPointName("com.intellij.openapi.vcs.actions.AnnotateToggleAction.Provider");

    public AnnotateToggleAction() {
        this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.Never);
        this.setEnabledInModalContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AnnotateToggleAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateToggleAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        Provider provider = AnnotateToggleAction.getProvider(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(provider != null);
        if ("ActionPlace.VcsQuickListPopupAction".equals(e.getPlace())) {
            presentation.setVisible(true);
        }
        if (provider != null) {
            presentation.setText(provider.getActionName(e));
        }
    }

    @Nls
    @NotNull
    private static String getVcsActionName(@Nullable Project project) {
        String defaultName = ActionsBundle.message((String)"action.Annotate.text", (Object[])new Object[0]);
        if (project == null) {
            String string = defaultName;
            if (string == null) {
                AnnotateToggleAction.$$$reportNull$$$0(2);
            }
            return string;
        }
        Set names = ContainerUtil.map2Set((Object[])ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss(), vcs -> {
            AnnotationProvider provider = vcs.getAnnotationProvider();
            if (provider != null) {
                String customActionName = provider.getCustomActionName();
                if (customActionName != null) {
                    return customActionName;
                }
                String actionName = provider.getActionName();
                if (!actionName.isEmpty()) {
                    return actionName;
                }
            }
            return defaultName;
        });
        String string = (String)ContainerUtil.getOnlyItem((Collection)names, (Object)defaultName);
        if (string == null) {
            AnnotateToggleAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Provider provider;
        if (e == null) {
            AnnotateToggleAction.$$$reportNull$$$0(4);
        }
        return (provider = AnnotateToggleAction.getProvider(e)) != null && (provider.isAnnotated(e) || provider.isSuspended(e));
    }

    public void setSelected(@NotNull AnActionEvent e, boolean selected) {
        AnnotationWarningUserData warningUserData;
        Editor editor;
        if (e == null) {
            AnnotateToggleAction.$$$reportNull$$$0(5);
        }
        if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) != null && (warningUserData = (AnnotationWarningUserData)editor.getUserData(AnnotateDataKeys.WARNING_DATA)) != null && !warningUserData.getWarning().getShowAnnotation()) {
            warningUserData.getForceAnnotate().run();
            return;
        }
        Provider provider = AnnotateToggleAction.getProvider(e);
        if (provider != null && !provider.isSuspended(e)) {
            provider.perform(e, selected);
        }
    }

    public static void doAnnotate(@NotNull Editor editor, @NotNull Project project, @NotNull FileAnnotation fileAnnotation, @NotNull AbstractVcs vcs) {
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(6);
        }
        if (project == null) {
            AnnotateToggleAction.$$$reportNull$$$0(7);
        }
        if (fileAnnotation == null) {
            AnnotateToggleAction.$$$reportNull$$$0(8);
        }
        if (vcs == null) {
            AnnotateToggleAction.$$$reportNull$$$0(9);
        }
        if (project.isDisposed() || editor.isDisposed()) {
            return;
        }
        UpToDateLineNumberProviderImpl upToDateLineNumberProvider = new UpToDateLineNumberProviderImpl(editor.getDocument(), project);
        AnnotateToggleAction.doAnnotate(editor, project, fileAnnotation, vcs, upToDateLineNumberProvider);
    }

    public static void doAnnotate(@NotNull Editor editor, @NotNull Project project, @NotNull FileAnnotation fileAnnotation, @NotNull AbstractVcs vcs, @NotNull UpToDateLineNumberProvider upToDateLineNumbers) {
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(10);
        }
        if (project == null) {
            AnnotateToggleAction.$$$reportNull$$$0(11);
        }
        if (fileAnnotation == null) {
            AnnotateToggleAction.$$$reportNull$$$0(12);
        }
        if (vcs == null) {
            AnnotateToggleAction.$$$reportNull$$$0(13);
        }
        if (upToDateLineNumbers == null) {
            AnnotateToggleAction.$$$reportNull$$$0(14);
        }
        AnnotateToggleAction.doAnnotate(editor, project, fileAnnotation, vcs, upToDateLineNumbers, (AnnotateWarningsService)project.getService(AnnotateWarningsService.class));
    }

    private static void doAnnotate(@NotNull Editor editor, @NotNull Project project, final @NotNull FileAnnotation fileAnnotation, @NotNull AbstractVcs vcs, @NotNull UpToDateLineNumberProvider upToDateLineNumbers, @Nullable AnnotateWarningsService warningsService) {
        AnnotationWarning warning;
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(15);
        }
        if (project == null) {
            AnnotateToggleAction.$$$reportNull$$$0(16);
        }
        if (fileAnnotation == null) {
            AnnotateToggleAction.$$$reportNull$$$0(17);
        }
        if (vcs == null) {
            AnnotateToggleAction.$$$reportNull$$$0(18);
        }
        if (upToDateLineNumbers == null) {
            AnnotateToggleAction.$$$reportNull$$$0(19);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (project.isDisposed() || editor.isDisposed()) {
            return;
        }
        AnnotationWarning annotationWarning = warning = warningsService != null ? warningsService.getWarning(fileAnnotation, upToDateLineNumbers) : null;
        if (warning == null) {
            AnnotateToggleAction.resetWarningData(editor);
            AnnotateToggleAction.updateEditorNotifications(editor, project);
        } else {
            editor.putUserData(AnnotateDataKeys.WARNING_DATA, (Object)new AnnotationWarningUserData(warning, () -> AnnotateToggleAction.doAnnotate(editor, project, fileAnnotation, vcs, upToDateLineNumbers, null)));
            AnnotateToggleAction.updateEditorNotifications(editor, project);
            if (!warning.getShowAnnotation()) {
                return;
            }
        }
        fileAnnotation.setCloser(() -> UIUtil.invokeLaterIfNeeded(() -> {
            if (project.isDisposed()) {
                return;
            }
            AnnotateToggleAction.closeVcsAnnotations(editor);
        }));
        fileAnnotation.setReloader(newFileAnnotation -> {
            if (project.isDisposed()) {
                return;
            }
            if (AnnotateToggleAction.hasVcsAnnotations(editor)) {
                if (newFileAnnotation != null) {
                    assert (Comparing.equal((Object)fileAnnotation.getFile(), (Object)newFileAnnotation.getFile()));
                    AnnotateToggleAction.doAnnotate(editor, project, newFileAnnotation, vcs, upToDateLineNumbers, null);
                } else {
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
                    AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
                    Provider provider = AnnotateToggleAction.getProvider(event);
                    if (provider != null && provider.isEnabled(event) && !provider.isSuspended(event)) {
                        provider.perform(event, true);
                    } else {
                        AnnotateToggleAction.closeVcsAnnotations(editor);
                    }
                }
            }
        });
        if (fileAnnotation.isClosed()) {
            return;
        }
        Disposable disposable = new Disposable(){

            public void dispose() {
                fileAnnotation.dispose();
            }
        };
        VcsAnnotationLocalChangesListener changesListener = ProjectLevelVcsManager.getInstance((Project)project).getAnnotationLocalChangesListener();
        changesListener.registerAnnotation(fileAnnotation);
        Disposer.register((Disposable)disposable, () -> changesListener.unregisterAnnotation(fileAnnotation));
        Disposer.register((Disposable)disposable, () -> AnnotateToggleAction.resetWarningData(editor));
        AnnotateToggleAction.closeVcsAnnotations(editor);
        ArrayList<Object> gutters = new ArrayList<Object>();
        AnnotationSourceSwitcher switcher = fileAnnotation.getAnnotationSourceSwitcher();
        AnnotationPresentation presentation = new AnnotationPresentation(fileAnnotation, upToDateLineNumbers, switcher, disposable);
        presentation.addAction((AnAction)new ShowDiffFromAnnotation(project, fileAnnotation));
        presentation.addAction((AnAction)new CopyRevisionNumberFromAnnotateAction(fileAnnotation));
        presentation.addAction((AnAction)Separator.getInstance());
        Couple<Map<VcsRevisionNumber, Color>> bgColorMap = AnnotateToggleAction.computeBgColors(fileAnnotation, editor);
        Map<VcsRevisionNumber, Integer> historyIds = AnnotateToggleAction.computeLineNumbers(fileAnnotation);
        gutters.add(new FillerColumn(fileAnnotation, presentation, bgColorMap));
        if (switcher != null) {
            switcher.switchTo(switcher.getDefaultSource());
            LineAnnotationAspect revisionAspect = switcher.getRevisionAspect();
            CurrentRevisionAnnotationFieldGutter currentRevisionGutter = new CurrentRevisionAnnotationFieldGutter(fileAnnotation, revisionAspect, presentation, bgColorMap);
            MergeSourceAvailableMarkerGutter mergeSourceGutter = new MergeSourceAvailableMarkerGutter(fileAnnotation, (TextAnnotationPresentation)presentation, bgColorMap);
            SwitchAnnotationSourceAction switchAction = new SwitchAnnotationSourceAction(switcher);
            presentation.addAction(switchAction);
            switchAction.addSourceSwitchListener(currentRevisionGutter);
            switchAction.addSourceSwitchListener(mergeSourceGutter);
            currentRevisionGutter.accept(switcher.getDefaultSource());
            mergeSourceGutter.accept(switcher.getDefaultSource());
            gutters.add(currentRevisionGutter);
            gutters.add(mergeSourceGutter);
        }
        List<LineAnnotationAspect> aspects = Arrays.asList(fileAnnotation.getAspects());
        List fromExt = ContainerUtil.mapNotNull((Object[])((AnnotationGutterColumnProvider[])AnnotationGutterColumnProvider.EP_NAME.getExtensions()), extension -> extension.createColumn(fileAnnotation));
        for (LineAnnotationAspect aspect : ContainerUtil.concat(aspects, (List)fromExt)) {
            gutters.add(new AspectAnnotationFieldGutter(fileAnnotation, aspect, presentation, bgColorMap));
        }
        if (historyIds != null) {
            gutters.add(new HistoryIdColumn(fileAnnotation, presentation, bgColorMap, historyIds));
        }
        if (!ExperimentalUI.isNewUI()) {
            gutters.add(new HighlightedAdditionalColumn(fileAnnotation, (TextAnnotationPresentation)presentation, bgColorMap));
        }
        AnnotateActionGroup actionGroup = new AnnotateActionGroup(fileAnnotation, gutters, bgColorMap);
        presentation.addAction((AnAction)actionGroup, 1);
        gutters.add(new ExtraFieldGutter(fileAnnotation, presentation, bgColorMap, actionGroup));
        presentation.addAction((AnAction)new AnnotateCurrentRevisionAction(fileAnnotation, vcs));
        presentation.addAction((AnAction)new AnnotatePreviousRevisionAction(fileAnnotation, vcs));
        AnnotateToggleAction.addActionsFromExtensions(presentation, fileAnnotation);
        for (AnnotationFieldGutter annotationFieldGutter : gutters) {
            AnnotationGutterLineConvertorProxy proxy;
            AnnotationGutterLineConvertorProxy annotationGutterLineConvertorProxy = proxy = annotationFieldGutter instanceof TextAnnotationGutterProvider.Filler ? new AnnotationGutterLineConvertorProxy.Filler(upToDateLineNumbers, annotationFieldGutter) : new AnnotationGutterLineConvertorProxy(upToDateLineNumbers, annotationFieldGutter);
            if (annotationFieldGutter.isGutterAction()) {
                editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)proxy, (EditorGutterAction)proxy);
                continue;
            }
            editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)proxy);
        }
        InlineDiffFromAnnotation.showDiffOnHover(editor, fileAnnotation, presentation, disposable);
    }

    private static void updateEditorNotifications(@NotNull Editor editor, @NotNull Project project) {
        VirtualFile file;
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(20);
        }
        if (project == null) {
            AnnotateToggleAction.$$$reportNull$$$0(21);
        }
        if ((file = FileDocumentManager.getInstance().getFile(editor.getDocument())) != null) {
            EditorNotifications.getInstance((Project)project).updateNotifications(file);
        }
    }

    @NotNull
    static List<ActiveAnnotationGutter> getVcsAnnotations(@NotNull Editor editor) {
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(22);
        }
        List annotations = editor.getGutter().getTextAnnotations();
        List list = ContainerUtil.filterIsInstance((Collection)annotations, ActiveAnnotationGutter.class);
        if (list == null) {
            AnnotateToggleAction.$$$reportNull$$$0(23);
        }
        return list;
    }

    static boolean hasVcsAnnotations(@NotNull Editor editor) {
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(24);
        }
        return !AnnotateToggleAction.getVcsAnnotations(editor).isEmpty();
    }

    static void closeVcsAnnotations(@NotNull Editor editor) {
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(25);
        }
        List<ActiveAnnotationGutter> vcsAnnotations = AnnotateToggleAction.getVcsAnnotations(editor);
        editor.getGutter().closeTextAnnotations(vcsAnnotations);
    }

    private static void resetWarningData(@NotNull Editor editor) {
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(26);
        }
        editor.putUserData(AnnotateDataKeys.WARNING_DATA, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    static TextAnnotationPresentation getAnnotationPresentation(@NotNull Editor editor) {
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(27);
        }
        List<ActiveAnnotationGutter> annotations = AnnotateToggleAction.getVcsAnnotations(editor);
        for (TextAnnotationGutterProvider textAnnotationGutterProvider : annotations) {
            void var3_3;
            if (textAnnotationGutterProvider instanceof AnnotationGutterLineConvertorProxy) {
                ActiveAnnotationGutter activeAnnotationGutter = ((AnnotationGutterLineConvertorProxy)textAnnotationGutterProvider).getDelegate();
            }
            if (!(var3_3 instanceof AnnotationFieldGutter)) continue;
            return ((AnnotationFieldGutter)var3_3).getPresentation();
        }
        return null;
    }

    @Nullable
    static FileAnnotation getFileAnnotation(@NotNull Editor editor) {
        TextAnnotationPresentation presentation;
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(28);
        }
        if ((presentation = AnnotateToggleAction.getAnnotationPresentation(editor)) instanceof AnnotationPresentation) {
            return ((AnnotationPresentation)presentation).getFileAnnotation();
        }
        return null;
    }

    private static void addActionsFromExtensions(@NotNull AnnotationPresentation presentation, @NotNull FileAnnotation fileAnnotation) {
        AnnotationGutterActionProvider[] extensions;
        if (presentation == null) {
            AnnotateToggleAction.$$$reportNull$$$0(29);
        }
        if (fileAnnotation == null) {
            AnnotateToggleAction.$$$reportNull$$$0(30);
        }
        if ((extensions = (AnnotationGutterActionProvider[])AnnotationGutterActionProvider.EP_NAME.getExtensions()).length > 0) {
            presentation.addAction((AnAction)new Separator());
        }
        for (AnnotationGutterActionProvider provider : extensions) {
            presentation.addAction(provider.createAction(fileAnnotation));
        }
    }

    @Nullable
    private static Map<VcsRevisionNumber, Integer> computeLineNumbers(@NotNull FileAnnotation fileAnnotation) {
        if (fileAnnotation == null) {
            AnnotateToggleAction.$$$reportNull$$$0(31);
        }
        HashMap<VcsRevisionNumber, Integer> numbers = new HashMap<VcsRevisionNumber, Integer>();
        List fileRevisionList = fileAnnotation.getRevisions();
        if (fileRevisionList != null) {
            int size = fileRevisionList.size();
            for (int i = 0; i < size; ++i) {
                VcsFileRevision revision = (VcsFileRevision)fileRevisionList.get(i);
                VcsRevisionNumber number = revision.getRevisionNumber();
                numbers.put(number, size - i);
            }
        }
        return numbers.size() < 2 ? null : numbers;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static Couple<Map<VcsRevisionNumber, Color>> computeBgColors(@NotNull FileAnnotation fileAnnotation, @NotNull Editor editor) {
        FileAnnotation.RevisionsOrderProvider revisionsOrderProvider;
        if (fileAnnotation == null) {
            AnnotateToggleAction.$$$reportNull$$$0(32);
        }
        if (editor == null) {
            AnnotateToggleAction.$$$reportNull$$$0(33);
        }
        HashMap<VcsRevisionNumber, Color> commitOrderColors = new HashMap<VcsRevisionNumber, Color>();
        HashMap<VcsRevisionNumber, Color> commitAuthorColors = new HashMap<VcsRevisionNumber, Color>();
        EditorColorsScheme colorScheme = editor.getColorsScheme();
        AnnotationsSettings settings = AnnotationsSettings.getInstance();
        List<Color> authorsColorPalette = settings.getAuthorsColors(colorScheme);
        List<Color> orderedColorPalette = settings.getOrderedColors(colorScheme);
        FileAnnotation.AuthorsMappingProvider authorsMappingProvider = fileAnnotation.getAuthorsMappingProvider();
        if (authorsMappingProvider != null) {
            Map authorsMap = authorsMappingProvider.getAuthors();
            HashMap<String, Color> authorColors = new HashMap<String, Color>();
            for (String string : ContainerUtil.sorted(new HashSet(authorsMap.values()))) {
                int index = authorColors.size();
                Color color = authorsColorPalette.get(index % authorsColorPalette.size());
                authorColors.put(string, color);
            }
            for (Map.Entry entry : authorsMap.entrySet()) {
                VcsRevisionNumber revision = (VcsRevisionNumber)entry.getKey();
                String author = (String)entry.getValue();
                Color color = (Color)authorColors.get(author);
                commitAuthorColors.put(revision, color);
            }
        }
        if ((revisionsOrderProvider = fileAnnotation.getRevisionsOrderProvider()) != null) {
            void var12_17;
            List orderedRevisions = revisionsOrderProvider.getOrderedRevisions();
            int revisionsCount = orderedRevisions.size();
            boolean bl = false;
            while (var12_17 < revisionsCount) {
                Color color = orderedColorPalette.get(orderedColorPalette.size() * var12_17 / revisionsCount);
                for (VcsRevisionNumber number : (List)orderedRevisions.get((int)var12_17)) {
                    commitOrderColors.put(number, color);
                }
                ++var12_17;
            }
        }
        Couple couple = Couple.of(commitOrderColors.size() > 1 ? commitOrderColors : null, commitAuthorColors.size() > 1 ? commitAuthorColors : null);
        if (couple == null) {
            AnnotateToggleAction.$$$reportNull$$$0(34);
        }
        return couple;
    }

    @Nullable
    private static Provider getProvider(AnActionEvent e) {
        return (Provider)EP_NAME.findFirstSafe(provider -> provider.isEnabled(e));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/AnnotateToggleAction";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 11: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 12: 
            case 17: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAnnotation";
                break;
            }
            case 9: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upToDateLineNumbers";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateToggleAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsActionName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsAnnotations";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "computeBgColors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doAnnotate";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateEditorNotifications";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getVcsAnnotations";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasVcsAnnotations";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "closeVcsAnnotations";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resetWarningData";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationPresentation";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFileAnnotation";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addActionsFromExtensions";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "computeLineNumbers";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "computeBgColors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33 -> new IllegalArgumentException(string);
        };
    }

    public static interface Provider {
        public boolean isEnabled(AnActionEvent var1);

        public boolean isSuspended(@NotNull AnActionEvent var1);

        public boolean isAnnotated(AnActionEvent var1);

        @RequiresEdt
        public void perform(@NotNull AnActionEvent var1, boolean var2);

        @Nls(capitalization=Nls.Capitalization.Title)
        default public String getActionName(@NotNull AnActionEvent e) {
            if (e == null) {
                Provider.$$$reportNull$$$0(0);
            }
            return AnnotateToggleAction.getVcsActionName(e.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateToggleAction$Provider", "getActionName"));
        }
    }
}

