/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.panel;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.run.ui.table.statisticsPanel.StatisticsPanelMode;
import com.intellij.database.run.ui.table.statisticsPanel.StatisticsTableHeader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.CoroutinesKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.scientific.tables.DSGridLoader;
import com.intellij.scientific.tables.DSTableDataRetrieverFromDataSourceImpl;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.StatisticsTableHeaderProvider;
import com.intellij.scientific.tables.api.TableStatisticsData;
import com.intellij.scientific.tables.panel.DSTableImpl;
import com.intellij.scientific.tables.settings.DSTablesSettingsChangeListener;
import com.intellij.scientific.tables.settings.DSTablesSettingsState;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\b\u0010 \u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\"\u001a\u0004\u0018\u00010#R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;", "Lcom/intellij/scientific/tables/panel/DSTableImpl;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "loader", "Lcom/intellij/scientific/tables/DSGridLoader;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/scientific/tables/DSGridLoader;)V", "underlyingTable", "Lcom/intellij/database/run/ui/table/TableResultView;", "statisticsHeader", "Lcom/intellij/database/run/ui/table/statisticsPanel/StatisticsTableHeader;", "getStatisticsHeader", "()Lcom/intellij/database/run/ui/table/statisticsPanel/StatisticsTableHeader;", "setStatisticsHeader", "(Lcom/intellij/database/run/ui/table/statisticsPanel/StatisticsTableHeader;)V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "fetchData", "Lcom/intellij/openapi/util/ActionCallback;", "tableDataRetriever", "Lcom/intellij/scientific/tables/api/DSTableDataRetrieverFromDataSource;", "isUpdate", "", "removeOldStatisticsHeader", "", "addStatisticsHeaderIfApplicable", "callback", "addStatisticsHeaderAndSetMode", "initDSTablesSettingsListener", "setStatisticsPanelModeFromSettings", "isTableWithMultiIndex", "getDSTableCommandExecutor", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "intellij.scientific.tables"})
public final class DSTableWithStatistics
extends DSTableImpl {
    @NotNull
    private final TableResultView underlyingTable;
    @Nullable
    private StatisticsTableHeader statisticsHeader;
    @NotNull
    private final CoroutineScope scope;

    /*
     * WARNING - void declaration
     */
    public DSTableWithStatistics(@NotNull DataGrid grid2, @NotNull DSGridLoader loader) {
        void it;
        CoroutineScope coroutineScope;
        Intrinsics.checkNotNullParameter((Object)grid2, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)((Object)loader), (String)"loader");
        super(grid2, loader);
        ResultView resultView = grid2.getResultView();
        Intrinsics.checkNotNull((Object)resultView, (String)"null cannot be cast to non-null type com.intellij.database.run.ui.table.TableResultView");
        this.underlyingTable = (TableResultView)resultView;
        CoroutineScope coroutineScope2 = coroutineScope = CoroutineScopeKt.MainScope();
        DSTableWithStatistics dSTableWithStatistics = this;
        boolean bl = false;
        Disposer.register((Disposable)this.getDisposable(), () -> DSTableWithStatistics.scope$lambda$1$lambda$0((CoroutineScope)it));
        dSTableWithStatistics.scope = coroutineScope;
    }

    @Nullable
    public final StatisticsTableHeader getStatisticsHeader() {
        return this.statisticsHeader;
    }

    public final void setStatisticsHeader(@Nullable StatisticsTableHeader statisticsTableHeader) {
        this.statisticsHeader = statisticsTableHeader;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public ActionCallback fetchData(@NotNull DSTableDataRetrieverFromDataSource tableDataRetriever, boolean isUpdate) {
        Intrinsics.checkNotNullParameter((Object)tableDataRetriever, (String)"tableDataRetriever");
        if (isUpdate) {
            this.removeOldStatisticsHeader();
        }
        ActionCallback callback = super.fetchData(tableDataRetriever, isUpdate);
        this.addStatisticsHeaderIfApplicable(tableDataRetriever, callback, isUpdate);
        return callback;
    }

    private final void removeOldStatisticsHeader() {
        StatisticsTableHeader statisticsTableHeader = this.underlyingTable.getStatisticsHeader();
        if (statisticsTableHeader != null) {
            statisticsTableHeader.disposeOldTable((JTable)this.underlyingTable, null);
        }
        this.underlyingTable.setStatisticsHeader(null);
    }

    private final void addStatisticsHeaderIfApplicable(DSTableDataRetrieverFromDataSource tableDataRetriever, ActionCallback callback, boolean isUpdate) {
        DSTableDataType tableType = tableDataRetriever.getTableType();
        TableStatisticsData dataDescription = tableDataRetriever.getDataFrameInfo().getDataStatistics();
        this.initDSTablesSettingsListener();
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(callback, tableDataRetriever, dataDescription, this, tableType, isUpdate, null){
            int label;
            final /* synthetic */ ActionCallback $callback;
            final /* synthetic */ DSTableDataRetrieverFromDataSource $tableDataRetriever;
            final /* synthetic */ TableStatisticsData $dataDescription;
            final /* synthetic */ DSTableWithStatistics this$0;
            final /* synthetic */ DSTableDataType $tableType;
            final /* synthetic */ boolean $isUpdate;
            {
                this.$callback = $callback;
                this.$tableDataRetriever = $tableDataRetriever;
                this.$dataDescription = $dataDescription;
                this.this$0 = $receiver;
                this.$tableType = $tableType;
                this.$isUpdate = $isUpdate;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = CoroutinesKt.await((ActionCallback)this.$callback, (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (this.$callback.getError() == null && this.$tableDataRetriever.isDynamicTable() && this.$tableDataRetriever.getNColumns() <= 200 && this.$tableDataRetriever.getNRows() <= 80000000 && this.$dataDescription != null && !DSTableWithStatistics.access$isTableWithMultiIndex(this.this$0, this.$tableDataRetriever) && CollectionsKt.contains((Iterable)DSTableDataType.Companion.isDescribeSupported(), (Object)this.$tableType)) {
                            v1 = Dispatchers.getMain();
                            v2 = ModalityState.any();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"any(...)");
                            this.label = 2;
                            v3 = BuildersKt.withContext((CoroutineContext)v1.plus(ModalityKt.asContextElement((ModalityState)v2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$tableDataRetriever, this.$isUpdate, null){
                                int label;
                                final /* synthetic */ DSTableWithStatistics this$0;
                                final /* synthetic */ DSTableDataRetrieverFromDataSource $tableDataRetriever;
                                final /* synthetic */ boolean $isUpdate;
                                {
                                    this.this$0 = $receiver;
                                    this.$tableDataRetriever = $tableDataRetriever;
                                    this.$isUpdate = $isUpdate;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            DSTableWithStatistics.access$addStatisticsHeaderAndSetMode(this.this$0, this.$tableDataRetriever, this.$isUpdate);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v3 == var2_2) {
                                return var2_2;
                            }
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl25:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void addStatisticsHeaderAndSetMode(DSTableDataRetrieverFromDataSource tableDataRetriever, boolean isUpdate) {
        StatisticsTableHeader statisticsTableHeader = this.statisticsHeader;
        StatisticsPanelMode previousMode = statisticsTableHeader != null ? statisticsTableHeader.getStatisticsPanelMode() : null;
        this.statisticsHeader = StatisticsTableHeaderProvider.Companion.createStatisticsTableHeader(this.underlyingTable, tableDataRetriever);
        this.underlyingTable.setStatisticsHeader(this.statisticsHeader);
        if (isUpdate && previousMode != null) {
            this.underlyingTable.setStatisticsPanelMode(previousMode);
        } else {
            this.setStatisticsPanelModeFromSettings();
        }
    }

    static /* synthetic */ void addStatisticsHeaderAndSetMode$default(DSTableWithStatistics dSTableWithStatistics, DSTableDataRetrieverFromDataSource dSTableDataRetrieverFromDataSource, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        dSTableWithStatistics.addStatisticsHeaderAndSetMode(dSTableDataRetrieverFromDataSource, bl);
    }

    private final void initDSTablesSettingsListener() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.underlyingTable).subscribe(DSTablesSettingsChangeListener.Companion.getDS_TABLES_SETTINGS_TOPIC(), () -> DSTableWithStatistics.initDSTablesSettingsListener$lambda$2(this));
    }

    private final void setStatisticsPanelModeFromSettings() {
        this.underlyingTable.setStatisticsPanelMode(DSTablesSettingsState.Companion.getInstance().getStatisticsPanelsDefaultMode());
    }

    private final boolean isTableWithMultiIndex(DSTableDataRetrieverFromDataSource tableDataRetriever) {
        return tableDataRetriever.getIndexColumnWidth() > 1;
    }

    @Nullable
    public final DSTableCommandExecutor getDSTableCommandExecutor() {
        DSTableDataRetrieverFromDataSource dSTableDataRetrieverFromDataSource = this.getTableDataRetrieverFromDataSource();
        DSTableDataRetrieverFromDataSourceImpl dSTableDataRetrieverFromDataSourceImpl = dSTableDataRetrieverFromDataSource instanceof DSTableDataRetrieverFromDataSourceImpl ? (DSTableDataRetrieverFromDataSourceImpl)dSTableDataRetrieverFromDataSource : null;
        return dSTableDataRetrieverFromDataSourceImpl != null ? dSTableDataRetrieverFromDataSourceImpl.getTableCommandExecutor() : null;
    }

    private static final void scope$lambda$1$lambda$0(CoroutineScope $it) {
        CoroutineScopeKt.cancel$default((CoroutineScope)$it, null, (int)1, null);
    }

    private static final void initDSTablesSettingsListener$lambda$2(DSTableWithStatistics this$0) {
        this$0.setStatisticsPanelModeFromSettings();
    }

    public static final /* synthetic */ boolean access$isTableWithMultiIndex(DSTableWithStatistics $this, DSTableDataRetrieverFromDataSource tableDataRetriever) {
        return $this.isTableWithMultiIndex(tableDataRetriever);
    }

    public static final /* synthetic */ void access$addStatisticsHeaderAndSetMode(DSTableWithStatistics $this, DSTableDataRetrieverFromDataSource tableDataRetriever, boolean isUpdate) {
        $this.addStatisticsHeaderAndSetMode(tableDataRetriever, isUpdate);
    }
}

