/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.ec4j.core.ResourceProperties;
import org.ec4j.core.model.Property;
import org.editorconfig.EditorConfigNotifier;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.configmanagement.ConfigEncodingCharsetUtil;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.plugincomponents.EditorConfigPropertiesService;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0013\u001a\u00020\u0005*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u0012\u0010\u0016\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\rJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\rH\u0007J*\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\u00052\b\u0010\"\u001a\u0004\u0018\u00010\u0005J\u0018\u0010#\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u000e\u0010'\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010(\u001a\u00020\u0005H\u0002J\b\u0010)\u001a\u00020\u0005H\u0002J\r\u0010*\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0018H\u0002J\u0010\u0010.\u001a\u0004\u0018\u00010\u00052\u0006\u0010/\u001a\u00020\u0005J\u0010\u00100\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u00101\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u000204J\u0018\u00105\u001a\u00020\r2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207H\u0002J,\u00109\u001a\u00020\u001d2\n\u0010:\u001a\u00060;j\u0002`<2\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u0002072\u0006\u0010?\u001a\u00020\u0005H\u0002J\u000e\u0010@\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010A\u001a\u00020\r2\u0006\u0010B\u001a\u00020CH\u0002J\u001a\u0010D\u001a\b\u0012\u0004\u0012\u00020%0E2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00050EJ\u000e\u0010G\u001a\u00020\r2\u0006\u0010H\u001a\u00020%J\u000e\u0010I\u001a\u00020\r2\u0006\u0010H\u001a\u00020%J\u0016\u0010J\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006K"}, d2={"Lorg/editorconfig/Utils;", "", "<init>", "()V", "EDITOR_CONFIG_NAME", "", "EDITOR_CONFIG_FILE_NAME", "FULL_SETTINGS_SUPPORT_REG_KEY", "PLUGIN_ID", "UNSET_VALUES", "", "[Ljava/lang/String;", "ourIsFullSettingsSupportEnabledInTest", "", "isEnabledInTests", "isEnabledInTests$annotations", "()Z", "setEnabledInTests", "(Z)V", "configValueForKey", "Lorg/ec4j/core/ResourceProperties;", "key", "isEnabled", "currentSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "project", "Lcom/intellij/openapi/project/Project;", "isFullIntellijSettingsSupport", "setFullIntellijSettingsSupportEnabledInTest", "", "enabled", "invalidConfigMessage", "configValue", "configKey", "filePath", "getFilePath", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "exportToString", "export", "getEndOfFileLine", "getTrailingSpacesLine", "getTrimTrailingSpaces", "()Ljava/lang/Boolean;", "getLineEndings", "settings", "getLineSeparatorString", "separator", "getEncodingLine", "getEncoding", "buildPattern", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "equalIndents", "a", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "b", "addIndentOptions", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "pattern", "options", "additionalText", "editorConfigExists", "containsEditorConfig", "dir", "Ljava/io/File;", "pathsToFiles", "", "paths", "isApplicableTo", "virtualFile", "isEditorConfigFile", "isEnabledFor", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/editorconfig/Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n1#2:242\n1#2:258\n1317#3,2:243\n1251#3,2:246\n25#4:245\n25#4:261\n1611#5,9:248\n1863#5:257\n1864#5:259\n1620#5:260\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/editorconfig/Utils\n*L\n228#1:258\n111#1:243,2\n221#1:246,2\n122#1:245\n136#1:261\n228#1:248,9\n228#1:257\n228#1:259\n228#1:260\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @NotNull
    public static final String EDITOR_CONFIG_NAME = "EditorConfig";
    @NotNull
    public static final String EDITOR_CONFIG_FILE_NAME = ".editorconfig";
    @NotNull
    private static final String FULL_SETTINGS_SUPPORT_REG_KEY = "editor.config.full.settings.support";
    @NotNull
    public static final String PLUGIN_ID = "org.editorconfig.editorconfigjetbrains";
    @NotNull
    private static final String[] UNSET_VALUES;
    private static boolean ourIsFullSettingsSupportEnabledInTest;
    @TestOnly
    private static boolean isEnabledInTests;

    private Utils() {
    }

    public static final boolean isEnabledInTests() {
        return isEnabledInTests;
    }

    public static final void setEnabledInTests(boolean bl) {
        isEnabledInTests = bl;
    }

    @JvmStatic
    public static /* synthetic */ void isEnabledInTests$annotations() {
    }

    @NotNull
    public final String configValueForKey(@NotNull ResourceProperties $this$configValueForKey, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$configValueForKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Property property = $this$configValueForKey.getProperties().get(key);
        if (property == null) {
            return "";
        }
        Property prop = property;
        String string = prop.getSourceValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSourceValue(...)");
        String value = ((Object)StringsKt.trim((CharSequence)string)).toString();
        return ArraysKt.contains((Object[])UNSET_VALUES, (Object)value) ? "" : value;
    }

    @JvmStatic
    public static final boolean isEnabled(@Nullable CodeStyleSettings currentSettings) {
        EditorConfigSettings editorConfigSettings;
        return currentSettings != null && (editorConfigSettings = (EditorConfigSettings)currentSettings.getCustomSettingsIfCreated(EditorConfigSettings.class)) != null ? editorConfigSettings.ENABLED : false;
    }

    public final boolean isEnabled(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return Utils.isEnabled(CodeStyle.getSettings((Project)project));
    }

    public final boolean isFullIntellijSettingsSupport() {
        return ourIsFullSettingsSupportEnabledInTest || Registry.Companion.is(FULL_SETTINGS_SUPPORT_REG_KEY);
    }

    @JvmStatic
    @TestOnly
    public static final void setFullIntellijSettingsSupportEnabledInTest(boolean enabled) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ourIsFullSettingsSupportEnabledInTest = enabled;
        }
    }

    public final void invalidConfigMessage(@NotNull Project project, @Nullable String configValue, @NotNull String configKey, @Nullable String filePath) {
        String string;
        String message;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
        if (configValue != null) {
            CharSequence charSequence;
            DynamicBundle dynamicBundle = EditorConfigBundle.INSTANCE.getBundle$intellij_editorconfig();
            String string2 = "invalid.config.value";
            String string3 = null;
            Object[] objectArray = new Object[3];
            objectArray[0] = configValue;
            Object[] objectArray2 = objectArray;
            int n = 1;
            CharSequence charSequence2 = configKey;
            if (charSequence2.length() == 0) {
                int n2 = n;
                Object[] objectArray3 = objectArray2;
                String string4 = string3;
                String string5 = string2;
                DynamicBundle dynamicBundle2 = dynamicBundle;
                boolean bl = false;
                String string6 = "?";
                dynamicBundle = dynamicBundle2;
                string2 = string5;
                string3 = string4;
                objectArray2 = objectArray3;
                n = n2;
                charSequence = string6;
            } else {
                charSequence = charSequence2;
            }
            objectArray2[n] = charSequence;
            objectArray[2] = filePath;
            v6 = dynamicBundle.messageOrDefault(string2, string3, objectArray);
        } else {
            v6 = message = EditorConfigBundle.message("read.failure");
        }
        if ((string = configValue) == null) {
            string = "ioError";
        }
        EditorConfigNotifier.error(project, string, message);
    }

    @Nullable
    public final String getFilePath(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !file.isInLocalFileSystem() ? project.getBasePath() + "/" + file.getNameWithoutExtension() + "." + file.getFileType().getDefaultExtension() : file.getCanonicalPath();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String exportToString(@NotNull Project project) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getSettings(...)");
        CodeStyleSettings settings = codeStyleSettings;
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions();
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptions(...)");
        CommonCodeStyleSettings.IndentOptions commonIndentOptions = indentOptions;
        StringBuilder result2 = new StringBuilder();
        INSTANCE.addIndentOptions(result2, "*", commonIndentOptions, INSTANCE.getEncodingLine(project) + INSTANCE.getLineEndings(settings) + INSTANCE.getTrailingSpacesLine() + INSTANCE.getEndOfFileLine());
        FileType[] fileTypeArray = FileTypeManager.getInstance().getRegisteredFileTypes();
        Intrinsics.checkNotNullExpressionValue((Object)fileTypeArray, (String)"getRegisteredFileTypes(...)");
        Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])fileTypeArray), arg_0 -> Utils.exportToString$lambda$1(project, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommonCodeStyleSettings.IndentOptions options;
            FileType fileType = (FileType)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)settings.getIndentOptions(fileType), (String)"getIndentOptions(...)");
            if (INSTANCE.equalIndents(commonIndentOptions, options)) continue;
            Intrinsics.checkNotNull((Object)fileType);
            INSTANCE.addIndentOptions(result2, INSTANCE.buildPattern(fileType), options, "");
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void export(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = project.getBaseDir();
        if (virtualFile == null) {
            Utils $this$export_u24lambda_u243 = this;
            boolean bl = false;
            Utils $this$thisLogger$iv = $this$export_u24lambda_u243;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Utils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Cannot export .editorconfig from the default project");
            return;
        }
        VirtualFile baseDir = virtualFile;
        VirtualFile virtualFile2 = baseDir.findChild(EDITOR_CONFIG_FILE_NAME);
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            String string = baseDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String message = EditorConfigBundle.message("dialog.message.editorconfig.already.present.in.overwrite", string);
            String title = EditorConfigBundle.message("dialog.title.editorconfig.exists");
            if (Messages.showYesNoDialog((Project)project, (String)message, (String)title, null) == 1) {
                return;
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> Utils.export$lambda$5(baseDir, project));
    }

    private final String getEndOfFileLine() {
        return "insert_final_newline=" + EditorSettingsExternalizable.getInstance().isEnsureNewLineAtEOF() + "\n";
    }

    private final String getTrailingSpacesLine() {
        Object object;
        block3: {
            block2: {
                object = this.getTrimTrailingSpaces();
                if (object == null) break block2;
                boolean it = (Boolean)object;
                boolean bl = false;
                String string = "trim_trailing_whitespace=" + it + "\n";
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @Nullable
    public final Boolean getTrimTrailingSpaces() {
        String string = EditorSettingsExternalizable.getInstance().getStripTrailingSpaces();
        return Intrinsics.areEqual((Object)string, (Object)"None") ? Boolean.valueOf(false) : (Intrinsics.areEqual((Object)string, (Object)"Whole") ? Boolean.valueOf(true) : null);
    }

    private final String getLineEndings(CodeStyleSettings settings) {
        Object object;
        block3: {
            block2: {
                String separator = settings.getLineSeparator();
                Intrinsics.checkNotNull((Object)separator);
                object = this.getLineSeparatorString(separator);
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "end_of_line=" + it + "\n";
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @Nullable
    public final String getLineSeparatorString(@NotNull String separator) {
        String string;
        LineSeparator lineSeparator;
        block3: {
            LineSeparator lineSeparator2;
            Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
            LineSeparator[] lineSeparatorArray = LineSeparator.values();
            int n = lineSeparatorArray.length;
            for (int i = 0; i < n; ++i) {
                LineSeparator lineSeparator3;
                LineSeparator it = lineSeparator3 = lineSeparatorArray[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)separator, (Object)it.getSeparatorString())) continue;
                lineSeparator2 = lineSeparator3;
                break block3;
            }
            lineSeparator2 = lineSeparator = null;
        }
        if (lineSeparator != null) {
            LineSeparator it = lineSeparator;
            boolean bl = false;
            string = StringUtil.toLowerCase((String)it.name());
        } else {
            string = null;
        }
        return string;
    }

    private final String getEncodingLine(Project project) {
        Object object;
        block3: {
            block2: {
                object = this.getEncoding(project);
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "charset=" + it + "\n";
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @Nullable
    public final String getEncoding(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)project);
        Charset charset = encodingManager.getDefaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getDefaultCharset(...)");
        return ConfigEncodingCharsetUtil.INSTANCE.toString(charset, encodingManager.shouldAddBOMForNewUtf8File());
    }

    @NotNull
    public final String buildPattern(@NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        List list = FileTypeManager.getInstance().getAssociations(fileType);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAssociations(...)");
        List associations = list;
        String result2 = SequencesKt.joinToString$default((Sequence)SequencesKt.sorted((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)associations), Utils::buildPattern$lambda$11)), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        return associations.size() > 1 ? "{" + result2 + "}" : result2;
    }

    private final boolean equalIndents(CommonCodeStyleSettings.IndentOptions a, CommonCodeStyleSettings.IndentOptions b) {
        return b.USE_TAB_CHARACTER == a.USE_TAB_CHARACTER && b.TAB_SIZE == a.TAB_SIZE && b.INDENT_SIZE == a.INDENT_SIZE;
    }

    private final void addIndentOptions(StringBuilder result2, String pattern, CommonCodeStyleSettings.IndentOptions options, String additionalText) {
        StringBuilder stringBuilder;
        if (((CharSequence)pattern).length() == 0) {
            return;
        }
        StringBuilder $this$addIndentOptions_u24lambda_u2412 = stringBuilder = result2;
        boolean bl = false;
        $this$addIndentOptions_u24lambda_u2412.append("[").append(pattern).append("]").append("\n");
        $this$addIndentOptions_u24lambda_u2412.append(additionalText);
        $this$addIndentOptions_u24lambda_u2412.append("indent_style").append("=");
        if (options.USE_TAB_CHARACTER) {
            $this$addIndentOptions_u24lambda_u2412.append("tab\n");
            v0 = $this$addIndentOptions_u24lambda_u2412.append("tab_width").append("=").append(options.TAB_SIZE).append("\n");
        } else {
            $this$addIndentOptions_u24lambda_u2412.append("space\n");
            v0 = $this$addIndentOptions_u24lambda_u2412.append("indent_size").append("=").append(options.INDENT_SIZE).append("\n");
        }
        $this$addIndentOptions_u24lambda_u2412.append("\n");
    }

    public final boolean editorConfigExists(@NotNull Project project) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = project.getBasePath();
            if (string == null) {
                return false;
            }
            File projectDir = new File(string);
            Sequence $this$any$iv = SequencesKt.flatMap((Sequence)SequencesKt.ifEmpty((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)EditorConfigPropertiesService.Companion.getInstance(project).getRootDirs()), Utils::editorConfigExists$lambda$13), () -> Utils.editorConfigExists$lambda$14(projectDir)), arg_0 -> Utils.editorConfigExists$lambda$16(projectDir, arg_0));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                File dir = (File)element$iv;
                boolean bl2 = false;
                if (!INSTANCE.containsEditorConfig(dir)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean containsEditorConfig(File dir) {
        return dir.exists() && dir.isDirectory() && FileUtil.exists((String)(dir.getPath() + File.separator + EDITOR_CONFIG_FILE_NAME));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualFile> pathsToFiles(@NotNull List<String> paths) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Iterable $this$mapNotNull$iv = paths;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (VfsUtil.findFile((Path)Paths.get(it, new String[0]), (boolean)true) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isApplicableTo(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        VirtualFile $this$isApplicableTo_u24lambda_u2419 = virtualFile;
        boolean bl = false;
        return $this$isApplicableTo_u24lambda_u2419.isInLocalFileSystem() && $this$isApplicableTo_u24lambda_u2419.isValid();
    }

    public final boolean isEditorConfigFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return StringsKt.equals((String)EDITOR_CONFIG_FILE_NAME, (String)virtualFile.getName(), (boolean)true);
    }

    public final boolean isEnabledFor(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return Utils.isEnabled(CodeStyle.getSettings((Project)project)) && this.isApplicableTo(virtualFile) && !this.isEditorConfigFile(virtualFile) && (!ApplicationManager.getApplication().isUnitTestMode() || isEnabledInTests);
    }

    private static final boolean exportToString$lambda$1(Project $project, FileType it) {
        return FileTypeIndex.containsFileOfType((FileType)it, (GlobalSearchScope)GlobalSearchScope.allScope((Project)$project));
    }

    private static final void export$lambda$5(VirtualFile $baseDir, Project $project) {
        try {
            VirtualFile virtualFile = $baseDir.findOrCreateChildData(Utils.class, EDITOR_CONFIG_FILE_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"findOrCreateChildData(...)");
            VirtualFile editorConfig = virtualFile;
            VfsUtil.saveText((VirtualFile)editorConfig, (String)Utils.exportToString($project));
        }
        catch (IOException e) {
            Utils $this$thisLogger$iv = INSTANCE;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Utils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
        }
    }

    private static final String buildPattern$lambda$11(FileNameMatcher it) {
        return it.getPresentableString();
    }

    private static final File editorConfigExists$lambda$13(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new File(it.getPath());
    }

    private static final Sequence editorConfigExists$lambda$14(File $projectDir) {
        Object[] objectArray = new File[]{$projectDir};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    private static final File editorConfigExists$lambda$16$lambda$15(File $projectDir, File currRoot) {
        Intrinsics.checkNotNullParameter((Object)currRoot, (String)"currRoot");
        return EditorConfigRegistry.shouldStopAtProjectRoot() && FileUtil.filesEqual((File)currRoot, (File)$projectDir) ? null : currRoot.getParentFile();
    }

    private static final Sequence editorConfigExists$lambda$16(File $projectDir, File rootDir) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        return SequencesKt.generateSequence((Object)rootDir, arg_0 -> Utils.editorConfigExists$lambda$16$lambda$15($projectDir, arg_0));
    }

    static {
        String[] stringArray = new String[]{"none", "unset"};
        UNSET_VALUES = stringArray;
    }
}

