/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.FingerprintUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class KeyIdentifier {
    private final byte[] fingerprint;
    private final long keyId;

    public KeyIdentifier(String string) {
        this(Hex.decode(string));
    }

    public KeyIdentifier(byte[] byArray) {
        this.fingerprint = Arrays.clone(byArray);
        this.keyId = byArray.length == 20 ? FingerprintUtil.keyIdFromV4Fingerprint(byArray) : (byArray.length == 32 ? FingerprintUtil.keyIdFromV6Fingerprint(byArray) : 0L);
    }

    public KeyIdentifier(byte[] byArray, long l) {
        this.fingerprint = Arrays.clone(byArray);
        this.keyId = l;
    }

    public KeyIdentifier(long l) {
        this(null, l);
    }

    private KeyIdentifier() {
        this(new byte[0], 0L);
    }

    public static KeyIdentifier wildcard() {
        return new KeyIdentifier();
    }

    public byte[] getFingerprint() {
        return Arrays.clone(this.fingerprint);
    }

    public long getKeyId() {
        return this.keyId;
    }

    public boolean isWildcard() {
        return this.keyId == 0L && this.fingerprint.length == 0;
    }

    public boolean hasFingerprint(byte[] byArray) {
        return Arrays.constantTimeAreEqual(this.fingerprint, byArray);
    }

    public boolean matches(KeyIdentifier keyIdentifier) {
        if (this.isWildcard() || keyIdentifier.isWildcard()) {
            return true;
        }
        if (this.fingerprint != null && keyIdentifier.fingerprint != null) {
            return Arrays.constantTimeAreEqual(this.fingerprint, keyIdentifier.fingerprint);
        }
        return this.keyId == keyIdentifier.keyId;
    }

    public static boolean matches(List<KeyIdentifier> list, KeyIdentifier keyIdentifier, boolean bl) {
        Iterator<KeyIdentifier> iterator = list.iterator();
        if (iterator.hasNext()) {
            KeyIdentifier keyIdentifier2 = iterator.next();
            if (!bl && keyIdentifier2.isWildcard()) {
                return true;
            }
            if (keyIdentifier2.getFingerprint() != null && Arrays.constantTimeAreEqual(keyIdentifier2.getFingerprint(), keyIdentifier.getFingerprint())) {
                return true;
            }
            return keyIdentifier2.getKeyId() == keyIdentifier.getKeyId();
        }
        return false;
    }

    public boolean isPresentIn(List<KeyIdentifier> list) {
        Iterator<KeyIdentifier> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!this.matches(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof KeyIdentifier)) {
            return false;
        }
        KeyIdentifier keyIdentifier = (KeyIdentifier)object;
        if (this.getFingerprint() != null && keyIdentifier.getFingerprint() != null) {
            return Arrays.constantTimeAreEqual(this.getFingerprint(), keyIdentifier.getFingerprint());
        }
        return this.getKeyId() == keyIdentifier.getKeyId();
    }

    public int hashCode() {
        return (int)this.getKeyId();
    }

    public String toString() {
        if (this.isWildcard()) {
            return "*";
        }
        if (this.fingerprint == null) {
            return "" + this.keyId;
        }
        return Hex.toHexString(this.fingerprint).toUpperCase();
    }
}

