/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.temporal.CreateTimeZoneMethodsRecordNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalTimeNode
extends JavaScriptBaseNode {
    protected ToTemporalTimeNode() {
    }

    public abstract JSTemporalPlainTimeObject execute(Object var1, TemporalUtil.Overflow var2);

    @Specialization
    protected JSTemporalPlainTimeObject toTemporalTime(Object item, TemporalUtil.Overflow overflowParam, @Cached IsObjectNode isObjectNode, @Cached JSToStringNode toStringNode, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isPlainDateTimeProfile, @Cached InlinedConditionProfile isZonedDateTimeProfile, @Cached InlinedConditionProfile isPlainTimeProfile, @Cached InlinedBranchProfile errorBranch, @Cached GetTemporalCalendarWithISODefaultNode getTemporalCalendarNode, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
        TemporalUtil.Overflow overflow;
        TemporalUtil.Overflow overflow2 = overflow = overflowParam == null ? TemporalUtil.Overflow.CONSTRAIN : overflowParam;
        assert (overflow == TemporalUtil.Overflow.CONSTRAIN || overflow == TemporalUtil.Overflow.REJECT);
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        JSTemporalDurationRecord result2 = null;
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(item))) {
            JSDynamicObject itemObj = (JSDynamicObject)item;
            if (isPlainTimeProfile.profile(this, JSTemporalPlainTime.isJSTemporalPlainTime(itemObj))) {
                return (JSTemporalPlainTimeObject)itemObj;
            }
            if (isZonedDateTimeProfile.profile(this, TemporalUtil.isTemporalZonedDateTime(itemObj))) {
                JSTemporalZonedDateTimeObject zdt = (JSTemporalZonedDateTimeObject)itemObj;
                JSTemporalInstantObject instant = JSTemporalInstant.create(ctx, realm, zdt.getNanoseconds());
                TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(zdt.getTimeZone());
                JSTemporalPlainDateTimeObject plainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZoneRec, instant, zdt.getCalendar());
                return JSTemporalPlainTime.create(ctx, realm, plainDateTime.getHour(), plainDateTime.getMinute(), plainDateTime.getSecond(), plainDateTime.getMillisecond(), plainDateTime.getMicrosecond(), plainDateTime.getNanosecond(), this, errorBranch);
            }
            if (isPlainDateTimeProfile.profile(this, JSTemporalPlainDateTime.isJSTemporalPlainDateTime(itemObj))) {
                JSTemporalPlainDateTimeObject dt = (JSTemporalPlainDateTimeObject)itemObj;
                return JSTemporalPlainTime.create(ctx, realm, dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getMillisecond(), dt.getMicrosecond(), dt.getNanosecond(), this, errorBranch);
            }
            JSDynamicObject calendar = getTemporalCalendarNode.execute(itemObj);
            if (!toStringNode.executeString(calendar).equals(TemporalConstants.ISO8601)) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorTemporalISO8601Expected();
            }
            JSTemporalDateTimeRecord result3 = TemporalUtil.toTemporalTimeRecord(itemObj);
            result2 = TemporalUtil.regulateTime(result3.getHour(), result3.getMinute(), result3.getSecond(), result3.getMillisecond(), result3.getMicrosecond(), result3.getNanosecond(), overflow);
        } else {
            TruffleString string = toStringNode.executeString(item);
            JSTemporalDateTimeRecord result4 = TemporalUtil.parseTemporalTimeString(string);
            assert (TemporalUtil.isValidTime(result4.getHour(), result4.getMinute(), result4.getSecond(), result4.getMillisecond(), result4.getMicrosecond(), result4.getNanosecond()));
            if (result4.hasCalendar() && !toStringNode.executeString(result4.getCalendar()).equals(TemporalConstants.ISO8601)) {
                throw TemporalErrors.createRangeErrorTemporalISO8601Expected();
            }
            result2 = JSTemporalDurationRecord.create(result4);
        }
        return JSTemporalPlainTime.create(ctx, realm, TemporalUtil.dtoi(result2.getHours()), TemporalUtil.dtoi(result2.getMinutes()), TemporalUtil.dtoi(result2.getSeconds()), TemporalUtil.dtoi(result2.getMilliseconds()), TemporalUtil.dtoi(result2.getMicroseconds()), TemporalUtil.dtoi(result2.getNanoseconds()), this, errorBranch);
    }
}

