/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.python;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import ru.adelf.idea.dotenv.models.KeyUsagePsiElement;
import ru.adelf.idea.dotenv.python.PythonPsiHelper;

class PythonEnvironmentCallsVisitor
extends PsiRecursiveElementVisitor {
    private final Collection<KeyUsagePsiElement> collectedItems = new HashSet<KeyUsagePsiElement>();

    PythonEnvironmentCallsVisitor() {
    }

    public void visitElement(PsiElement element) {
        if (element instanceof PyCallExpression) {
            this.visitCall((PyCallExpression)element);
        }
        if (element instanceof PySubscriptionExpression) {
            this.visitIndex((PySubscriptionExpression)element);
        }
        super.visitElement(element);
    }

    private void visitCall(PyCallExpression expression) {
        if (PythonPsiHelper.checkGetMethodCall(expression) && expression.getArgumentList() != null && expression.getArgumentList().getArguments().length > 0 && expression.getArgumentList().getArguments()[0] instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression stringLiteral = (PyStringLiteralExpression)expression.getArgumentList().getArguments()[0];
            this.collectedItems.add(new KeyUsagePsiElement(stringLiteral.getStringValue(), (PsiElement)stringLiteral));
        }
    }

    private void visitIndex(PySubscriptionExpression expression) {
        if (PythonPsiHelper.checkIndexCall(expression) && expression.getIndexExpression() instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression stringLiteral = (PyStringLiteralExpression)expression.getIndexExpression();
            this.collectedItems.add(new KeyUsagePsiElement(stringLiteral.getStringValue(), (PsiElement)stringLiteral));
        }
    }

    @NotNull
    Collection<KeyUsagePsiElement> getCollectedItems() {
        Collection<KeyUsagePsiElement> collection = this.collectedItems;
        if (collection == null) {
            PythonEnvironmentCallsVisitor.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/adelf/idea/dotenv/python/PythonEnvironmentCallsVisitor", "getCollectedItems"));
    }
}

