/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.formatter;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSLanguageCodeStyleSettingsProvider;
import com.intellij.lang.qml.QmlBundle;
import com.intellij.lang.qml.QmlLanguageDialect;
import com.intellij.lang.qml.formatter.QmlCodeStyleConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QmlLanguageCodeStyleSettingsProvider
extends JSLanguageCodeStyleSettingsProvider {
    static final String SETTINGS_FILE_NAME = "jetbrainsDummySettingsFile";
    private static final String QML_CODE_SAMPLE_START = "import QtQuick 2.0\nimport QtQuick.Controls 2.0 as Controls\nItem {\n  id: test\n  readonly property var foo: 1.0\n  property string bar: false ? \"1\" : \"0\"\n  onWidthChanged: {\n    var x = 0\n  }\n  function func() {\n";
    private static final String QML_CODE_SAMPLE_END = "  }\n}\n";
    private static final String MODIFIED_ES6_SPACING_CODE_SAMPLE = "export class Greeter {\n    greetNTimes(to, {from, times}) {\n        return range(times).map(item => this.greet(to, from))\n    }\n}\n\nexport class ConsoleGreeter extends Greeter {\n    greet(to, from) {\n        return `Hello, ${to} from ${from.join(',')}`\n    }\n}\n\nnew ConsoleGreeter().greetNTimes('World', {name: ['Webstorm'], times: 3})\nfunction *fibonacci(current = 1, next = 1) {\n    yield current;\n    yield *fibonacci(next, current + next);\n}\n\nlet [first, second, ...rest] = take(fibonacci(), 10)\n";

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        if (baseSettings == null) {
            QmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        if (modelSettings == null) {
            QmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return new QmlCodeStyleConfigurable(baseSettings, modelSettings);
    }

    @NotNull
    public Language getLanguage() {
        QmlLanguageDialect qmlLanguageDialect = QmlLanguageDialect.getInstance();
        if (qmlLanguageDialect == null) {
            QmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        return qmlLanguageDialect;
    }

    @Nullable
    @NlsContexts.Label
    public String getLanguageName() {
        return QmlBundle.message("qml.code.style.tab.name", new Object[0]);
    }

    private static String extractJsCode(String jsCode) {
        return jsCode.replaceAll("(?m)^import.*", "").trim();
    }

    private static String wrapSample(String sample) {
        return QML_CODE_SAMPLE_START + QmlLanguageCodeStyleSettingsProvider.extractJsCode(sample) + QML_CODE_SAMPLE_END;
    }

    private static String getQmlWrappingCodeSample() {
        return QmlLanguageCodeStyleSettingsProvider.wrapSample("import {Component} from 'react'\nimport {Rx} from 'rxjs/Observable'\nimport {property1, property2, property3} from './myModule.js'\n\n@ClassDecorator(param1, param2)\n@ClassDecoratorExt\nclass Foo extends BarComponent implements BazService, QuuxProvider {\n\n    @MethodDecorator(param1) @MethodDecoratorExt\n    foo(@ParamDecoratorExt @Deprecated prop1, @ParamDecoratorExt(property1) prop2) {}\n\n    @FieldDecorator\n    @FieldDecoratorExt\n    field1 = 1;\n}\n\nfunction buzz() { return 0; }\nvar x = 1, y = 2, foregroundColor = 'transparent', highlightColor = 'lime', font = 'Arial';\n/*\n Multiline\n   C-style\n     Comment\n */\nvar myLink  = {img: \"btn.gif\"},\n    local   = true,\n    initial = -1;\nwidth = 400\nheight = 300\n\nvar foo = {\n    numbers:['one', 'two', 'three', 'four', 'five', 'six'],\n    data : {a:{id: 123, type: \"String\", isAvailable: true},\nb:{id: 456, type:\"Int\"}},\n// fBar : function (x,y);\n    fOne:function(a, b, c, d, e, f, g, h) {\n        var x = a + b + c + d + e + f + g + h;\n        fTwo(a, b, c, fThree(d, e, f, g, h));\n        var z = a == 'Some string' ? 'yes' : 'no';\n        z = a == 10 ? 'yes' : 'no';\n        var colors = ['red', 'green', 'blue', 'black', 'white', 'gray'];\n        for (j = 0; j < 2; j ++) i = a;        for (var i = 0; i < colors.length; i++)\n             var colorString = this.numbers[i];\n    },\n\n chainedCallSample: function(a,b,c,d,e,f) {\n        chainRoot.firstCall(a,b,c,d,e,f,g).secondCall(a,b,c,d).thirdCall(a,b,c,d).fourthCall().q(a).r(a,b).s();\n        chainRoot.x().y()\n        .z();     },\n callArgumentsSample: function () {\n    this.fTwo(\"one\", \"two\", \"three\", \"four\");\n    this.fThree({\n      strA: 'a',\n      strB: 'b',\n      strC: 'c',\n      strD: 'd'\n    }, 'strE');\n    [1, 2, 3].reduce(function (previousValue, currentValue) {\n      return previousValue + currentValue;\n    }, 10);\n  },\n    /**\n     * Function JSDoc. Long lines can be wrapped with 'Comments'/'Wrap at right margin' option\n     * @param {string} a Parameter A description.\n     * @param {string} b Parameter B description. Can extend beyond the right margin.\n     */\n    fTwo:function(a, b, c, d) {\n        foo(a, b, c, d); // Line comment which can be wrapped if long.\n        if (true)\n            return c;\n        if (a == 'one' && (b == 'two' || c == 'three')) {\n            return a + b + c + d;\n        } else return strD;\n        if (a == 'one') {\n            return 1;\n        }\n        else if(a == 'two') {\n            return 2;\n        }\n        var number = -10;\n        while (x < 0) {\n            number = number + 1;\n        }\n        do {\n            number = number + 1;\n        } while (number < 10);\n        return d;\n    },\n\n    fThree:function({strA, strB, strC, strD}, strE) {\n        var number = prompt(\"Enter a number:\", 0);\n        switch (number) {\n            case 0 :\n                alert(\"Zero\");\n                break;\n            case 1:\n                alert(\"One\");\n                break;\n        }\n        try {\n            a[2]= 10;\n        }\n        catch(e) {\n            alert(\"Failure: \" + e.message);\n        }\n        return strA + strB + strC + strD + strE;\n    }\n};");
    }

    private static String getBlankLinesCodeSample() {
        return QmlLanguageCodeStyleSettingsProvider.wrapSample("/**\n * This is a sample file\n */\nimport {Component} from 'React'\nimport {add, subtract} from 'utils';\nclass Foo {\n    field1 = 1;\n    field2 = 2;\n    foo() {\n        console.log('foo')\n    }\n    static bar() {\n        function hello(n) {\n            console.log('hello ' + n)\n        }\n        var x = 1;\n\n\n        while (x < 10) {\n            hello(x)\n        }\n    }\n}");
    }

    private static String getSimpleSpacingCodeSample() {
        return QmlLanguageCodeStyleSettingsProvider.wrapSample("export class Greeter {\n    greetNTimes(to, {from, times}) {\n        return range(times).map(item => this.greet(to, from))\n    }\n}\n\nexport class ConsoleGreeter extends Greeter {\n    greet(to, from) {\n        return `Hello, ${to} from ${from.join(',')}`\n    }\n}\n\nnew ConsoleGreeter().greetNTimes('World', {name: ['Webstorm'], times: 3})\nfunction *fibonacci(current = 1, next = 1) {\n    yield current;\n    yield *fibonacci(next, current + next);\n}\n\nlet [first, second, ...rest] = take(fibonacci(), 10)\n\nfunction foo(x,y,z) {\n    var i = 0;\n    var x = {0:\"zero\",1:\"one\"};\n    var a = [0,1,2];\n    var foo = function () {}\n    var asyncFoo = async (x, y, z) => { }\n    var v = x.map( s => s.length );\n    if (!i > 10) {\n        for (var j = 0; j < 10; j++) {\n            switch (j) {\n                case 0:\n                    value = \"zero\";\n                    break;\n                case 1:\n                    value = \"one\";\n                    break;\n            }\n            var c = j > 5 ? \"GT 5\" : \"LE 5\";\n        }\n    } else {\n        var j = 0;\n        try {\n            while (j < 10) {\n                if (i == j || j > 5) {\n                    a[j] = i + j * 12;\n                }\n                i = (j << 2) & 4;\n                j++;\n            }\n            do {\n                j--;\n            } while (j > 0)\n        } catch (e) {\n            alert(\"Failure: \" + e.message);\n        } finally {\n            reset(a,i);\n        }\n    }\n}");
    }

    private static String getIndentsCodeSample() {
        return QmlLanguageCodeStyleSettingsProvider.wrapSample("foo(\n        \"demo\",\n        {\n            title:\"Demo\",\n            width:100\n        },\n        function() {\n            object.firstCall({\n            a:'a',\n            b:'b'})\n            .secondCall();\n        }\n);");
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            QmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        return switch (settingsType) {
            case LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS -> QmlLanguageCodeStyleSettingsProvider.getQmlWrappingCodeSample();
            case LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS -> QmlLanguageCodeStyleSettingsProvider.getBlankLinesCodeSample();
            case LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS -> QmlLanguageCodeStyleSettingsProvider.getSimpleSpacingCodeSample();
            case LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS -> QmlLanguageCodeStyleSettingsProvider.getIndentsCodeSample();
            default -> "import {Component} from 'react'\n\nfunction foo(){\n  ct(a,b)\n\n\n  c0=c0+1\n   if (c0 >= 2)cl0.left=-100\n  TC=TC+1\n  if (Fm >= Fl){Fm=Fl}\n  while (TC != Bl){Bo+=1;x++}\n  if (Bo >= 1){\n   x=x-5\n   if (x >= 0){\n    if (s!=\"C\") return\n   }\n   if (x == 0){\n    if (x <= 0){\n     if (s!=\"C\"){\n      x=1\n     }else{\n      x=10\n     }\n    }\n   }\n   x=0\n   for (x1=0; x1<10; x1++) if (EX[x1] >= -50){x=1}\n   if (x == 0) B(\"a\",\"b\")\n  }\n}";
        };
    }

    @Nullable
    public PsiFile createFileFromText(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            QmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        if (text == null) {
            QmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        return PsiFileFactory.getInstance((Project)project).createFileFromText(SETTINGS_FILE_NAME, (Language)QmlLanguageDialect.getInstance(), (CharSequence)text, false, false);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            QmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (settingsType == null) {
            QmlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        QmlLanguageCodeStyleSettingsProvider.addJSOrTSCommonSettings((CodeStyleSettingsCustomizable)consumer, JSCodeStyleSettings.class, (LanguageCodeStyleSettingsProvider.SettingsType)settingsType);
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_BEFORE_CLASS_LBRACE", JavaScriptBundle.message((String)"space.before.class.lbrace", (Object[])new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_BEFORE_LEFT_BRACE, new Object[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/qml/formatter/QmlLanguageCodeStyleSettingsProvider";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/qml/formatter/QmlLanguageCodeStyleSettingsProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

