from collections.abc import Callable, Iterable
from typing import Any
from uuid import UUID

from django.db.backends.base.operations import BaseDatabaseOperations

class DatabaseOperations(BaseDatabaseOperations):
    jsonfield_datatype_values: frozenset[str]
    def bulk_insert_sql(self, fields: Any, placeholder_rows: Iterable[str]) -> str: ...
    def convert_booleanfield_value(self, value: Any, expression: Any, connection: Any) -> Any: ...
    def convert_datefield_value(self, value: Any, expression: Any, connection: Any) -> Any: ...
    def convert_datetimefield_value(self, value: Any, expression: Any, connection: Any) -> Any | None: ...
    def convert_timefield_value(self, value: Any, expression: Any, connection: Any) -> Any: ...
    def convert_uuidfield_value(self, value: Any, expression: Any, connection: Any) -> UUID | None: ...
    def fetch_returned_insert_rows(self, cursor: Any) -> Any: ...
    def get_decimalfield_converter(
        self,
        expression: Any,
    ) -> Callable: ...
