
# container

<!---MARKER_GEN_START-->
Manage containers

### Subcommands

| Name                              | Description                                                                   |
|:----------------------------------|:------------------------------------------------------------------------------|
| [`attach`](container_attach.md)   | Attach local standard input, output, and error streams to a running container |
| [`commit`](container_commit.md)   | Create a new image from a container's changes                                 |
| [`cp`](container_cp.md)           | Copy files/folders between a container and the local filesystem               |
| [`create`](container_create.md)   | Create a new container                                                        |
| [`diff`](container_diff.md)       | Inspect changes to files or directories on a container's filesystem           |
| [`exec`](container_exec.md)       | Execute a command in a running container                                      |
| [`export`](container_export.md)   | Export a container's filesystem as a tar archive                              |
| [`inspect`](container_inspect.md) | Display detailed information on one or more containers                        |
| [`kill`](container_kill.md)       | Kill one or more running containers                                           |
| [`logs`](container_logs.md)       | Fetch the logs of a container                                                 |
| [`ls`](container_ls.md)           | List containers                                                               |
| [`pause`](container_pause.md)     | Pause all processes within one or more containers                             |
| [`port`](container_port.md)       | List port mappings or a specific mapping for the container                    |
| [`prune`](container_prune.md)     | Remove all stopped containers                                                 |
| [`rename`](container_rename.md)   | Rename a container                                                            |
| [`restart`](container_restart.md) | Restart one or more containers                                                |
| [`rm`](container_rm.md)           | Remove one or more containers                                                 |
| [`run`](container_run.md)         | Create and run a new container from an image                                  |
| [`start`](container_start.md)     | Start one or more stopped containers                                          |
| [`stats`](container_stats.md)     | Display a live stream of container(s) resource usage statistics               |
| [`stop`](container_stop.md)       | Stop one or more running containers                                           |
| [`top`](container_top.md)         | Display the running processes of a container                                  |
| [`unpause`](container_unpause.md) | Unpause all processes within one or more containers                           |
| [`update`](container_update.md)   | Update configuration of one or more containers                                |
| [`wait`](container_wait.md)       | Block until one or more containers stop, then print their exit codes          |



<!---MARKER_GEN_END-->

## Description

Manage containers.

