package grype

import (
	"math"
	"path/filepath"
	"testing"

	"github.com/anchore/grype/grype/db/v6/distribution"
	"github.com/anchore/grype/grype/db/v6/installation"
)

// this benchmark was added to measure the performance
// of LoadVulnerabilityDB, specifically regarding hash validation.
// https://github.com/anchore/grype/issues/1502
func BenchmarkLoadVulnerabilityDB(b *testing.B) {
	for range b.N {
		_, _, err := LoadVulnerabilityDB(distribution.Config{
			LatestURL: distribution.DefaultConfig().LatestURL,
		}, installation.Config{
			DBRootDir:               filepath.Join(".tmp", "grype-db"),
			ValidateAge:             false,
			ValidateChecksum:        true,
			MaxAllowedBuiltAge:      math.MaxInt32,
			UpdateCheckMaxFrequency: math.MaxInt32,
		}, true)
		if err != nil {
			b.Fatal(err)
		}
	}
}
