/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.mvel.ASTArrayList;
import org.mvel.ASTNode;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.Soundex;
import org.mvel.ast.LineLabel;
import org.mvel.debug.Debugger;
import org.mvel.debug.Frame;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ExecutionStack;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.StringAppender;

public class MVELRuntime {
    private static ThreadLocal<Map<String, Set<Integer>>> threadBreakpoints;
    private static ThreadLocal<Debugger> threadDebugger;

    public static Object execute(boolean debugger, ASTArrayList node, Object ctx, VariableResolverFactory variableFactory) {
        ExecutionStack stk = new ExecutionStack();
        ASTNode tk = null;
        try {
            block30: while ((tk = node.nextNode()) != null) {
                if (tk.fields == -1) {
                    if (!debugger && threadBreakpoints != null && threadBreakpoints.get() != null) {
                        debugger = true;
                    }
                    if (!debugger) continue;
                    LineLabel label = (LineLabel)tk;
                    if (threadBreakpoints == null || !threadBreakpoints.get().get(label.getSourceFile()).contains(label.getLineNumber())) continue;
                    if (threadDebugger == null || threadDebugger.get() == null) {
                        throw new RuntimeException("no debugger registered to handle breakpoint.");
                    }
                    threadDebugger.get().onBreak(new Frame(label.getSourceFile(), label.getLineNumber(), variableFactory));
                    continue;
                }
                if (stk.isEmpty()) {
                    stk.push(tk.getReducedValueAccelerated(ctx, ctx, variableFactory));
                }
                if (!tk.isOperator()) continue;
                Integer operator = tk.getOperator();
                switch (operator) {
                    case 12: {
                        if (stk.peek() instanceof Boolean && !((Boolean)stk.peek()).booleanValue()) {
                            while (node.hasMoreNodes() && !node.nextNode().isOperator(36)) {
                            }
                            if (!node.hasMoreNodes()) {
                                return stk.pop();
                            }
                            stk.clear();
                            continue block30;
                        }
                        stk.discard();
                        continue block30;
                    }
                    case 13: {
                        if (stk.peek() instanceof Boolean && ((Boolean)stk.peek()).booleanValue()) {
                            while (node.hasMoreNodes() && !node.nextNode().isOperator(36)) {
                            }
                            if (!node.hasMoreNodes()) {
                                return stk.pop();
                            }
                            stk.clear();
                            continue block30;
                        }
                        stk.discard();
                        continue block30;
                    }
                    case 28: {
                        if (!((Boolean)stk.pop()).booleanValue()) {
                            while (node.hasMoreNodes() && !node.nextNode().isOperator(29)) {
                            }
                        }
                        stk.clear();
                        continue block30;
                    }
                    case 29: {
                        return stk.pop();
                    }
                    case 36: {
                        if (!node.hasMoreNodes()) continue block30;
                        stk.clear();
                        continue block30;
                    }
                }
                stk.push(node.nextNode().getReducedValueAccelerated(ctx, ctx, variableFactory), operator);
                try {
                    while (stk.size() > 1) {
                        operator = (Integer)stk.pop();
                        Object v1 = stk.pop();
                        Object v2 = stk.pop();
                        switch (operator) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: {
                                stk.push(ParseTools.doOperations(v2, operator, v1));
                                break;
                            }
                            case 14: {
                                if (!PropertyTools.isEmpty(v2) || !PropertyTools.isEmpty(v1)) {
                                    stk.clear();
                                    stk.push(!PropertyTools.isEmpty(v2) ? v2 : v1);
                                    break;
                                }
                                stk.push(null);
                                break;
                            }
                            case 15: {
                                stk.push(Pattern.compile(String.valueOf(v1)).matcher(String.valueOf(v2)).matches());
                                break;
                            }
                            case 16: {
                                if (v1 instanceof Class) {
                                    stk.push(((Class)v1).isInstance(v2));
                                    break;
                                }
                                stk.push(Class.forName(String.valueOf(v1)).isInstance(v2));
                                break;
                            }
                            case 35: {
                                if (v1 instanceof Class) {
                                    stk.push(DataConversion.canConvert(v2.getClass(), (Class)v1));
                                    break;
                                }
                                stk.push(DataConversion.canConvert(v2.getClass(), Class.forName(String.valueOf(v1))));
                                break;
                            }
                            case 17: {
                                stk.push(ParseTools.containsCheck(v2, v1));
                                break;
                            }
                            case 21: {
                                stk.push((Integer)v2 & (Integer)v1);
                                break;
                            }
                            case 22: {
                                stk.push((Integer)v2 | (Integer)v1);
                                break;
                            }
                            case 23: {
                                stk.push((Integer)v2 ^ (Integer)v1);
                                break;
                            }
                            case 25: {
                                stk.push((Integer)v2 << (Integer)v1);
                                break;
                            }
                            case 27: {
                                int iv2 = (Integer)v2;
                                if (iv2 < 0) {
                                    iv2 *= -1;
                                }
                                stk.push(iv2 << (Integer)v1);
                                break;
                            }
                            case 24: {
                                stk.push((Integer)v2 >> (Integer)v1);
                                break;
                            }
                            case 26: {
                                stk.push((Integer)v2 >>> (Integer)v1);
                                break;
                            }
                            case 18: {
                                stk.push(new StringAppender(String.valueOf(v2)).append(String.valueOf(v1)).toString());
                                break;
                            }
                            case 19: {
                                stk.push(Soundex.soundex(String.valueOf(v1)).equals(Soundex.soundex(String.valueOf(v2))));
                                break;
                            }
                            case 20: {
                                stk.push(Float.valueOf(PropertyTools.similarity(String.valueOf(v1), String.valueOf(v2))));
                            }
                        }
                    }
                }
                catch (ClassCastException e) {
                    throw new CompileException("syntax error or incomptable types", e);
                }
                catch (Exception e) {
                    throw new CompileException("failed to subEval expression", e);
                }
            }
            return stk.peek();
        }
        catch (NullPointerException e) {
            if (tk != null && tk.isOperator() && !node.hasMoreNodes()) {
                throw new CompileException("incomplete statement: " + tk.getName() + " (possible use of reserved keyword as identifier: " + tk.getName() + ")");
            }
            throw e;
        }
    }

    public static void registerBreakpoint(String source, int line) {
        if (threadBreakpoints == null) {
            threadBreakpoints = new ThreadLocal();
            threadBreakpoints.set(new HashMap());
        }
        if (!threadBreakpoints.get().containsKey(source)) {
            threadBreakpoints.get().put(source, new HashSet());
        }
        threadBreakpoints.get().get(source).add(line);
    }

    public static void removeBreakpoint(String source, int line) {
        if (threadBreakpoints != null && threadBreakpoints.get() != null) {
            threadBreakpoints.get().get(source).remove(line);
        }
    }

    public static void clearAllBreakpoints() {
        if (threadBreakpoints != null && threadBreakpoints.get() != null) {
            threadBreakpoints.get().clear();
        }
    }

    public static void setThreadDebugger(Debugger debugger) {
        if (threadDebugger == null) {
            threadDebugger = new ThreadLocal();
        }
        if (threadDebugger.get() == null) {
            threadDebugger.set(debugger);
        }
    }
}

