/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.Cast;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.jvm.Jvm;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.util.internal.GUtil;

public class DefaultBuildActionParameters
implements BuildActionParameters,
Serializable {
    private final File currentDir;
    private final LogLevel logLevel;
    private final Map<String, String> systemProperties;
    private final Map<String, String> envVariables;
    private final boolean useDaemon;
    private final ClassPath injectedPluginClasspath;

    public DefaultBuildActionParameters(Map<?, ?> systemProperties, Map<String, String> envVariables, File currentDir, LogLevel logLevel, boolean useDaemon, ClassPath injectedPluginClasspath) {
        this.currentDir = currentDir;
        this.logLevel = logLevel;
        this.useDaemon = useDaemon;
        assert (systemProperties != null);
        assert (envVariables != null);
        this.systemProperties = new HashMap<String, String>();
        GUtil.addToMap(this.systemProperties, systemProperties);
        this.envVariables = new HashMap<String, String>((Map)Cast.uncheckedCast((Object)Jvm.getInheritableEnvironmentVariables(envVariables)));
        this.injectedPluginClasspath = injectedPluginClasspath;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public Map<String, String> getEnvVariables() {
        return this.envVariables;
    }

    @Override
    public File getCurrentDir() {
        return this.currentDir;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public String toString() {
        return "DefaultBuildActionParameters{, currentDir=" + this.currentDir + ", systemProperties size=" + this.systemProperties.size() + ", envVariables size=" + this.envVariables.size() + ", logLevel=" + this.logLevel + ", useDaemon=" + this.useDaemon + ", injectedPluginClasspath=" + this.injectedPluginClasspath + '}';
    }

    @Override
    public boolean isUseDaemon() {
        return this.useDaemon;
    }

    @Override
    public ClassPath getInjectedPluginClasspath() {
        return this.injectedPluginClasspath;
    }
}

