if(CMAKE_SYSTEM_NAME MATCHES "Linux")
    set(LINUX TRUE)
endif(CMAKE_SYSTEM_NAME MATCHES "Linux")

if(CMAKE_SYSTEM_NAME MATCHES "FreeBSD")
    set(FREEBSD true)
    set(CMAKE_INSTALL_RPATH_USE_LINK_PATH TRUE)
    #FIXME: find a nicer and more general way of doing this
    if(CMAKE_C_COMPILER MATCHES "/usr/local/bin/gcc13")
        set(CMAKE_BUILD_RPATH "/usr/local/lib/gcc13")
    elseif(ARCH_AARCH64 AND (CMAKE_C_COMPILER MATCHES "/usr/local/bin/gcc12"))
        set(CMAKE_BUILD_RPATH "/usr/local/lib/gcc12")
    endif()
endif(CMAKE_SYSTEM_NAME MATCHES "FreeBSD")

if(CMAKE_SYSTEM_NAME MATCHES "NetBSD")
    set(NETBSD true)
endif(CMAKE_SYSTEM_NAME MATCHES "NetBSD")

if (${CMAKE_SYSTEM_NAME} MATCHES "Darwin")
    set(MACOSX TRUE)
endif()

if (ARCH_IA32 OR ARCH_X86_64)
  option(FAT_RUNTIME "Build a library that supports multiple microarchitectures" ON)
else()
  option(FAT_RUNTIME "Build a library that supports multiple microarchitectures" OFF)
endif()

if (FAT_RUNTIME)
    message("Checking Fat Runtime Requirements...")
    if (USE_CPU_NATIVE AND FAT_RUNTIME)
        message(FATAL_ERROR "Fat runtime is not compatible with Native CPU detection")
    endif()

    if (NOT (ARCH_IA32 OR ARCH_X86_64 OR ARCH_AARCH64))
        message(FATAL_ERROR "Fat runtime is only supported on Intel and Aarch64 architectures")
    else()
        message(STATUS "Building Fat runtime for multiple microarchitectures")
        message(STATUS "generator is ${CMAKE_GENERATOR}")
        if (NOT (CMAKE_GENERATOR MATCHES "Unix Makefiles" OR
            (CMAKE_VERSION VERSION_GREATER "3.0" AND CMAKE_GENERATOR MATCHES "Ninja")))
            message (FATAL_ERROR "Building the fat runtime requires the Unix Makefiles generator, or Ninja with CMake v3.0 or higher")
        else()
            include (${CMAKE_MODULE_PATH}/attrib.cmake)
            if (NOT HAS_C_ATTR_IFUNC)
                message(FATAL_ERROR "Compiler does not support ifunc attribute, cannot build fat runtime")
            endif()
        endif()
    endif()
    if (NOT RELEASE_BUILD)
        message(FATAL_ERROR "Fat runtime is only built on Release builds")
    endif()
endif ()
