/* Generated by re2c */
// re2c $INPUT -o $OUTPUT -cri
#include <assert.h>
#include <ctype.h>
#include <stdio.h>

template<typename char_t>
struct input_t {
    size_t len;
    char_t *str;

    input_t(FILE *f) : len(0), str(NULL)
    {
        fseek(f, 0, SEEK_END);
        len = ftell(f) / sizeof(char_t);
        fseek(f, 0, SEEK_SET);
        str = new char_t[len + 1];
        fread(str, sizeof(char_t), len, f);
        str[len] = 0;
    }
    ~input_t() { delete[] str; }
};

typedef input_t<unsigned char>  iutf8_t;
typedef input_t<unsigned short> iutf16_t;
typedef input_t<unsigned int>   iutf32_t;
typedef input_t<unsigned short> iucs2_t;

struct out_t {
    bool caps;

    out_t() : caps(false) {}
    void prt(char c)
    {
        fprintf(stderr, "%c", caps ? toupper(c) : c);
        caps = false;
    }
    void err()
    {
        fprintf(stderr, " ... error\n");
    }
};



enum YYCONDTYPE {
	yycl,
	yycn
};


static void lex_utf8(const iutf8_t & in)
{
    const unsigned char *YYCURSOR = in.str, *YYMARKER;
    int c = yycl;
    out_t out;
    
{
	unsigned char yych;
	switch (c) {
		case yycl: goto yyc_l;
		case yycn: goto yyc_n;
	}
/* *********************************** */
yyc_l:
	yych = *YYCURSOR;
	switch (yych) {
		case 0x00: goto yy1;
		case '\n': goto yy4;
		case ' ': goto yy6;
		case 0xE2: goto yy7;
		default: goto yy2;
	}
yy1:
	++YYCURSOR;
	{ if (YYCURSOR != in.str + in.len + 1) out.err(); return; }
yy2:
	++YYCURSOR;
yy3:
	{ out.err(); return; }
yy4:
	yych = *++YYCURSOR;
	switch (yych) {
		case '\r': goto yy8;
		default: goto yy5;
	}
yy5:
	{ out.prt('\n'); goto yyc_l; }
yy6:
	++YYCURSOR;
	{ out.prt(' '); goto yyc_l; }
yy7:
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 0xA0: goto yy9;
		default: goto yy3;
	}
yy8:
	++YYCURSOR;
	goto yy5;
yy9:
	yych = *++YYCURSOR;
	switch (yych) {
		case 0x80: goto yy6;
		case 0x81: goto yy11;
		case 0x82: goto yy12;
		case 0x83: goto yy13;
		case 0x84: goto yy14;
		case 0x85: goto yy15;
		case 0x86: goto yy16;
		case 0x87: goto yy17;
		case 0x89: goto yy18;
		case 0x8A: goto yy19;
		case 0x8B: goto yy20;
		case 0x8D: goto yy21;
		case 0x8E: goto yy22;
		case 0x8F: goto yy23;
		case 0x91: goto yy24;
		case 0x92: goto yy25;
		case 0x93: goto yy26;
		case 0x94: goto yy27;
		case 0x95: goto yy28;
		case 0x96: goto yy29;
		case 0x97: goto yy30;
		case 0x99: goto yy31;
		case 0x9A: goto yy32;
		case 0x9B: goto yy33;
		case 0x9D: goto yy34;
		case 0x9E: goto yy35;
		case 0x9F: goto yy36;
		case 0xA0: goto yy37;
		case 0xA4: goto yy38;
		case 0xA5: goto yy39;
		case 0xA6: goto yy40;
		case 0xA7: goto yy41;
		case 0xAD: goto yy42;
		case 0xB0: goto yy43;
		case 0xB2: goto yy44;
		case 0xB5: goto yy45;
		case 0xBA: goto yy46;
		case 0xBC: goto yy47;
		case 0xBD: goto yy48;
		default: goto yy10;
	}
yy10:
	YYCURSOR = YYMARKER;
	goto yy3;
yy11:
	++YYCURSOR;
	{ out.prt('a'); goto yyc_l; }
yy12:
	++YYCURSOR;
	{ out.prt(','); goto yyc_l; }
yy13:
	++YYCURSOR;
	{ out.prt('b'); goto yyc_l; }
yy14:
	++YYCURSOR;
	{ out.prt('\''); goto yyc_l; }
yy15:
	++YYCURSOR;
	{ out.prt('k'); goto yyc_l; }
yy16:
	++YYCURSOR;
	{ out.prt(';'); goto yyc_l; }
yy17:
	++YYCURSOR;
	{ out.prt('l'); goto yyc_l; }
yy18:
	++YYCURSOR;
	{ out.prt('c'); goto yyc_l; }
yy19:
	++YYCURSOR;
	{ out.prt('i'); goto yyc_l; }
yy20:
	++YYCURSOR;
	{ out.prt('f'); goto yyc_l; }
yy21:
	++YYCURSOR;
	{ out.prt('m'); goto yyc_l; }
yy22:
	++YYCURSOR;
	{ out.prt('s'); goto yyc_l; }
yy23:
	++YYCURSOR;
	{ out.prt('p'); goto yyc_l; }
yy24:
	++YYCURSOR;
	{ out.prt('e'); goto yyc_l; }
yy25:
	++YYCURSOR;
	{ out.prt(':'); goto yyc_l; }
yy26:
	++YYCURSOR;
	{ out.prt('h'); goto yyc_l; }
yy27:
	++YYCURSOR;
	{ out.prt('*'); goto yyc_l; }
yy28:
	++YYCURSOR;
	{ out.prt('o'); goto yyc_l; }
yy29:
	++YYCURSOR;
	{ out.prt('!'); goto yyc_l; }
yy30:
	++YYCURSOR;
	{ out.prt('r'); goto yyc_l; }
yy31:
	++YYCURSOR;
	{ out.prt('d'); goto yyc_l; }
yy32:
	++YYCURSOR;
	{ out.prt('j'); goto yyc_l; }
yy33:
	++YYCURSOR;
	{ out.prt('g'); goto yyc_l; }
yy34:
	++YYCURSOR;
	{ out.prt('n'); goto yyc_l; }
yy35:
	++YYCURSOR;
	{ out.prt('t'); goto yyc_l; }
yy36:
	++YYCURSOR;
	{ out.prt('q'); goto yyc_l; }
yy37:
	++YYCURSOR;
	{ out.caps = true; goto yyc_l; }
yy38:
	++YYCURSOR;
	{ out.prt('-'); goto yyc_l; }
yy39:
	++YYCURSOR;
	{ out.prt('u'); goto yyc_l; }
yy40:
	++YYCURSOR;
	{ out.prt('?'); goto yyc_l; }
yy41:
	++YYCURSOR;
	{ out.prt('v'); goto yyc_l; }
yy42:
	++YYCURSOR;
	{ out.prt('x'); goto yyc_l; }
yy43:
	++YYCURSOR;
	goto yyc_l;
yy44:
	++YYCURSOR;
	{ out.prt('.'); goto yyc_l; }
yy45:
	++YYCURSOR;
	{ out.prt('z'); goto yyc_l; }
yy46:
	++YYCURSOR;
	{ out.prt('w'); goto yyc_l; }
yy47:
	++YYCURSOR;
	c = yycn;
	goto yyc_n;
yy48:
	++YYCURSOR;
	{ out.prt('y'); goto yyc_l; }
/* *********************************** */
yyc_n:
	yych = *YYCURSOR;
	switch (yych) {
		case 0x00: goto yy50;
		case '\n': goto yy53;
		case ' ': goto yy55;
		case 0xE2: goto yy56;
		default: goto yy51;
	}
yy50:
	++YYCURSOR;
	{ if (YYCURSOR != in.str + in.len + 1) out.err(); return; }
yy51:
	++YYCURSOR;
yy52:
	{ out.err(); return; }
yy53:
	yych = *++YYCURSOR;
	switch (yych) {
		case '\r': goto yy57;
		default: goto yy54;
	}
yy54:
	{ out.prt('\n'); goto yyc_l; }
yy55:
	++YYCURSOR;
	{ out.prt(' '); goto yyc_l; }
yy56:
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 0xA0: goto yy58;
		default: goto yy52;
	}
yy57:
	++YYCURSOR;
	goto yy54;
yy58:
	yych = *++YYCURSOR;
	switch (yych) {
		case 0x80: goto yy55;
		case 0x81: goto yy60;
		case 0x82: goto yy61;
		case 0x83: goto yy62;
		case 0x84: goto yy63;
		case 0x86: goto yy64;
		case 0x89: goto yy65;
		case 0x8A: goto yy66;
		case 0x8B: goto yy67;
		case 0x91: goto yy68;
		case 0x92: goto yy69;
		case 0x93: goto yy70;
		case 0x94: goto yy71;
		case 0x96: goto yy72;
		case 0x99: goto yy73;
		case 0x9A: goto yy74;
		case 0x9B: goto yy75;
		case 0xA0: goto yy76;
		case 0xA4: goto yy77;
		case 0xA6: goto yy78;
		case 0xB0: goto yy79;
		case 0xB2: goto yy80;
		case 0xBC: goto yy81;
		default: goto yy59;
	}
yy59:
	YYCURSOR = YYMARKER;
	goto yy52;
yy60:
	++YYCURSOR;
	{ out.prt('1'); goto yyc_n; }
yy61:
	++YYCURSOR;
	{ out.prt(','); goto yyc_l; }
yy62:
	++YYCURSOR;
	{ out.prt('2'); goto yyc_n; }
yy63:
	++YYCURSOR;
	{ out.prt('\''); goto yyc_l; }
yy64:
	++YYCURSOR;
	{ out.prt(';'); goto yyc_l; }
yy65:
	++YYCURSOR;
	{ out.prt('3'); goto yyc_n; }
yy66:
	++YYCURSOR;
	{ out.prt('9'); goto yyc_n; }
yy67:
	++YYCURSOR;
	{ out.prt('6'); goto yyc_n; }
yy68:
	++YYCURSOR;
	{ out.prt('5'); goto yyc_n; }
yy69:
	++YYCURSOR;
	{ out.prt(':'); goto yyc_l; }
yy70:
	++YYCURSOR;
	{ out.prt('8'); goto yyc_n; }
yy71:
	++YYCURSOR;
	{ out.prt('*'); goto yyc_l; }
yy72:
	++YYCURSOR;
	{ out.prt('!'); goto yyc_l; }
yy73:
	++YYCURSOR;
	{ out.prt('4'); goto yyc_n; }
yy74:
	++YYCURSOR;
	{ out.prt('0'); goto yyc_n; }
yy75:
	++YYCURSOR;
	{ out.prt('7'); goto yyc_n; }
yy76:
	++YYCURSOR;
	{ out.caps = true; goto yyc_l; }
yy77:
	++YYCURSOR;
	{ out.prt('-'); goto yyc_l; }
yy78:
	++YYCURSOR;
	{ out.prt('?'); goto yyc_l; }
yy79:
	++YYCURSOR;
	c = yycl;
	goto yyc_l;
yy80:
	++YYCURSOR;
	{ out.prt('.'); goto yyc_l; }
yy81:
	++YYCURSOR;
	goto yyc_n;
}

}

static void lex_utf16(const iutf16_t & in)
{
    const unsigned short *YYCURSOR = in.str;
    int c = yycl;
    out_t out;
    
{
	unsigned int yych;
	if (c < 1) {
		goto yyc_l;
	} else {
		goto yyc_n;
	}
/* *********************************** */
yyc_l:
	yych = *YYCURSOR;
	if (yych <= 0x2816) {
		if (yych <= 0x2807) {
			if (yych <= 0x2800) {
				if (yych <= '\n') {
					if (yych <= 0x0000) goto yy83;
					if (yych <= '\t') goto yy84;
					goto yy85;
				} else {
					if (yych == ' ') goto yy87;
					if (yych <= 0x27FF) goto yy84;
					goto yy87;
				}
			} else {
				if (yych <= 0x2803) {
					if (yych <= 0x2801) goto yy88;
					if (yych <= 0x2802) goto yy89;
					goto yy90;
				} else {
					if (yych <= 0x2804) goto yy91;
					if (yych <= 0x2805) goto yy92;
					if (yych <= 0x2806) goto yy93;
					goto yy94;
				}
			}
		} else {
			if (yych <= 0x280E) {
				if (yych <= 0x280A) {
					if (yych <= 0x2808) goto yy84;
					if (yych <= 0x2809) goto yy95;
					goto yy96;
				} else {
					if (yych <= 0x280B) goto yy97;
					if (yych <= 0x280C) goto yy84;
					if (yych <= 0x280D) goto yy98;
					goto yy99;
				}
			} else {
				if (yych <= 0x2812) {
					if (yych <= 0x280F) goto yy100;
					if (yych <= 0x2810) goto yy84;
					if (yych <= 0x2811) goto yy101;
					goto yy102;
				} else {
					if (yych <= 0x2813) goto yy103;
					if (yych <= 0x2814) goto yy104;
					if (yych <= 0x2815) goto yy105;
					goto yy106;
				}
			}
		}
	} else {
		if (yych <= 0x2826) {
			if (yych <= 0x281D) {
				if (yych <= 0x2819) {
					if (yych <= 0x2817) goto yy107;
					if (yych <= 0x2818) goto yy84;
					goto yy108;
				} else {
					if (yych <= 0x281A) goto yy109;
					if (yych <= 0x281B) goto yy110;
					if (yych <= 0x281C) goto yy84;
					goto yy111;
				}
			} else {
				if (yych <= 0x2820) {
					if (yych <= 0x281E) goto yy112;
					if (yych <= 0x281F) goto yy113;
					goto yy114;
				} else {
					if (yych <= 0x2823) goto yy84;
					if (yych <= 0x2824) goto yy115;
					if (yych <= 0x2825) goto yy116;
					goto yy117;
				}
			}
		} else {
			if (yych <= 0x2832) {
				if (yych <= 0x282D) {
					if (yych <= 0x2827) goto yy118;
					if (yych <= 0x282C) goto yy84;
					goto yy119;
				} else {
					if (yych == 0x2830) goto yy120;
					if (yych <= 0x2831) goto yy84;
					goto yy121;
				}
			} else {
				if (yych <= 0x283A) {
					if (yych == 0x2835) goto yy122;
					if (yych <= 0x2839) goto yy84;
					goto yy123;
				} else {
					if (yych <= 0x283B) goto yy84;
					if (yych <= 0x283C) goto yy124;
					if (yych <= 0x283D) goto yy125;
					goto yy84;
				}
			}
		}
	}
yy83:
	++YYCURSOR;
	{ if (YYCURSOR != in.str + in.len + 1) out.err(); return; }
yy84:
	++YYCURSOR;
	{ out.err(); return; }
yy85:
	yych = *++YYCURSOR;
	if (yych == '\r') goto yy126;
yy86:
	{ out.prt('\n'); goto yyc_l; }
yy87:
	++YYCURSOR;
	{ out.prt(' '); goto yyc_l; }
yy88:
	++YYCURSOR;
	{ out.prt('a'); goto yyc_l; }
yy89:
	++YYCURSOR;
	{ out.prt(','); goto yyc_l; }
yy90:
	++YYCURSOR;
	{ out.prt('b'); goto yyc_l; }
yy91:
	++YYCURSOR;
	{ out.prt('\''); goto yyc_l; }
yy92:
	++YYCURSOR;
	{ out.prt('k'); goto yyc_l; }
yy93:
	++YYCURSOR;
	{ out.prt(';'); goto yyc_l; }
yy94:
	++YYCURSOR;
	{ out.prt('l'); goto yyc_l; }
yy95:
	++YYCURSOR;
	{ out.prt('c'); goto yyc_l; }
yy96:
	++YYCURSOR;
	{ out.prt('i'); goto yyc_l; }
yy97:
	++YYCURSOR;
	{ out.prt('f'); goto yyc_l; }
yy98:
	++YYCURSOR;
	{ out.prt('m'); goto yyc_l; }
yy99:
	++YYCURSOR;
	{ out.prt('s'); goto yyc_l; }
yy100:
	++YYCURSOR;
	{ out.prt('p'); goto yyc_l; }
yy101:
	++YYCURSOR;
	{ out.prt('e'); goto yyc_l; }
yy102:
	++YYCURSOR;
	{ out.prt(':'); goto yyc_l; }
yy103:
	++YYCURSOR;
	{ out.prt('h'); goto yyc_l; }
yy104:
	++YYCURSOR;
	{ out.prt('*'); goto yyc_l; }
yy105:
	++YYCURSOR;
	{ out.prt('o'); goto yyc_l; }
yy106:
	++YYCURSOR;
	{ out.prt('!'); goto yyc_l; }
yy107:
	++YYCURSOR;
	{ out.prt('r'); goto yyc_l; }
yy108:
	++YYCURSOR;
	{ out.prt('d'); goto yyc_l; }
yy109:
	++YYCURSOR;
	{ out.prt('j'); goto yyc_l; }
yy110:
	++YYCURSOR;
	{ out.prt('g'); goto yyc_l; }
yy111:
	++YYCURSOR;
	{ out.prt('n'); goto yyc_l; }
yy112:
	++YYCURSOR;
	{ out.prt('t'); goto yyc_l; }
yy113:
	++YYCURSOR;
	{ out.prt('q'); goto yyc_l; }
yy114:
	++YYCURSOR;
	{ out.caps = true; goto yyc_l; }
yy115:
	++YYCURSOR;
	{ out.prt('-'); goto yyc_l; }
yy116:
	++YYCURSOR;
	{ out.prt('u'); goto yyc_l; }
yy117:
	++YYCURSOR;
	{ out.prt('?'); goto yyc_l; }
yy118:
	++YYCURSOR;
	{ out.prt('v'); goto yyc_l; }
yy119:
	++YYCURSOR;
	{ out.prt('x'); goto yyc_l; }
yy120:
	++YYCURSOR;
	goto yyc_l;
yy121:
	++YYCURSOR;
	{ out.prt('.'); goto yyc_l; }
yy122:
	++YYCURSOR;
	{ out.prt('z'); goto yyc_l; }
yy123:
	++YYCURSOR;
	{ out.prt('w'); goto yyc_l; }
yy124:
	++YYCURSOR;
	c = yycn;
	goto yyc_n;
yy125:
	++YYCURSOR;
	{ out.prt('y'); goto yyc_l; }
yy126:
	++YYCURSOR;
	goto yy86;
/* *********************************** */
yyc_n:
	yych = *YYCURSOR;
	if (yych <= 0x2812) {
		if (yych <= 0x2803) {
			if (yych <= ' ') {
				if (yych <= '\t') {
					if (yych >= 0x0001) goto yy128;
				} else {
					if (yych <= '\n') goto yy129;
					if (yych <= 0x001F) goto yy128;
					goto yy131;
				}
			} else {
				if (yych <= 0x2800) {
					if (yych <= 0x27FF) goto yy128;
					goto yy131;
				} else {
					if (yych <= 0x2801) goto yy132;
					if (yych <= 0x2802) goto yy133;
					goto yy134;
				}
			}
		} else {
			if (yych <= 0x2809) {
				if (yych <= 0x2805) {
					if (yych <= 0x2804) goto yy135;
					goto yy128;
				} else {
					if (yych <= 0x2806) goto yy136;
					if (yych <= 0x2808) goto yy128;
					goto yy137;
				}
			} else {
				if (yych <= 0x280B) {
					if (yych <= 0x280A) goto yy138;
					goto yy139;
				} else {
					if (yych <= 0x2810) goto yy128;
					if (yych <= 0x2811) goto yy140;
					goto yy141;
				}
			}
		}
	} else {
		if (yych <= 0x2820) {
			if (yych <= 0x2818) {
				if (yych <= 0x2814) {
					if (yych <= 0x2813) goto yy142;
					goto yy143;
				} else {
					if (yych == 0x2816) goto yy144;
					goto yy128;
				}
			} else {
				if (yych <= 0x281A) {
					if (yych <= 0x2819) goto yy145;
					goto yy146;
				} else {
					if (yych <= 0x281B) goto yy147;
					if (yych <= 0x281F) goto yy128;
					goto yy148;
				}
			}
		} else {
			if (yych <= 0x282F) {
				if (yych <= 0x2824) {
					if (yych <= 0x2823) goto yy128;
					goto yy149;
				} else {
					if (yych == 0x2826) goto yy150;
					goto yy128;
				}
			} else {
				if (yych <= 0x2832) {
					if (yych <= 0x2830) goto yy151;
					if (yych <= 0x2831) goto yy128;
					goto yy152;
				} else {
					if (yych == 0x283C) goto yy153;
					goto yy128;
				}
			}
		}
	}
	++YYCURSOR;
	{ if (YYCURSOR != in.str + in.len + 1) out.err(); return; }
yy128:
	++YYCURSOR;
	{ out.err(); return; }
yy129:
	yych = *++YYCURSOR;
	if (yych == '\r') goto yy154;
yy130:
	{ out.prt('\n'); goto yyc_l; }
yy131:
	++YYCURSOR;
	{ out.prt(' '); goto yyc_l; }
yy132:
	++YYCURSOR;
	{ out.prt('1'); goto yyc_n; }
yy133:
	++YYCURSOR;
	{ out.prt(','); goto yyc_l; }
yy134:
	++YYCURSOR;
	{ out.prt('2'); goto yyc_n; }
yy135:
	++YYCURSOR;
	{ out.prt('\''); goto yyc_l; }
yy136:
	++YYCURSOR;
	{ out.prt(';'); goto yyc_l; }
yy137:
	++YYCURSOR;
	{ out.prt('3'); goto yyc_n; }
yy138:
	++YYCURSOR;
	{ out.prt('9'); goto yyc_n; }
yy139:
	++YYCURSOR;
	{ out.prt('6'); goto yyc_n; }
yy140:
	++YYCURSOR;
	{ out.prt('5'); goto yyc_n; }
yy141:
	++YYCURSOR;
	{ out.prt(':'); goto yyc_l; }
yy142:
	++YYCURSOR;
	{ out.prt('8'); goto yyc_n; }
yy143:
	++YYCURSOR;
	{ out.prt('*'); goto yyc_l; }
yy144:
	++YYCURSOR;
	{ out.prt('!'); goto yyc_l; }
yy145:
	++YYCURSOR;
	{ out.prt('4'); goto yyc_n; }
yy146:
	++YYCURSOR;
	{ out.prt('0'); goto yyc_n; }
yy147:
	++YYCURSOR;
	{ out.prt('7'); goto yyc_n; }
yy148:
	++YYCURSOR;
	{ out.caps = true; goto yyc_l; }
yy149:
	++YYCURSOR;
	{ out.prt('-'); goto yyc_l; }
yy150:
	++YYCURSOR;
	{ out.prt('?'); goto yyc_l; }
yy151:
	++YYCURSOR;
	c = yycl;
	goto yyc_l;
yy152:
	++YYCURSOR;
	{ out.prt('.'); goto yyc_l; }
yy153:
	++YYCURSOR;
	goto yyc_n;
yy154:
	++YYCURSOR;
	goto yy130;
}

}

static void lex_utf32(const iutf32_t & in)
{
    const unsigned int *YYCURSOR = in.str;
    int c = yycl;
    out_t out;
    
{
	unsigned int yych;
	if (c < 1) {
		goto yyc_l;
	} else {
		goto yyc_n;
	}
/* *********************************** */
yyc_l:
	yych = *YYCURSOR;
	if (yych <= 0x00002816) {
		if (yych <= 0x00002807) {
			if (yych <= 0x00002800) {
				if (yych <= '\n') {
					if (yych <= 0x00000000) goto yy156;
					if (yych <= '\t') goto yy157;
					goto yy158;
				} else {
					if (yych == ' ') goto yy160;
					if (yych <= 0x000027FF) goto yy157;
					goto yy160;
				}
			} else {
				if (yych <= 0x00002803) {
					if (yych <= 0x00002801) goto yy161;
					if (yych <= 0x00002802) goto yy162;
					goto yy163;
				} else {
					if (yych <= 0x00002804) goto yy164;
					if (yych <= 0x00002805) goto yy165;
					if (yych <= 0x00002806) goto yy166;
					goto yy167;
				}
			}
		} else {
			if (yych <= 0x0000280E) {
				if (yych <= 0x0000280A) {
					if (yych <= 0x00002808) goto yy157;
					if (yych <= 0x00002809) goto yy168;
					goto yy169;
				} else {
					if (yych <= 0x0000280B) goto yy170;
					if (yych <= 0x0000280C) goto yy157;
					if (yych <= 0x0000280D) goto yy171;
					goto yy172;
				}
			} else {
				if (yych <= 0x00002812) {
					if (yych <= 0x0000280F) goto yy173;
					if (yych <= 0x00002810) goto yy157;
					if (yych <= 0x00002811) goto yy174;
					goto yy175;
				} else {
					if (yych <= 0x00002813) goto yy176;
					if (yych <= 0x00002814) goto yy177;
					if (yych <= 0x00002815) goto yy178;
					goto yy179;
				}
			}
		}
	} else {
		if (yych <= 0x00002826) {
			if (yych <= 0x0000281D) {
				if (yych <= 0x00002819) {
					if (yych <= 0x00002817) goto yy180;
					if (yych <= 0x00002818) goto yy157;
					goto yy181;
				} else {
					if (yych <= 0x0000281A) goto yy182;
					if (yych <= 0x0000281B) goto yy183;
					if (yych <= 0x0000281C) goto yy157;
					goto yy184;
				}
			} else {
				if (yych <= 0x00002820) {
					if (yych <= 0x0000281E) goto yy185;
					if (yych <= 0x0000281F) goto yy186;
					goto yy187;
				} else {
					if (yych <= 0x00002823) goto yy157;
					if (yych <= 0x00002824) goto yy188;
					if (yych <= 0x00002825) goto yy189;
					goto yy190;
				}
			}
		} else {
			if (yych <= 0x00002832) {
				if (yych <= 0x0000282D) {
					if (yych <= 0x00002827) goto yy191;
					if (yych <= 0x0000282C) goto yy157;
					goto yy192;
				} else {
					if (yych == 0x00002830) goto yy193;
					if (yych <= 0x00002831) goto yy157;
					goto yy194;
				}
			} else {
				if (yych <= 0x0000283A) {
					if (yych == 0x00002835) goto yy195;
					if (yych <= 0x00002839) goto yy157;
					goto yy196;
				} else {
					if (yych <= 0x0000283B) goto yy157;
					if (yych <= 0x0000283C) goto yy197;
					if (yych <= 0x0000283D) goto yy198;
					goto yy157;
				}
			}
		}
	}
yy156:
	++YYCURSOR;
	{ if (YYCURSOR != in.str + in.len + 1) out.err(); return; }
yy157:
	++YYCURSOR;
	{ out.err(); return; }
yy158:
	yych = *++YYCURSOR;
	if (yych == '\r') goto yy199;
yy159:
	{ out.prt('\n'); goto yyc_l; }
yy160:
	++YYCURSOR;
	{ out.prt(' '); goto yyc_l; }
yy161:
	++YYCURSOR;
	{ out.prt('a'); goto yyc_l; }
yy162:
	++YYCURSOR;
	{ out.prt(','); goto yyc_l; }
yy163:
	++YYCURSOR;
	{ out.prt('b'); goto yyc_l; }
yy164:
	++YYCURSOR;
	{ out.prt('\''); goto yyc_l; }
yy165:
	++YYCURSOR;
	{ out.prt('k'); goto yyc_l; }
yy166:
	++YYCURSOR;
	{ out.prt(';'); goto yyc_l; }
yy167:
	++YYCURSOR;
	{ out.prt('l'); goto yyc_l; }
yy168:
	++YYCURSOR;
	{ out.prt('c'); goto yyc_l; }
yy169:
	++YYCURSOR;
	{ out.prt('i'); goto yyc_l; }
yy170:
	++YYCURSOR;
	{ out.prt('f'); goto yyc_l; }
yy171:
	++YYCURSOR;
	{ out.prt('m'); goto yyc_l; }
yy172:
	++YYCURSOR;
	{ out.prt('s'); goto yyc_l; }
yy173:
	++YYCURSOR;
	{ out.prt('p'); goto yyc_l; }
yy174:
	++YYCURSOR;
	{ out.prt('e'); goto yyc_l; }
yy175:
	++YYCURSOR;
	{ out.prt(':'); goto yyc_l; }
yy176:
	++YYCURSOR;
	{ out.prt('h'); goto yyc_l; }
yy177:
	++YYCURSOR;
	{ out.prt('*'); goto yyc_l; }
yy178:
	++YYCURSOR;
	{ out.prt('o'); goto yyc_l; }
yy179:
	++YYCURSOR;
	{ out.prt('!'); goto yyc_l; }
yy180:
	++YYCURSOR;
	{ out.prt('r'); goto yyc_l; }
yy181:
	++YYCURSOR;
	{ out.prt('d'); goto yyc_l; }
yy182:
	++YYCURSOR;
	{ out.prt('j'); goto yyc_l; }
yy183:
	++YYCURSOR;
	{ out.prt('g'); goto yyc_l; }
yy184:
	++YYCURSOR;
	{ out.prt('n'); goto yyc_l; }
yy185:
	++YYCURSOR;
	{ out.prt('t'); goto yyc_l; }
yy186:
	++YYCURSOR;
	{ out.prt('q'); goto yyc_l; }
yy187:
	++YYCURSOR;
	{ out.caps = true; goto yyc_l; }
yy188:
	++YYCURSOR;
	{ out.prt('-'); goto yyc_l; }
yy189:
	++YYCURSOR;
	{ out.prt('u'); goto yyc_l; }
yy190:
	++YYCURSOR;
	{ out.prt('?'); goto yyc_l; }
yy191:
	++YYCURSOR;
	{ out.prt('v'); goto yyc_l; }
yy192:
	++YYCURSOR;
	{ out.prt('x'); goto yyc_l; }
yy193:
	++YYCURSOR;
	goto yyc_l;
yy194:
	++YYCURSOR;
	{ out.prt('.'); goto yyc_l; }
yy195:
	++YYCURSOR;
	{ out.prt('z'); goto yyc_l; }
yy196:
	++YYCURSOR;
	{ out.prt('w'); goto yyc_l; }
yy197:
	++YYCURSOR;
	c = yycn;
	goto yyc_n;
yy198:
	++YYCURSOR;
	{ out.prt('y'); goto yyc_l; }
yy199:
	++YYCURSOR;
	goto yy159;
/* *********************************** */
yyc_n:
	yych = *YYCURSOR;
	if (yych <= 0x00002812) {
		if (yych <= 0x00002803) {
			if (yych <= ' ') {
				if (yych <= '\t') {
					if (yych >= 0x00000001) goto yy201;
				} else {
					if (yych <= '\n') goto yy202;
					if (yych <= 0x0000001F) goto yy201;
					goto yy204;
				}
			} else {
				if (yych <= 0x00002800) {
					if (yych <= 0x000027FF) goto yy201;
					goto yy204;
				} else {
					if (yych <= 0x00002801) goto yy205;
					if (yych <= 0x00002802) goto yy206;
					goto yy207;
				}
			}
		} else {
			if (yych <= 0x00002809) {
				if (yych <= 0x00002805) {
					if (yych <= 0x00002804) goto yy208;
					goto yy201;
				} else {
					if (yych <= 0x00002806) goto yy209;
					if (yych <= 0x00002808) goto yy201;
					goto yy210;
				}
			} else {
				if (yych <= 0x0000280B) {
					if (yych <= 0x0000280A) goto yy211;
					goto yy212;
				} else {
					if (yych <= 0x00002810) goto yy201;
					if (yych <= 0x00002811) goto yy213;
					goto yy214;
				}
			}
		}
	} else {
		if (yych <= 0x00002820) {
			if (yych <= 0x00002818) {
				if (yych <= 0x00002814) {
					if (yych <= 0x00002813) goto yy215;
					goto yy216;
				} else {
					if (yych == 0x00002816) goto yy217;
					goto yy201;
				}
			} else {
				if (yych <= 0x0000281A) {
					if (yych <= 0x00002819) goto yy218;
					goto yy219;
				} else {
					if (yych <= 0x0000281B) goto yy220;
					if (yych <= 0x0000281F) goto yy201;
					goto yy221;
				}
			}
		} else {
			if (yych <= 0x0000282F) {
				if (yych <= 0x00002824) {
					if (yych <= 0x00002823) goto yy201;
					goto yy222;
				} else {
					if (yych == 0x00002826) goto yy223;
					goto yy201;
				}
			} else {
				if (yych <= 0x00002832) {
					if (yych <= 0x00002830) goto yy224;
					if (yych <= 0x00002831) goto yy201;
					goto yy225;
				} else {
					if (yych == 0x0000283C) goto yy226;
					goto yy201;
				}
			}
		}
	}
	++YYCURSOR;
	{ if (YYCURSOR != in.str + in.len + 1) out.err(); return; }
yy201:
	++YYCURSOR;
	{ out.err(); return; }
yy202:
	yych = *++YYCURSOR;
	if (yych == '\r') goto yy227;
yy203:
	{ out.prt('\n'); goto yyc_l; }
yy204:
	++YYCURSOR;
	{ out.prt(' '); goto yyc_l; }
yy205:
	++YYCURSOR;
	{ out.prt('1'); goto yyc_n; }
yy206:
	++YYCURSOR;
	{ out.prt(','); goto yyc_l; }
yy207:
	++YYCURSOR;
	{ out.prt('2'); goto yyc_n; }
yy208:
	++YYCURSOR;
	{ out.prt('\''); goto yyc_l; }
yy209:
	++YYCURSOR;
	{ out.prt(';'); goto yyc_l; }
yy210:
	++YYCURSOR;
	{ out.prt('3'); goto yyc_n; }
yy211:
	++YYCURSOR;
	{ out.prt('9'); goto yyc_n; }
yy212:
	++YYCURSOR;
	{ out.prt('6'); goto yyc_n; }
yy213:
	++YYCURSOR;
	{ out.prt('5'); goto yyc_n; }
yy214:
	++YYCURSOR;
	{ out.prt(':'); goto yyc_l; }
yy215:
	++YYCURSOR;
	{ out.prt('8'); goto yyc_n; }
yy216:
	++YYCURSOR;
	{ out.prt('*'); goto yyc_l; }
yy217:
	++YYCURSOR;
	{ out.prt('!'); goto yyc_l; }
yy218:
	++YYCURSOR;
	{ out.prt('4'); goto yyc_n; }
yy219:
	++YYCURSOR;
	{ out.prt('0'); goto yyc_n; }
yy220:
	++YYCURSOR;
	{ out.prt('7'); goto yyc_n; }
yy221:
	++YYCURSOR;
	{ out.caps = true; goto yyc_l; }
yy222:
	++YYCURSOR;
	{ out.prt('-'); goto yyc_l; }
yy223:
	++YYCURSOR;
	{ out.prt('?'); goto yyc_l; }
yy224:
	++YYCURSOR;
	c = yycl;
	goto yyc_l;
yy225:
	++YYCURSOR;
	{ out.prt('.'); goto yyc_l; }
yy226:
	++YYCURSOR;
	goto yyc_n;
yy227:
	++YYCURSOR;
	goto yy203;
}

}

static void lex_ucs2(const iucs2_t & in)
{
    const unsigned short *YYCURSOR = in.str;
    int c = yycl;
    out_t out;
    
{
	unsigned int yych;
	if (c < 1) {
		goto yyc_l;
	} else {
		goto yyc_n;
	}
/* *********************************** */
yyc_l:
	yych = *YYCURSOR;
	if (yych <= 0x2816) {
		if (yych <= 0x2807) {
			if (yych <= 0x2800) {
				if (yych <= '\n') {
					if (yych <= 0x0000) goto yy229;
					if (yych <= '\t') goto yy230;
					goto yy231;
				} else {
					if (yych == ' ') goto yy233;
					if (yych <= 0x27FF) goto yy230;
					goto yy233;
				}
			} else {
				if (yych <= 0x2803) {
					if (yych <= 0x2801) goto yy234;
					if (yych <= 0x2802) goto yy235;
					goto yy236;
				} else {
					if (yych <= 0x2804) goto yy237;
					if (yych <= 0x2805) goto yy238;
					if (yych <= 0x2806) goto yy239;
					goto yy240;
				}
			}
		} else {
			if (yych <= 0x280E) {
				if (yych <= 0x280A) {
					if (yych <= 0x2808) goto yy230;
					if (yych <= 0x2809) goto yy241;
					goto yy242;
				} else {
					if (yych <= 0x280B) goto yy243;
					if (yych <= 0x280C) goto yy230;
					if (yych <= 0x280D) goto yy244;
					goto yy245;
				}
			} else {
				if (yych <= 0x2812) {
					if (yych <= 0x280F) goto yy246;
					if (yych <= 0x2810) goto yy230;
					if (yych <= 0x2811) goto yy247;
					goto yy248;
				} else {
					if (yych <= 0x2813) goto yy249;
					if (yych <= 0x2814) goto yy250;
					if (yych <= 0x2815) goto yy251;
					goto yy252;
				}
			}
		}
	} else {
		if (yych <= 0x2826) {
			if (yych <= 0x281D) {
				if (yych <= 0x2819) {
					if (yych <= 0x2817) goto yy253;
					if (yych <= 0x2818) goto yy230;
					goto yy254;
				} else {
					if (yych <= 0x281A) goto yy255;
					if (yych <= 0x281B) goto yy256;
					if (yych <= 0x281C) goto yy230;
					goto yy257;
				}
			} else {
				if (yych <= 0x2820) {
					if (yych <= 0x281E) goto yy258;
					if (yych <= 0x281F) goto yy259;
					goto yy260;
				} else {
					if (yych <= 0x2823) goto yy230;
					if (yych <= 0x2824) goto yy261;
					if (yych <= 0x2825) goto yy262;
					goto yy263;
				}
			}
		} else {
			if (yych <= 0x2832) {
				if (yych <= 0x282D) {
					if (yych <= 0x2827) goto yy264;
					if (yych <= 0x282C) goto yy230;
					goto yy265;
				} else {
					if (yych == 0x2830) goto yy266;
					if (yych <= 0x2831) goto yy230;
					goto yy267;
				}
			} else {
				if (yych <= 0x283A) {
					if (yych == 0x2835) goto yy268;
					if (yych <= 0x2839) goto yy230;
					goto yy269;
				} else {
					if (yych <= 0x283B) goto yy230;
					if (yych <= 0x283C) goto yy270;
					if (yych <= 0x283D) goto yy271;
					goto yy230;
				}
			}
		}
	}
yy229:
	++YYCURSOR;
	{ if (YYCURSOR != in.str + in.len + 1) out.err(); return; }
yy230:
	++YYCURSOR;
	{ out.err(); return; }
yy231:
	yych = *++YYCURSOR;
	if (yych == '\r') goto yy272;
yy232:
	{ out.prt('\n'); goto yyc_l; }
yy233:
	++YYCURSOR;
	{ out.prt(' '); goto yyc_l; }
yy234:
	++YYCURSOR;
	{ out.prt('a'); goto yyc_l; }
yy235:
	++YYCURSOR;
	{ out.prt(','); goto yyc_l; }
yy236:
	++YYCURSOR;
	{ out.prt('b'); goto yyc_l; }
yy237:
	++YYCURSOR;
	{ out.prt('\''); goto yyc_l; }
yy238:
	++YYCURSOR;
	{ out.prt('k'); goto yyc_l; }
yy239:
	++YYCURSOR;
	{ out.prt(';'); goto yyc_l; }
yy240:
	++YYCURSOR;
	{ out.prt('l'); goto yyc_l; }
yy241:
	++YYCURSOR;
	{ out.prt('c'); goto yyc_l; }
yy242:
	++YYCURSOR;
	{ out.prt('i'); goto yyc_l; }
yy243:
	++YYCURSOR;
	{ out.prt('f'); goto yyc_l; }
yy244:
	++YYCURSOR;
	{ out.prt('m'); goto yyc_l; }
yy245:
	++YYCURSOR;
	{ out.prt('s'); goto yyc_l; }
yy246:
	++YYCURSOR;
	{ out.prt('p'); goto yyc_l; }
yy247:
	++YYCURSOR;
	{ out.prt('e'); goto yyc_l; }
yy248:
	++YYCURSOR;
	{ out.prt(':'); goto yyc_l; }
yy249:
	++YYCURSOR;
	{ out.prt('h'); goto yyc_l; }
yy250:
	++YYCURSOR;
	{ out.prt('*'); goto yyc_l; }
yy251:
	++YYCURSOR;
	{ out.prt('o'); goto yyc_l; }
yy252:
	++YYCURSOR;
	{ out.prt('!'); goto yyc_l; }
yy253:
	++YYCURSOR;
	{ out.prt('r'); goto yyc_l; }
yy254:
	++YYCURSOR;
	{ out.prt('d'); goto yyc_l; }
yy255:
	++YYCURSOR;
	{ out.prt('j'); goto yyc_l; }
yy256:
	++YYCURSOR;
	{ out.prt('g'); goto yyc_l; }
yy257:
	++YYCURSOR;
	{ out.prt('n'); goto yyc_l; }
yy258:
	++YYCURSOR;
	{ out.prt('t'); goto yyc_l; }
yy259:
	++YYCURSOR;
	{ out.prt('q'); goto yyc_l; }
yy260:
	++YYCURSOR;
	{ out.caps = true; goto yyc_l; }
yy261:
	++YYCURSOR;
	{ out.prt('-'); goto yyc_l; }
yy262:
	++YYCURSOR;
	{ out.prt('u'); goto yyc_l; }
yy263:
	++YYCURSOR;
	{ out.prt('?'); goto yyc_l; }
yy264:
	++YYCURSOR;
	{ out.prt('v'); goto yyc_l; }
yy265:
	++YYCURSOR;
	{ out.prt('x'); goto yyc_l; }
yy266:
	++YYCURSOR;
	goto yyc_l;
yy267:
	++YYCURSOR;
	{ out.prt('.'); goto yyc_l; }
yy268:
	++YYCURSOR;
	{ out.prt('z'); goto yyc_l; }
yy269:
	++YYCURSOR;
	{ out.prt('w'); goto yyc_l; }
yy270:
	++YYCURSOR;
	c = yycn;
	goto yyc_n;
yy271:
	++YYCURSOR;
	{ out.prt('y'); goto yyc_l; }
yy272:
	++YYCURSOR;
	goto yy232;
/* *********************************** */
yyc_n:
	yych = *YYCURSOR;
	if (yych <= 0x2812) {
		if (yych <= 0x2803) {
			if (yych <= ' ') {
				if (yych <= '\t') {
					if (yych >= 0x0001) goto yy274;
				} else {
					if (yych <= '\n') goto yy275;
					if (yych <= 0x001F) goto yy274;
					goto yy277;
				}
			} else {
				if (yych <= 0x2800) {
					if (yych <= 0x27FF) goto yy274;
					goto yy277;
				} else {
					if (yych <= 0x2801) goto yy278;
					if (yych <= 0x2802) goto yy279;
					goto yy280;
				}
			}
		} else {
			if (yych <= 0x2809) {
				if (yych <= 0x2805) {
					if (yych <= 0x2804) goto yy281;
					goto yy274;
				} else {
					if (yych <= 0x2806) goto yy282;
					if (yych <= 0x2808) goto yy274;
					goto yy283;
				}
			} else {
				if (yych <= 0x280B) {
					if (yych <= 0x280A) goto yy284;
					goto yy285;
				} else {
					if (yych <= 0x2810) goto yy274;
					if (yych <= 0x2811) goto yy286;
					goto yy287;
				}
			}
		}
	} else {
		if (yych <= 0x2820) {
			if (yych <= 0x2818) {
				if (yych <= 0x2814) {
					if (yych <= 0x2813) goto yy288;
					goto yy289;
				} else {
					if (yych == 0x2816) goto yy290;
					goto yy274;
				}
			} else {
				if (yych <= 0x281A) {
					if (yych <= 0x2819) goto yy291;
					goto yy292;
				} else {
					if (yych <= 0x281B) goto yy293;
					if (yych <= 0x281F) goto yy274;
					goto yy294;
				}
			}
		} else {
			if (yych <= 0x282F) {
				if (yych <= 0x2824) {
					if (yych <= 0x2823) goto yy274;
					goto yy295;
				} else {
					if (yych == 0x2826) goto yy296;
					goto yy274;
				}
			} else {
				if (yych <= 0x2832) {
					if (yych <= 0x2830) goto yy297;
					if (yych <= 0x2831) goto yy274;
					goto yy298;
				} else {
					if (yych == 0x283C) goto yy299;
					goto yy274;
				}
			}
		}
	}
	++YYCURSOR;
	{ if (YYCURSOR != in.str + in.len + 1) out.err(); return; }
yy274:
	++YYCURSOR;
	{ out.err(); return; }
yy275:
	yych = *++YYCURSOR;
	if (yych == '\r') goto yy300;
yy276:
	{ out.prt('\n'); goto yyc_l; }
yy277:
	++YYCURSOR;
	{ out.prt(' '); goto yyc_l; }
yy278:
	++YYCURSOR;
	{ out.prt('1'); goto yyc_n; }
yy279:
	++YYCURSOR;
	{ out.prt(','); goto yyc_l; }
yy280:
	++YYCURSOR;
	{ out.prt('2'); goto yyc_n; }
yy281:
	++YYCURSOR;
	{ out.prt('\''); goto yyc_l; }
yy282:
	++YYCURSOR;
	{ out.prt(';'); goto yyc_l; }
yy283:
	++YYCURSOR;
	{ out.prt('3'); goto yyc_n; }
yy284:
	++YYCURSOR;
	{ out.prt('9'); goto yyc_n; }
yy285:
	++YYCURSOR;
	{ out.prt('6'); goto yyc_n; }
yy286:
	++YYCURSOR;
	{ out.prt('5'); goto yyc_n; }
yy287:
	++YYCURSOR;
	{ out.prt(':'); goto yyc_l; }
yy288:
	++YYCURSOR;
	{ out.prt('8'); goto yyc_n; }
yy289:
	++YYCURSOR;
	{ out.prt('*'); goto yyc_l; }
yy290:
	++YYCURSOR;
	{ out.prt('!'); goto yyc_l; }
yy291:
	++YYCURSOR;
	{ out.prt('4'); goto yyc_n; }
yy292:
	++YYCURSOR;
	{ out.prt('0'); goto yyc_n; }
yy293:
	++YYCURSOR;
	{ out.prt('7'); goto yyc_n; }
yy294:
	++YYCURSOR;
	{ out.caps = true; goto yyc_l; }
yy295:
	++YYCURSOR;
	{ out.prt('-'); goto yyc_l; }
yy296:
	++YYCURSOR;
	{ out.prt('?'); goto yyc_l; }
yy297:
	++YYCURSOR;
	c = yycl;
	goto yyc_l;
yy298:
	++YYCURSOR;
	{ out.prt('.'); goto yyc_l; }
yy299:
	++YYCURSOR;
	goto yyc_n;
yy300:
	++YYCURSOR;
	goto yy276;
}

}

int main()
{
    FILE *f;

    assert(f = fopen("braille.utf8.txt", "rb"));
    fprintf(stderr, "utf8:\n");
    iutf8_t in8(f);
    lex_utf8(in8);
    fclose(f);

    assert(f = fopen("braille.utf16.txt", "rb"));
    fprintf(stderr, "utf16:\n");
    iutf16_t in16(f);
    lex_utf16(in16);
    fclose(f);

    assert(f = fopen("braille.utf32.txt", "rb"));
    fprintf(stderr, "utf32:\n");
    iutf32_t in32(f);
    lex_utf32(in32);
    fclose(f);

    assert(f = fopen("braille.ucs2.txt", "rb"));
    fprintf(stderr, "ucs2:\n");
    iucs2_t in2(f);
    lex_ucs2(in2);
    fclose(f);

    return 0;
}
