/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.S9apiUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;

public class WritableDocument
implements WritablePipe {
    private Serializer serializer = null;
    private int writeCount = 0;
    private String uri = null;
    private URI journal = null;
    private XProcRuntime runtime = null;
    private Serialization serial = null;
    private boolean writeSeqOk = false;
    private Step writer = null;
    private OutputStream ostream = null;

    public WritableDocument(XProcRuntime xProcRuntime, String string, Serialization serialization) {
        this.runtime = xProcRuntime;
        this.uri = string;
        if (serialization == null) {
            this.serial = new Serialization(xProcRuntime, null);
            this.serial.setIndent(xProcRuntime.getDebug());
        } else {
            this.serial = serialization;
        }
    }

    public WritableDocument(XProcRuntime xProcRuntime, String string, Serialization serialization, OutputStream outputStream) {
        this.runtime = xProcRuntime;
        this.uri = string;
        this.ostream = outputStream;
        if (serialization == null) {
            this.serial = new Serialization(xProcRuntime, null);
            this.serial.setIndent(xProcRuntime.getDebug());
        } else {
            this.serial = serialization;
        }
    }

    @Override
    public void canWriteSequence(boolean bl) {
        this.writeSeqOk = bl;
    }

    @Override
    public boolean writeSequence() {
        return this.writeSeqOk;
    }

    @Override
    public void resetWriter() {
        throw new UnsupportedOperationException("You can't resetWriter a WritableDocument");
    }

    @Override
    public void close() {
        if (this.ostream != null) {
            try {
                this.ostream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage(), iOException);
            }
        }
    }

    @Override
    public void setWriter(Step step) {
        this.writer = step;
    }

    @Override
    public void write(XdmNode xdmNode) {
        try {
            Object object;
            this.serializer = new Serializer();
            this.serializer.setOutputProperty(Serializer.Property.BYTE_ORDER_MARK, this.serial.getByteOrderMark() ? "yes" : "no");
            if (this.serial.getDoctypePublic() != null) {
                this.serializer.setOutputProperty(Serializer.Property.DOCTYPE_PUBLIC, this.serial.getDoctypePublic());
            }
            if (this.serial.getDoctypeSystem() != null) {
                this.serializer.setOutputProperty(Serializer.Property.DOCTYPE_SYSTEM, this.serial.getDoctypeSystem());
            }
            if (this.serial.getEncoding() != null) {
                this.serializer.setOutputProperty(Serializer.Property.ENCODING, this.serial.getEncoding());
            }
            this.serializer.setOutputProperty(Serializer.Property.ESCAPE_URI_ATTRIBUTES, this.serial.getEscapeURIAttributes() ? "yes" : "no");
            this.serializer.setOutputProperty(Serializer.Property.INCLUDE_CONTENT_TYPE, this.serial.getIncludeContentType() ? "yes" : "no");
            this.serializer.setOutputProperty(Serializer.Property.INDENT, this.serial.getIndent() ? "yes" : "no");
            if (this.serial.getMediaType() != null) {
                this.serializer.setOutputProperty(Serializer.Property.MEDIA_TYPE, this.serial.getMediaType());
            }
            if (this.serial.getMethod() != null) {
                this.serializer.setOutputProperty(Serializer.Property.METHOD, this.serial.getMethod().getLocalName());
            }
            if (this.serial.getNormalizationForm() != null) {
                this.serializer.setOutputProperty(Serializer.Property.NORMALIZATION_FORM, this.serial.getNormalizationForm());
            }
            this.serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, this.serial.getOmitXMLDeclaration() ? "yes" : "no");
            if (this.serial.getStandalone() != null) {
                object = this.serial.getStandalone();
                if ("true".equals(object)) {
                    this.serializer.setOutputProperty(Serializer.Property.STANDALONE, "yes");
                } else if ("false".equals(object)) {
                    this.serializer.setOutputProperty(Serializer.Property.STANDALONE, "no");
                }
            }
            this.serializer.setOutputProperty(Serializer.Property.UNDECLARE_PREFIXES, this.serial.getUndeclarePrefixes() ? "yes" : "no");
            if (this.serial.getVersion() != null) {
                this.serializer.setOutputProperty(Serializer.Property.VERSION, this.serial.getVersion());
            }
            if (this.ostream != null) {
                this.serializer.setOutputStream(this.ostream);
            } else if (this.uri == null) {
                this.serializer.setOutputStream((OutputStream)System.out);
            } else {
                try {
                    object = new URI(this.uri);
                    if ("file".equals(((URI)object).getScheme())) {
                        this.runtime.finest(null, null, "Attempt to write file: " + this.uri);
                        File file = new File(this.decodeUTF8(((URI)object).toURL().getFile()));
                        this.serializer.setOutputFile(file);
                    } else {
                        this.runtime.finest(null, null, "Attempt to write: " + this.uri);
                        URL uRL = new URL(this.uri);
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setDoOutput(true);
                        this.ostream = uRLConnection.getOutputStream();
                        this.serializer.setOutputStream(this.ostream);
                    }
                }
                catch (IOException iOException) {
                    this.runtime.error(iOException);
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.runtime.error(uRISyntaxException);
                }
            }
            S9apiUtils.serialize(this.runtime, xdmNode, this.serializer);
            if (this.uri == null && this.runtime.getDebug()) {
                System.out.println("\n--<document boundary>--------------------------------------------------------------------------");
            }
        }
        catch (SaxonApiException saxonApiException) {
            if (this.runtime.getDebug()) {
                saxonApiException.printStackTrace();
            }
            throw new XProcException(saxonApiException);
        }
        if (this.writer != null) {
            this.runtime.finest(null, this.writer.getNode(), this.writer.getName() + " wrote '" + (xdmNode == null ? "null" : xdmNode.getBaseURI()));
        }
    }

    public int documentsWritten() {
        return this.writeCount;
    }

    public int documentsRead() {
        return 1;
    }

    private String decodeUTF8(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(37) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = -1;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            n2 = c;
            switch (n2) {
                case 37: {
                    if (i + 2 >= string.length()) break;
                    int n6 = (Character.isDigit((char)(n2 = (int)string.charAt(++i))) ? n2 - 48 : 10 + Character.toLowerCase((char)n2) - 97) & 0xF;
                    n2 = string.charAt(++i);
                    int n7 = (Character.isDigit((char)n2) ? n2 - 48 : 10 + Character.toLowerCase((char)n2) - 97) & 0xF;
                    n3 = n6 << 4 | n7;
                    bl = true;
                    break;
                }
                default: {
                    n3 = n2;
                    bl = false;
                }
            }
            if (bl) {
                if ((n3 & 0xC0) == 128) {
                    n4 = n4 << 6 | n3 & 0x3F;
                    if (--n5 != 0) continue;
                    stringBuilder.append((char)n4);
                    continue;
                }
                if ((n3 & 0x80) == 0) {
                    stringBuilder.append((char)n3);
                    continue;
                }
                if ((n3 & 0xE0) == 192) {
                    n4 = n3 & 0x1F;
                    n5 = 1;
                    continue;
                }
                if ((n3 & 0xF0) == 224) {
                    n4 = n3 & 0xF;
                    n5 = 2;
                    continue;
                }
                if ((n3 & 0xF8) == 240) {
                    n4 = n3 & 7;
                    n5 = 3;
                    continue;
                }
                if ((n3 & 0xFC) == 248) {
                    n4 = n3 & 3;
                    n5 = 4;
                    continue;
                }
                n4 = n3 & 1;
                n5 = 5;
                continue;
            }
            stringBuilder.append(c);
            n5 = -1;
        }
        return stringBuilder.toString();
    }
}

